/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.utils;

import com.jokerhub.paper.plugin.orzmc.OrzMC;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;

public final class OrzTextStyles {
    private static TextColor colorOrDefault(String path, String defaultHex) {
        try {
            String hex = OrzMC.plugin().configManager.getConfig("config").getString(path, defaultHex);
            if (hex == null || hex.isEmpty()) {
                return TextColor.fromCSSHexString((String)defaultHex);
            }
            return TextColor.fromCSSHexString((String)hex);
        }
        catch (Exception ignored) {
            return TextColor.fromCSSHexString((String)defaultHex);
        }
    }

    public static TextColor colorAlertTnt() {
        return OrzTextStyles.colorOrDefault("styles.colors.tnt_alert", "#FF5555");
    }

    public static TextColor colorAlertExplosion() {
        return OrzTextStyles.colorOrDefault("styles.colors.explosion_alert", "#FFAA00");
    }

    public static TextColor colorCoord() {
        return OrzTextStyles.colorOrDefault("styles.colors.coord", "#55FF55");
    }

    public static TextColor colorSuccess() {
        return OrzTextStyles.colorOrDefault("styles.colors.success", "#00FF00");
    }

    public static TextColor colorInfo() {
        return OrzTextStyles.colorOrDefault("styles.colors.info", "#55AAFF");
    }

    public static TextColor colorWarn() {
        return OrzTextStyles.colorOrDefault("styles.colors.warn", "#FFAA00");
    }

    public static TextColor colorError() {
        return OrzTextStyles.colorOrDefault("styles.colors.error", "#FF5555");
    }

    public static TextColor colorPlayer() {
        return OrzTextStyles.colorOrDefault("styles.colors.player", "#FF5555");
    }

    public static TextColor colorUnknown() {
        return OrzTextStyles.colorOrDefault("styles.colors.unknown", "#AAAAAA");
    }

    public static TextComponent prefix(String text, TextColor color) {
        return (TextComponent)Component.text((String)text).color(color);
    }

    public static TextComponent tntPrefix() {
        return OrzTextStyles.prefix("[TNT\u8b66\u62a5] ", OrzTextStyles.colorAlertTnt());
    }

    public static TextComponent explosionPrefix() {
        return OrzTextStyles.prefix("[\u7206\u70b8\u8b66\u62a5] ", OrzTextStyles.colorAlertExplosion());
    }

    public static TextComponent tpbowPrefix() {
        return (TextComponent)Component.text((String)"[\u4f20\u9001\u5f13]").color(OrzTextStyles.colorSuccess());
    }

    public static TextComponent coordComponent(String locString) {
        return (TextComponent)((TextComponent)((TextComponent)Component.text((String)locString).color(OrzTextStyles.colorCoord())).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"\u70b9\u51fb\u590d\u5236\u5750\u6807")))).clickEvent(ClickEvent.copyToClipboard((String)locString.trim()));
    }

    public static TextComponent success(String content) {
        return (TextComponent)Component.text((String)content).color(OrzTextStyles.colorSuccess());
    }

    public static TextComponent info(String content) {
        return (TextComponent)Component.text((String)content).color(OrzTextStyles.colorInfo());
    }

    public static TextComponent warn(String content) {
        return (TextComponent)Component.text((String)content).color(OrzTextStyles.colorWarn());
    }

    public static TextComponent error(String content) {
        return (TextComponent)Component.text((String)content).color(OrzTextStyles.colorError());
    }

    public static String coordString(Location location) {
        return String.format(" [%s] %d %d %d ", location.getWorld().getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public static TextComponent playerName(String name) {
        return (TextComponent)Component.text((String)name).color(OrzTextStyles.colorPlayer());
    }

    public static TextComponent unknownLabel() {
        return (TextComponent)Component.text((String)"\u672a\u77e5\u73a9\u5bb6").color(OrzTextStyles.colorUnknown());
    }
}

