/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.orzmc.world;

import com.jokerhub.orzmc.mca.McaEntry;
import com.jokerhub.orzmc.patterns.ChunkPattern;
import com.jokerhub.orzmc.world.DimensionResult;
import com.jokerhub.orzmc.world.FileSystem;
import com.jokerhub.orzmc.world.McaIOFactory;
import com.jokerhub.orzmc.world.McaReaderLike;
import com.jokerhub.orzmc.world.McaUtils;
import com.jokerhub.orzmc.world.McaWriterLike;
import com.jokerhub.orzmc.world.ProgressEvent;
import com.jokerhub.orzmc.world.ProgressStage;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0092\u0001\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u001e\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d\u00a8\u0006\u001e"}, d2={"Lcom/jokerhub/orzmc/world/DimensionProcessor;", "", "()V", "process", "Lcom/jokerhub/orzmc/world/DimensionResult;", "fs", "Lcom/jokerhub/orzmc/world/FileSystem;", "ioFactory", "Lcom/jokerhub/orzmc/world/McaIOFactory;", "inputDim", "Ljava/nio/file/Path;", "targetDim", "patterns", "", "Lcom/jokerhub/orzmc/patterns/ChunkPattern;", "onError", "Lkotlin/Function3;", "", "", "onProgress", "Lkotlin/Function1;", "Lcom/jokerhub/orzmc/world/ProgressEvent;", "totalChunks", "", "progressInterval", "progressIntervalMs", "processedCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "strict", "", "core"})
@SourceDebugExtension(value={"SMAP\nDimensionProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DimensionProcessor.kt\ncom/jokerhub/orzmc/world/DimensionProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n766#2:132\n857#2,2:133\n1855#2,2:135\n*S KotlinDebug\n*F\n+ 1 DimensionProcessor.kt\ncom/jokerhub/orzmc/world/DimensionProcessor\n*L\n37#1:132\n37#1:133,2\n37#1:135,2\n*E\n"})
public final class DimensionProcessor {
    @NotNull
    public static final DimensionProcessor INSTANCE = new DimensionProcessor();

    private DimensionProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final DimensionResult process(@NotNull FileSystem fs, @NotNull McaIOFactory ioFactory, @NotNull Path inputDim, @NotNull Path targetDim, @NotNull List<? extends ChunkPattern> patterns, @NotNull Function3<? super Path, ? super String, ? super String, Unit> onError, @Nullable Function1<? super ProgressEvent, Unit> onProgress, long totalChunks, long progressInterval, long progressIntervalMs, @NotNull AtomicLong processedCounter, boolean strict) {
        long removedTotal;
        block76: {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(fs, "fs");
            Intrinsics.checkNotNullParameter(ioFactory, "ioFactory");
            Intrinsics.checkNotNullParameter(inputDim, "inputDim");
            Intrinsics.checkNotNullParameter(targetDim, "targetDim");
            Intrinsics.checkNotNullParameter(patterns, "patterns");
            Intrinsics.checkNotNullParameter(onError, "onError");
            Intrinsics.checkNotNullParameter(processedCounter, "processedCounter");
            removedTotal = 0L;
            fs.createDirectories(targetDim);
            Path regionDir = inputDim.resolve("region");
            Path entitiesDir = inputDim.resolve("entities");
            Path poiDir = inputDim.resolve("poi");
            Path path = targetDim.resolve("region");
            Intrinsics.checkNotNullExpressionValue(path, "resolve(...)");
            fs.createDirectories(path);
            Intrinsics.checkNotNull(entitiesDir);
            if (fs.isDirectory(entitiesDir)) {
                Path path2 = targetDim.resolve("entities");
                Intrinsics.checkNotNullExpressionValue(path2, "resolve(...)");
                fs.createDirectories(path2);
            }
            Intrinsics.checkNotNull(poiDir);
            if (fs.isDirectory(poiDir)) {
                Path path3 = targetDim.resolve("poi");
                Intrinsics.checkNotNullExpressionValue(path3, "resolve(...)");
                fs.createDirectories(path3);
            }
            Function1<? super ProgressEvent, Unit> function1 = onProgress;
            if (function1 != null) {
                function1.invoke(new ProgressEvent(ProgressStage.DimensionStart, null, null, ((Object)inputDim).toString(), null));
            }
            boolean useTime = progressIntervalMs > 0L;
            long lastEmit = 0L;
            lastEmit = System.currentTimeMillis();
            Intrinsics.checkNotNull(regionDir);
            Iterable $this$filter$iv = fs.list(regionDir);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Path p = (Path)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.endsWith$default(((Object)p).toString(), ".mca", false, 2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                McaWriterLike mcaWriterLike;
                McaWriterLike ew;
                McaWriterLike mcaWriterLike2;
                McaReaderLike _32;
                McaReaderLike mcaReaderLike;
                McaReaderLike mcaReaderLike2;
                Path rf = (Path)element$iv;
                boolean bl = false;
                Function1<? super ProgressEvent, Unit> function12 = onProgress;
                if (function12 != null) {
                    function12.invoke(new ProgressEvent(ProgressStage.RegionStart, null, null, ((Object)rf).toString(), null));
                }
                if (!McaUtils.INSTANCE.isValidMca(fs, rf)) {
                    onError.invoke(rf, "MCA", "MCA \u6587\u4ef6\u635f\u574f\u6216\u4e0d\u5b8c\u6574");
                    if (!strict) continue;
                }
                String name = ((Object)rf.getFileName()).toString();
                Path efile = entitiesDir.resolve(name);
                Path pfile = poiDir.resolve(name);
                try {
                    mcaReaderLike2 = ioFactory.openReader(fs, rf);
                }
                catch (Exception _2) {
                    onError.invoke(rf, "MCA", "\u65e0\u6cd5\u8bfb\u53d6 MCA \u6587\u4ef6");
                    continue;
                }
                McaReaderLike cr = mcaReaderLike2;
                Path path4 = targetDim.resolve("region").resolve(name);
                Intrinsics.checkNotNullExpressionValue(path4, "resolve(...)");
                McaWriterLike cw = ioFactory.createWriter(fs, path4);
                try {
                    Intrinsics.checkNotNull(efile);
                    mcaReaderLike = Files.isRegularFile(fs.toRealPath(efile), new LinkOption[0]) && McaUtils.INSTANCE.isValidMca(fs, efile) ? ioFactory.openReader(fs, efile) : null;
                }
                catch (Exception _32) {
                    Intrinsics.checkNotNull(efile);
                    onError.invoke(efile, "Entities", "\u8bfb\u53d6\u5b9e\u4f53\u5931\u8d25");
                    mcaReaderLike = null;
                }
                McaReaderLike er = mcaReaderLike;
                try {
                    Intrinsics.checkNotNull(pfile);
                    _32 = Files.isRegularFile(fs.toRealPath(pfile), new LinkOption[0]) && McaUtils.INSTANCE.isValidMca(fs, pfile) ? ioFactory.openReader(fs, pfile) : null;
                }
                catch (Exception _4) {
                    Intrinsics.checkNotNull(pfile);
                    onError.invoke(pfile, "Poi", "\u8bfb\u53d6 POI \u5931\u8d25");
                    _32 = null;
                }
                McaReaderLike pr = _32;
                if (er != null) {
                    Path path5 = targetDim.resolve("entities").resolve(name);
                    Intrinsics.checkNotNullExpressionValue(path5, "resolve(...)");
                    mcaWriterLike2 = ioFactory.createWriter(fs, path5);
                } else {
                    mcaWriterLike2 = ew = null;
                }
                if (pr != null) {
                    Path path6 = targetDim.resolve("poi").resolve(name);
                    Intrinsics.checkNotNullExpressionValue(path6, "resolve(...)");
                    mcaWriterLike = ioFactory.createWriter(fs, path6);
                } else {
                    mcaWriterLike = null;
                }
                McaWriterLike pw = mcaWriterLike;
                try {
                    List list;
                    try {
                        list = cr.entries();
                    }
                    catch (Exception _5) {
                        onError.invoke(rf, "Entries", "\u8bfb\u53d6\u533a\u5757\u6761\u76ee\u5931\u8d25");
                        list = CollectionsKt.emptyList();
                    }
                    List<McaEntry> entries = list;
                    for (McaEntry entry : entries) {
                        block75: {
                            boolean keep = false;
                            for (ChunkPattern chunkPattern : patterns) {
                                try {
                                    if (!chunkPattern.matches(entry)) continue;
                                    keep = true;
                                    break;
                                }
                                catch (Exception _6) {
                                    onError.invoke(rf, "Pattern", "\u5339\u914d\u6a21\u5f0f\u5931\u8d25");
                                }
                            }
                            if (keep) {
                                try {
                                    cw.writeEntry(entry);
                                }
                                catch (Exception _7) {
                                    onError.invoke(rf, "Write", "\u5199\u5165\u6761\u76ee\u5931\u8d25");
                                }
                                try {
                                    McaEntry eentry;
                                    McaReaderLike mcaReaderLike3 = er;
                                    McaEntry mcaEntry = eentry = mcaReaderLike3 != null ? mcaReaderLike3.get(entry.regionIndex()) : null;
                                    if (eentry != null && ew != null) {
                                        try {
                                            ew.writeEntry(eentry);
                                        }
                                        catch (Exception exception) {
                                            onError.invoke(efile, "WriteEntities", "\u5199\u5165\u5b9e\u4f53\u6761\u76ee\u5931\u8d25");
                                        }
                                    }
                                }
                                catch (Exception _9) {
                                    onError.invoke(efile, "Entities", "\u8bfb\u53d6\u5b9e\u4f53\u5931\u8d25");
                                }
                                try {
                                    McaEntry pentry;
                                    McaReaderLike mcaReaderLike4 = pr;
                                    McaEntry mcaEntry = pentry = mcaReaderLike4 != null ? mcaReaderLike4.get(entry.regionIndex()) : null;
                                    if (pentry == null || pw == null) break block75;
                                    try {
                                        pw.writeEntry(pentry);
                                    }
                                    catch (Exception exception) {
                                        onError.invoke(pfile, "WritePoi", "\u5199\u5165 POI \u6761\u76ee\u5931\u8d25");
                                    }
                                }
                                catch (Exception _11) {
                                    onError.invoke(pfile, "Poi", "\u8bfb\u53d6 POI \u5931\u8d25");
                                }
                            } else {
                                ++removedTotal;
                            }
                        }
                        long processed = processedCounter.incrementAndGet();
                        if (useTime) {
                            long now = System.currentTimeMillis();
                            if (now - lastEmit < progressIntervalMs) continue;
                            Function1<? super ProgressEvent, Unit> function13 = onProgress;
                            if (function13 != null) {
                                function13.invoke(new ProgressEvent(ProgressStage.ChunkProgress, processed, totalChunks, ((Object)rf).toString(), null));
                            }
                            lastEmit = now;
                            continue;
                        }
                        if (progressInterval <= 0L || processed % progressInterval != 0L) continue;
                        Function1<? super ProgressEvent, Unit> function14 = onProgress;
                        if (function14 == null) continue;
                        function14.invoke(new ProgressEvent(ProgressStage.ChunkProgress, processed, totalChunks, ((Object)rf).toString(), null));
                    }
                    try {
                        cw.finalizeFile();
                    }
                    catch (Exception _12) {
                        onError.invoke(rf, "Finalize", "\u5b8c\u6210\u5199\u5165\u5931\u8d25");
                    }
                    try {
                        McaWriterLike mcaWriterLike3 = ew;
                        if (mcaWriterLike3 != null) {
                            mcaWriterLike3.finalizeFile();
                        }
                    }
                    catch (Exception _13) {
                        onError.invoke(efile, "FinalizeEntities", "\u5b8c\u6210\u5b9e\u4f53\u5199\u5165\u5931\u8d25");
                    }
                    try {
                        McaWriterLike mcaWriterLike4 = pw;
                        if (mcaWriterLike4 == null) continue;
                        mcaWriterLike4.finalizeFile();
                    }
                    catch (Exception _14) {
                        onError.invoke(pfile, "FinalizePoi", "\u5b8c\u6210 POI \u5199\u5165\u5931\u8d25");
                    }
                }
                finally {
                    try {
                        cr.close();
                    }
                    catch (Exception exception) {}
                    try {
                        cw.close();
                    }
                    catch (Exception exception) {}
                    try {
                        McaReaderLike mcaReaderLike5 = er;
                        if (mcaReaderLike5 != null) {
                            mcaReaderLike5.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        McaReaderLike mcaReaderLike6 = pr;
                        if (mcaReaderLike6 != null) {
                            mcaReaderLike6.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        McaWriterLike mcaWriterLike5 = ew;
                        if (mcaWriterLike5 != null) {
                            mcaWriterLike5.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        McaWriterLike mcaWriterLike6 = pw;
                        if (mcaWriterLike6 == null) continue;
                        mcaWriterLike6.close();
                    }
                    catch (Exception exception) {}
                }
            }
            Function1<? super ProgressEvent, Unit> function15 = onProgress;
            if (function15 == null) break block76;
            function15.invoke(new ProgressEvent(ProgressStage.DimensionEnd, null, null, ((Object)inputDim).toString(), null));
        }
        return new DimensionResult(processedCounter.get(), removedTotal);
    }
}

