/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.utils.bot;

import com.jokerhub.paper.plugin.orzmc.OrzMC;
import com.jokerhub.paper.plugin.orzmc.utils.HealthRegistry;
import com.jokerhub.paper.plugin.orzmc.utils.OrzMessageParser;
import com.jokerhub.paper.plugin.orzmc.utils.ThrottledLogger;
import com.jokerhub.paper.plugin.orzmc.utils.bot.OrzBaseBot;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.entities.channel.unions.MessageChannelUnion;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.events.session.ReadyEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.dv8tion.jda.api.utils.SplitUtil;
import okhttp3.OkHttpClient;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class OrzDiscordBot
extends OrzBaseBot {
    private final ArrayList<String> toBeSendMessageWhenApiReady = new ArrayList();
    private final String codeBlockPrefix = "```\n";
    private final String codeBlockSuffix = "```";
    private JDA api;
    private boolean isApiReady;

    public OrzDiscordBot(OrzMC plugin) {
        super(plugin);
    }

    private List<String> codeBlockSplitMessage(String rawMessage) {
        int discordTextLengthLimit = 2000;
        return SplitUtil.split(rawMessage, discordTextLengthLimit - "```\n".length() - "```".length(), true, SplitUtil.Strategy.NEWLINE, SplitUtil.Strategy.ANYWHERE).stream().map(part -> "```\n" + part + "```").collect(Collectors.toList());
    }

    @Override
    public boolean isEnable() {
        return this.botConfig.getBoolean("enable_discord_bot");
    }

    @Override
    public void setup() {
        if (!this.isEnable()) {
            OrzMC.debugInfo("Discord Bot Disabled!");
            return;
        }
        HealthRegistry.setEnabled("discord", true);
        String minecraftVersion = OrzMC.server().getMinecraftVersion();
        String serverInfo = "Minecraft(" + minecraftVersion + ")";
        String botTokenBase64Encoded = this.botConfig.getString("discord_bot_token_base64_encoded");
        String botToken = new String(Base64.getDecoder().decode(botTokenBase64Encoded));
        try {
            final long throttleMs = this.botConfig.getLong("log_throttle_ms");
            Thread.setDefaultUncaughtExceptionHandler((t, e) -> {
                HealthRegistry.setLastError("discord", e.toString());
                ThrottledLogger.error("discord-thread", "Discord\u7ebf\u7a0b\u5f02\u5e38: " + String.valueOf(e), throttleMs <= 0L ? 5000L : throttleMs);
            });
            JDABuilder builder = JDABuilder.createLight(botToken, GatewayIntent.GUILD_MESSAGES, GatewayIntent.MESSAGE_CONTENT, GatewayIntent.GUILD_MEMBERS);
            String proxyType = this.botConfig.getString("discord_proxy_type");
            String proxyHost = this.botConfig.getString("discord_proxy_host");
            int proxyPort = this.botConfig.getInt("discord_proxy_port");
            OkHttpClient.Builder http = new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS);
            if (proxyType != null && !"none".equalsIgnoreCase(proxyType) && proxyHost != null && !proxyHost.isEmpty() && proxyPort > 0) {
                Proxy.Type type = "SOCKS".equalsIgnoreCase(proxyType) ? Proxy.Type.SOCKS : Proxy.Type.HTTP;
                http.proxy(new Proxy(type, new InetSocketAddress(proxyHost, proxyPort)));
            }
            try {
                builder.setHttpClient(http.build());
            }
            catch (Throwable type) {
                // empty catch block
            }
            this.api = builder.addEventListeners(new ListenerAdapter(){

                @Override
                public void onReady(@NotNull ReadyEvent event) {
                    try {
                        super.onReady(event);
                        OrzDiscordBot.this.isApiReady = true;
                        HealthRegistry.setApiReady("discord", true);
                        OrzDiscordBot.this.toBeSendMessageWhenApiReady.forEach(message -> OrzDiscordBot.this.sendMessage((String)message));
                        OrzDiscordBot.this.toBeSendMessageWhenApiReady.clear();
                    }
                    catch (Exception e) {
                        HealthRegistry.setLastError("discord", e.toString());
                        ThrottledLogger.error("discord-onready", "Discord Ready \u4e8b\u4ef6\u5f02\u5e38: " + String.valueOf(e), throttleMs <= 0L ? 5000L : throttleMs);
                    }
                }

                @Override
                public void onMessageReceived(@NotNull MessageReceivedEvent event) {
                    try {
                        super.onMessageReceived(event);
                        if (event.getAuthor().isBot()) {
                            return;
                        }
                        Member member = event.getMember();
                        if (member == null) {
                            return;
                        }
                        boolean isAdmin = member.hasPermission(Permission.MANAGE_SERVER) || member.hasPermission(Permission.ADMINISTRATOR) || member.hasPermission(Permission.MANAGE_CHANNEL);
                        String content = event.getMessage().getContentRaw();
                        OrzMessageParser.parse(content, isAdmin, info -> {
                            if (info != null) {
                                MessageChannelUnion channel = event.getChannel();
                                OrzDiscordBot.this.codeBlockSplitMessage((String)info).forEach(part -> channel.sendMessage((CharSequence)part).queue());
                            }
                        });
                    }
                    catch (Exception e) {
                        HealthRegistry.setLastError("discord", e.toString());
                        ThrottledLogger.error("discord-onmessage", "Discord \u6d88\u606f\u4e8b\u4ef6\u5f02\u5e38: " + String.valueOf(e), throttleMs <= 0L ? 5000L : throttleMs);
                    }
                }
            }).setActivity(Activity.playing(serverInfo)).build();
            int graceSeconds = this.botConfig.getInt("discord_connect_grace_seconds");
            boolean autoDisable = this.botConfig.getBoolean("discord_auto_disable_on_connect_error");
            if (autoDisable) {
                int ticks = (graceSeconds <= 0 ? 10 : graceSeconds) * 20;
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    if (!this.isApiReady) {
                        try {
                            this.api.shutdown();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        HealthRegistry.setEnabled("discord", false);
                        ThrottledLogger.warning("discord-disable", "Discord\u4e0d\u53ef\u8fbe\uff0c\u5df2\u81ea\u52a8\u7981\u7528\u673a\u5668\u4eba", throttleMs <= 0L ? 5000L : throttleMs);
                    }
                }, (long)ticks);
            }
        }
        catch (Exception e2) {
            HealthRegistry.setLastError("discord", e2.toString());
            ThrottledLogger.error("discord-init", "Discord\u521d\u59cb\u5316\u5f02\u5e38: " + String.valueOf(e2), this.botConfig.getLong("log_throttle_ms"));
        }
    }

    @Override
    public void teardown() {
        try {
            this.isApiReady = false;
            if (this.api != null) {
                this.api.shutdown();
                try {
                    this.api.awaitShutdown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.api = null;
        }
    }

    @Override
    public void sendMessage(String message) {
        if (!this.isEnable()) {
            OrzMC.debugInfo("Discord Bot Disabled!");
            return;
        }
        if (!this.isApiReady) {
            this.toBeSendMessageWhenApiReady.add(message);
            return;
        }
        try {
            long throttleMs = this.botConfig.getLong("log_throttle_ms");
            String playerTextChannelId = this.botConfig.getString("discord_player_text_channel_id");
            TextChannel channel = playerTextChannelId != null ? this.api.getTextChannelById(playerTextChannelId) : null;
            if (channel != null) {
                this.codeBlockSplitMessage(message).forEach(part -> channel.sendMessage((CharSequence)part).queue());
            } else {
                OrzMC.logger().warning("your discord bot not in this text channel: " + playerTextChannelId);
            }
        }
        catch (Exception e) {
            HealthRegistry.setLastError("discord", e.toString());
            ThrottledLogger.error("discord-send", "Discord\u6d88\u606f\u53d1\u9001\u5f02\u5e38: " + String.valueOf(e), this.botConfig.getLong("log_throttle_ms"));
        }
    }

    @Override
    public void sendPrivateMessage(String message) {
    }
}

