/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.orzmc.world;

import com.jokerhub.orzmc.mca.McaReader;
import com.jokerhub.orzmc.world.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\t\u00a8\u0006\r"}, d2={"Lcom/jokerhub/orzmc/world/McaUtils;", "", "()V", "countTotalChunks", "", "fs", "Lcom/jokerhub/orzmc/world/FileSystem;", "dims", "", "Ljava/nio/file/Path;", "isValidMca", "", "path", "core"})
@SourceDebugExtension(value={"SMAP\nMcaUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McaUtils.kt\ncom/jokerhub/orzmc/world/McaUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,33:1\n766#2:34\n857#2,2:35\n1855#2,2:37\n*S KotlinDebug\n*F\n+ 1 McaUtils.kt\ncom/jokerhub/orzmc/world/McaUtils\n*L\n21#1:34\n21#1:35,2\n21#1:37,2\n*E\n"})
public final class McaUtils {
    @NotNull
    public static final McaUtils INSTANCE = new McaUtils();

    private McaUtils() {
    }

    public final boolean isValidMca(@NotNull FileSystem fs, @NotNull Path path) {
        boolean bl;
        Intrinsics.checkNotNullParameter(fs, "fs");
        Intrinsics.checkNotNullParameter(path, "path");
        try {
            bl = Files.size(fs.toRealPath(path)) >= 8192L;
        }
        catch (Exception _) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final long countTotalChunks(@NotNull FileSystem fs, @NotNull List<? extends Path> dims) {
        Intrinsics.checkNotNullParameter(fs, "fs");
        Intrinsics.checkNotNullParameter(dims, "dims");
        long total = 0L;
        for (Path path : dims) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Path regionDir = path.resolve("region");
            Intrinsics.checkNotNull(regionDir);
            if (!fs.isDirectory(regionDir)) continue;
            Iterable $this$filter$iv = fs.list(regionDir);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Path it = (Path)element$iv$iv;
                boolean bl = false;
                if (!(StringsKt.endsWith$default(((Object)it).toString(), ".mca", false, 2, null) && INSTANCE.isValidMca(fs, it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path p = (Path)element$iv;
                boolean bl = false;
                try {
                    AutoCloseable autoCloseable = McaReader.Companion.open(((Object)fs.toRealPath(p)).toString());
                    Throwable throwable = null;
                    try {
                        McaReader r = (McaReader)autoCloseable;
                        boolean bl2 = false;
                        total += (long)r.entries().size();
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally(autoCloseable, throwable);
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        return total;
    }
}

