/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.orzmc.world;

import java.io.Closeable;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"Lcom/jokerhub/orzmc/world/Compressor;", "", "()V", "compressToTimestampZip", "Ljava/nio/file/Path;", "root", "core"})
public final class Compressor {
    @NotNull
    public static final Compressor INSTANCE = new Compressor();

    private Compressor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Path compressToTimestampZip(@NotNull Path root) {
        Intrinsics.checkNotNullParameter(root, "root");
        String ts = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        Path path = root.getParent();
        if (path == null) {
            path = root;
        }
        Path parent = path;
        Path zipPath = parent.resolve(ts + ".zip");
        Closeable closeable = new ZipOutputStream(Files.newOutputStream(zipPath, new OpenOption[0]));
        Throwable throwable = null;
        try {
            ZipOutputStream zos = (ZipOutputStream)closeable;
            boolean bl = false;
            Files.walk(root, new FileVisitOption[0]).forEach(arg_0 -> Compressor.compressToTimestampZip$lambda$1$lambda$0(new Function1<Path, Unit>(root, zos){
                final /* synthetic */ Path $root;
                final /* synthetic */ ZipOutputStream $zos;
                {
                    this.$root = $root;
                    this.$zos = $zos;
                    super(1);
                }

                public final void invoke(Path p) {
                    Path rel = this.$root.relativize(p);
                    if (((CharSequence)((Object)rel).toString()).length() == 0) {
                        return;
                    }
                    if (!Files.isDirectory(p, new LinkOption[0])) {
                        this.$zos.putNextEntry(new ZipEntry(((Object)rel).toString()));
                        Files.copy(p, this.$zos);
                        this.$zos.closeEntry();
                    }
                }
            }, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        Intrinsics.checkNotNull(zipPath);
        return zipPath;
    }

    private static final void compressToTimestampZip$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }
}

