/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.net.ConnectException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.Socket;
import java.net.UnknownServiceException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Address;
import okhttp3.CertificatePinner;
import okhttp3.ConnectionSpec;
import okhttp3.Handshake;
import okhttp3.HttpUrl;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.internal._UtilJvmKt;
import okhttp3.internal.concurrent.Lockable;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.connection.BufferedSocket;
import okhttp3.internal.connection.BufferedSocketKt;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.connection.RealRoutePlanner;
import okhttp3.internal.connection.RetryTlsHandshakeKt;
import okhttp3.internal.connection.ReusePlan;
import okhttp3.internal.connection.RoutePlanner;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http1.Http1ExchangeCodec;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.tls.CertificateChainCleaner;
import okhttp3.internal.tls.OkHostnameVerifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 R2\u00020\u00012\u00020\u0002:\u0001RB\u0093\u0001\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0016\u0012\u0006\u0010\u0017\u001a\u00020\b\u0012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u0012\u0006\u0010\u001a\u001a\u00020\b\u0012\u0006\u0010\u001b\u001a\u00020\u000e\u00a2\u0006\u0004\b\u001c\u0010\u001dJ2\u00107\u001a\u00020\u00002\b\b\u0002\u0010\u0017\u001a\u00020\b2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\b\u0002\u0010\u001a\u001a\u00020\b2\b\b\u0002\u0010\u001b\u001a\u00020\u000eH\u0002J\b\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u000209H\u0016J\b\u0010;\u001a\u00020<H\u0002J\r\u0010=\u001a\u000209H\u0000\u00a2\u0006\u0002\b>J\u0018\u0010?\u001a\u00020<2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0002J\n\u0010D\u001a\u0004\u0018\u00010\u0019H\u0002J#\u0010E\u001a\u00020\u00002\f\u0010F\u001a\b\u0012\u0004\u0012\u00020C0\u00162\u0006\u0010@\u001a\u00020AH\u0000\u00a2\u0006\u0002\bGJ%\u0010H\u001a\u0004\u0018\u00010\u00002\f\u0010F\u001a\b\u0012\u0004\u0012\u00020C0\u00162\u0006\u0010@\u001a\u00020AH\u0000\u00a2\u0006\u0002\bIJ\b\u0010J\u001a\u000205H\u0016J\u001a\u0010K\u001a\u00020<2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010L\u001a\u0004\u0018\u00010MH\u0016J\b\u0010N\u001a\u00020<H\u0016J\b\u0010O\u001a\u00020<H\u0016J\b\u0010P\u001a\u00020\u0001H\u0016J\u0006\u0010Q\u001a\u00020<R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001c\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\u0017\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010\u001b\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010)\u001a\u0004\u0018\u00010(X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u0010\u0010.\u001a\u0004\u0018\u00010/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000203X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u00104\u001a\u0004\u0018\u000105X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00106\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010%\u00a8\u0006S"}, d2={"Lokhttp3/internal/connection/ConnectPlan;", "Lokhttp3/internal/connection/RoutePlanner$Plan;", "Lokhttp3/internal/http/ExchangeCodec$Carrier;", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "connectionPool", "Lokhttp3/internal/connection/RealConnectionPool;", "readTimeoutMillis", "", "writeTimeoutMillis", "socketConnectTimeoutMillis", "socketReadTimeoutMillis", "pingIntervalMillis", "retryOnConnectionFailure", "", "call", "Lokhttp3/internal/connection/RealCall;", "routePlanner", "Lokhttp3/internal/connection/RealRoutePlanner;", "route", "Lokhttp3/Route;", "routes", "", "attempt", "tunnelRequest", "Lokhttp3/Request;", "connectionSpecIndex", "isTlsFallback", "<init>", "(Lokhttp3/internal/concurrent/TaskRunner;Lokhttp3/internal/connection/RealConnectionPool;IIIIIZLokhttp3/internal/connection/RealCall;Lokhttp3/internal/connection/RealRoutePlanner;Lokhttp3/Route;Ljava/util/List;ILokhttp3/Request;IZ)V", "getRoute", "()Lokhttp3/Route;", "getRoutes$okhttp", "()Ljava/util/List;", "getConnectionSpecIndex$okhttp", "()I", "isTlsFallback$okhttp", "()Z", "canceled", "rawSocket", "Ljava/net/Socket;", "javaNetSocket", "getJavaNetSocket$okhttp", "()Ljava/net/Socket;", "setJavaNetSocket$okhttp", "(Ljava/net/Socket;)V", "handshake", "Lokhttp3/Handshake;", "protocol", "Lokhttp3/Protocol;", "socket", "Lokhttp3/internal/connection/BufferedSocket;", "connection", "Lokhttp3/internal/connection/RealConnection;", "isReady", "copy", "connectTcp", "Lokhttp3/internal/connection/RoutePlanner$ConnectResult;", "connectTlsEtc", "connectSocket", "", "connectTunnel", "connectTunnel$okhttp", "connectTls", "sslSocket", "Ljavax/net/ssl/SSLSocket;", "connectionSpec", "Lokhttp3/ConnectionSpec;", "createTunnel", "planWithCurrentOrInitialConnectionSpec", "connectionSpecs", "planWithCurrentOrInitialConnectionSpec$okhttp", "nextConnectionSpec", "nextConnectionSpec$okhttp", "handleSuccess", "trackFailure", "e", "Ljava/io/IOException;", "noNewExchanges", "cancel", "retry", "closeQuietly", "Companion", "okhttp"})
@SourceDebugExtension(value={"SMAP\nConnectPlan.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectPlan.kt\nokhttp3/internal/connection/ConnectPlan\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Lockable.kt\nokhttp3/internal/concurrent/LockableKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,564:1\n1#2:565\n63#3:566\n1563#4:567\n1634#4,3:568\n*S KotlinDebug\n*F\n+ 1 ConnectPlan.kt\nokhttp3/internal/connection/ConnectPlan\n*L\n508#1:566\n393#1:567\n393#1:568,3\n*E\n"})
public final class ConnectPlan
implements RoutePlanner.Plan,
ExchangeCodec.Carrier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TaskRunner taskRunner;
    @NotNull
    private final RealConnectionPool connectionPool;
    private final int readTimeoutMillis;
    private final int writeTimeoutMillis;
    private final int socketConnectTimeoutMillis;
    private final int socketReadTimeoutMillis;
    private final int pingIntervalMillis;
    private final boolean retryOnConnectionFailure;
    @NotNull
    private final RealCall call;
    @NotNull
    private final RealRoutePlanner routePlanner;
    @NotNull
    private final Route route;
    @Nullable
    private final List<Route> routes;
    private final int attempt;
    @Nullable
    private final Request tunnelRequest;
    private final int connectionSpecIndex;
    private final boolean isTlsFallback;
    private volatile boolean canceled;
    @Nullable
    private Socket rawSocket;
    @Nullable
    private Socket javaNetSocket;
    @Nullable
    private Handshake handshake;
    @Nullable
    private Protocol protocol;
    private BufferedSocket socket;
    @Nullable
    private RealConnection connection;
    @NotNull
    private static final String NPE_THROW_WITH_NULL = "throw with null exception";
    private static final int MAX_TUNNEL_ATTEMPTS = 21;

    public ConnectPlan(@NotNull TaskRunner taskRunner, @NotNull RealConnectionPool connectionPool, int readTimeoutMillis, int writeTimeoutMillis, int socketConnectTimeoutMillis, int socketReadTimeoutMillis, int pingIntervalMillis, boolean retryOnConnectionFailure, @NotNull RealCall call, @NotNull RealRoutePlanner routePlanner, @NotNull Route route, @Nullable List<Route> routes, int attempt, @Nullable Request tunnelRequest, int connectionSpecIndex, boolean isTlsFallback) {
        Intrinsics.checkNotNullParameter(taskRunner, "taskRunner");
        Intrinsics.checkNotNullParameter(connectionPool, "connectionPool");
        Intrinsics.checkNotNullParameter(call, "call");
        Intrinsics.checkNotNullParameter(routePlanner, "routePlanner");
        Intrinsics.checkNotNullParameter(route, "route");
        this.taskRunner = taskRunner;
        this.connectionPool = connectionPool;
        this.readTimeoutMillis = readTimeoutMillis;
        this.writeTimeoutMillis = writeTimeoutMillis;
        this.socketConnectTimeoutMillis = socketConnectTimeoutMillis;
        this.socketReadTimeoutMillis = socketReadTimeoutMillis;
        this.pingIntervalMillis = pingIntervalMillis;
        this.retryOnConnectionFailure = retryOnConnectionFailure;
        this.call = call;
        this.routePlanner = routePlanner;
        this.route = route;
        this.routes = routes;
        this.attempt = attempt;
        this.tunnelRequest = tunnelRequest;
        this.connectionSpecIndex = connectionSpecIndex;
        this.isTlsFallback = isTlsFallback;
    }

    @Override
    @NotNull
    public Route getRoute() {
        return this.route;
    }

    @Nullable
    public final List<Route> getRoutes$okhttp() {
        return this.routes;
    }

    public final int getConnectionSpecIndex$okhttp() {
        return this.connectionSpecIndex;
    }

    public final boolean isTlsFallback$okhttp() {
        return this.isTlsFallback;
    }

    @Nullable
    public final Socket getJavaNetSocket$okhttp() {
        return this.javaNetSocket;
    }

    public final void setJavaNetSocket$okhttp(@Nullable Socket socket) {
        this.javaNetSocket = socket;
    }

    @Override
    public boolean isReady() {
        return this.protocol != null;
    }

    private final ConnectPlan copy(int attempt, Request tunnelRequest, int connectionSpecIndex, boolean isTlsFallback) {
        return new ConnectPlan(this.taskRunner, this.connectionPool, this.readTimeoutMillis, this.writeTimeoutMillis, this.socketConnectTimeoutMillis, this.socketReadTimeoutMillis, this.pingIntervalMillis, this.retryOnConnectionFailure, this.call, this.routePlanner, this.getRoute(), this.routes, attempt, tunnelRequest, connectionSpecIndex, isTlsFallback);
    }

    static /* synthetic */ ConnectPlan copy$default(ConnectPlan connectPlan, int n, Request request, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = connectPlan.attempt;
        }
        if ((n3 & 2) != 0) {
            request = connectPlan.tunnelRequest;
        }
        if ((n3 & 4) != 0) {
            n2 = connectPlan.connectionSpecIndex;
        }
        if ((n3 & 8) != 0) {
            bl = connectPlan.isTlsFallback;
        }
        return connectPlan.copy(n, request, n2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public RoutePlanner.ConnectResult connectTcp() {
        RoutePlanner.ConnectResult connectResult;
        if (!(this.rawSocket == null)) {
            boolean bl = false;
            String string = "TCP already connected";
            throw new IllegalStateException(string.toString());
        }
        boolean success = false;
        ((Collection)this.call.getPlansToCancel$okhttp()).add(this);
        try {
            this.call.getEventListener$okhttp().connectStart(this.call, this.getRoute().socketAddress(), this.getRoute().proxy());
            this.connectionPool.getConnectionListener$okhttp().connectStart(this.getRoute(), this.call);
            this.connectSocket();
            success = true;
            connectResult = new RoutePlanner.ConnectResult(this, null, null, 6, null);
            ((Collection)this.call.getPlansToCancel$okhttp()).remove(this);
        }
        catch (IOException e) {
            if (this.getRoute().address().proxy() == null && this.getRoute().proxy().type() != Proxy.Type.DIRECT) {
                this.getRoute().address().proxySelector().connectFailed(this.getRoute().address().url().uri(), this.getRoute().proxy().address(), e);
            }
            this.call.getEventListener$okhttp().connectFailed(this.call, this.getRoute().socketAddress(), this.getRoute().proxy(), null, e);
            this.connectionPool.getConnectionListener$okhttp().connectFailed(this.getRoute(), this.call, e);
            RoutePlanner.ConnectResult connectResult2 = new RoutePlanner.ConnectResult(this, null, e, 2, null);
            return connectResult2;
        }
        finally {
            block8: {
                ((Collection)this.call.getPlansToCancel$okhttp()).remove(this);
                if (success) break block8;
                Socket socket = this.rawSocket;
                if (socket != null) {
                    _UtilJvmKt.closeQuietly(socket);
                }
            }
        }
        return connectResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public RoutePlanner.ConnectResult connectTlsEtc() {
        RoutePlanner.ConnectResult connectResult;
        boolean success;
        Socket rawSocket;
        block19: {
            Socket socket = this.rawSocket;
            if (socket == null) {
                boolean $i$a$-requireNotNull-ConnectPlan$connectTlsEtc$rawSocket$22 = false;
                String $i$a$-requireNotNull-ConnectPlan$connectTlsEtc$rawSocket$22 = "TCP not connected";
                throw new IllegalArgumentException($i$a$-requireNotNull-ConnectPlan$connectTlsEtc$rawSocket$22.toString());
            }
            rawSocket = socket;
            if (!(!this.isReady())) {
                boolean $i$a$-check-ConnectPlan$connectTlsEtc$22 = false;
                String $i$a$-check-ConnectPlan$connectTlsEtc$22 = "already connected";
                throw new IllegalStateException($i$a$-check-ConnectPlan$connectTlsEtc$22.toString());
            }
            List<ConnectionSpec> connectionSpecs = this.getRoute().address().connectionSpecs();
            ConnectPlan retryTlsConnection = null;
            success = false;
            ((Collection)this.call.getPlansToCancel$okhttp()).add(this);
            try {
                RealConnection connection;
                Object tlsEquipPlan;
                RoutePlanner.ConnectResult tunnelResult;
                if (this.tunnelRequest != null && ((tunnelResult = this.connectTunnel$okhttp()).getNextPlan() != null || tunnelResult.getThrowable() != null)) {
                    connectResult = tunnelResult;
                    ((Collection)this.call.getPlansToCancel$okhttp()).remove(this);
                    break block19;
                }
                if (this.getRoute().address().sslSocketFactory() != null) {
                    BufferedSocket bufferedSocket2 = this.socket;
                    if (bufferedSocket2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("socket");
                        bufferedSocket2 = null;
                    }
                    if (!bufferedSocket2.getSource().getBuffer().exhausted()) throw new IOException("TLS tunnel buffered too many bytes!");
                    BufferedSocket bufferedSocket3 = this.socket;
                    if (bufferedSocket3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("socket");
                        bufferedSocket3 = null;
                    }
                    if (!bufferedSocket3.getSink().getBuffer().exhausted()) {
                        throw new IOException("TLS tunnel buffered too many bytes!");
                    }
                    this.call.getEventListener$okhttp().secureConnectStart(this.call);
                    Socket socket2 = this.getRoute().address().sslSocketFactory().createSocket(rawSocket, this.getRoute().address().url().host(), this.getRoute().address().url().port(), true);
                    Intrinsics.checkNotNull(socket2, "null cannot be cast to non-null type javax.net.ssl.SSLSocket");
                    SSLSocket sslSocket = (SSLSocket)socket2;
                    tlsEquipPlan = this.planWithCurrentOrInitialConnectionSpec$okhttp(connectionSpecs, sslSocket);
                    ConnectionSpec connectionSpec = connectionSpecs.get(((ConnectPlan)tlsEquipPlan).connectionSpecIndex);
                    retryTlsConnection = ((ConnectPlan)tlsEquipPlan).nextConnectionSpec$okhttp(connectionSpecs, sslSocket);
                    connectionSpec.apply$okhttp(sslSocket, ((ConnectPlan)tlsEquipPlan).isTlsFallback);
                    this.connectTls(sslSocket, connectionSpec);
                    this.call.getEventListener$okhttp().secureConnectEnd(this.call, this.handshake);
                } else {
                    this.javaNetSocket = rawSocket;
                    this.protocol = this.getRoute().address().protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE) ? Protocol.H2_PRIOR_KNOWLEDGE : Protocol.HTTP_1_1;
                }
                Route route = this.getRoute();
                Socket socket3 = this.javaNetSocket;
                Intrinsics.checkNotNull(socket3);
                Protocol protocol = this.protocol;
                Intrinsics.checkNotNull((Object)protocol);
                BufferedSocket bufferedSocket4 = this.socket;
                if (bufferedSocket4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("socket");
                    bufferedSocket4 = null;
                }
                this.connection = connection = new RealConnection(this.taskRunner, this.connectionPool, route, rawSocket, socket3, this.handshake, protocol, bufferedSocket4, this.pingIntervalMillis, this.connectionPool.getConnectionListener$okhttp());
                connection.start();
                this.call.getEventListener$okhttp().connectEnd(this.call, this.getRoute().socketAddress(), this.getRoute().proxy(), this.protocol);
                success = true;
                tlsEquipPlan = new RoutePlanner.ConnectResult(this, null, null, 6, null);
                ((Collection)this.call.getPlansToCancel$okhttp()).remove(this);
                return tlsEquipPlan;
            }
            catch (IOException e) {
                this.call.getEventListener$okhttp().connectFailed(this.call, this.getRoute().socketAddress(), this.getRoute().proxy(), null, e);
                this.connectionPool.getConnectionListener$okhttp().connectFailed(this.getRoute(), this.call, e);
                if (!this.retryOnConnectionFailure || !RetryTlsHandshakeKt.retryTlsHandshake(e)) {
                    retryTlsConnection = null;
                }
                RoutePlanner.ConnectResult connectResult2 = new RoutePlanner.ConnectResult(this, retryTlsConnection, e);
                return connectResult2;
            }
        }
        Socket socket = this.javaNetSocket;
        if (socket != null) {
            _UtilJvmKt.closeQuietly(socket);
        }
        _UtilJvmKt.closeQuietly(rawSocket);
        return connectResult;
        finally {
            ((Collection)this.call.getPlansToCancel$okhttp()).remove(this);
            if (!success) {
                Socket socket4 = this.javaNetSocket;
                if (socket4 != null) {
                    _UtilJvmKt.closeQuietly(socket4);
                }
                _UtilJvmKt.closeQuietly(rawSocket);
            }
        }
    }

    private final void connectSocket() throws IOException {
        block8: {
            Socket rawSocket;
            Socket socket;
            Proxy.Type type = this.getRoute().proxy().type();
            switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: 
                case 2: {
                    Socket socket2 = this.getRoute().address().socketFactory().createSocket();
                    socket = socket2;
                    Intrinsics.checkNotNull(socket2);
                    break;
                }
                default: {
                    socket = new Socket(this.getRoute().proxy());
                }
            }
            this.rawSocket = rawSocket = socket;
            if (this.canceled) {
                throw new IOException("canceled");
            }
            rawSocket.setSoTimeout(this.socketReadTimeoutMillis);
            try {
                Platform.Companion.get().connectSocket(rawSocket, this.getRoute().socketAddress(), this.socketConnectTimeoutMillis);
            }
            catch (ConnectException e) {
                ConnectException connectException;
                ConnectException $this$connectSocket_u24lambda_u240 = connectException = new ConnectException("Failed to connect to " + this.getRoute().socketAddress());
                boolean bl = false;
                $this$connectSocket_u24lambda_u240.initCause(e);
                throw (Throwable)connectException;
            }
            try {
                this.socket = BufferedSocketKt.asBufferedSocket(rawSocket);
            }
            catch (NullPointerException npe) {
                if (!Intrinsics.areEqual(npe.getMessage(), NPE_THROW_WITH_NULL)) break block8;
                throw new IOException(npe);
            }
        }
    }

    @NotNull
    public final RoutePlanner.ConnectResult connectTunnel$okhttp() throws IOException {
        Request request = this.createTunnel();
        if (request == null) {
            return new RoutePlanner.ConnectResult(this, null, null, 6, null);
        }
        Request nextTunnelRequest = request;
        Socket socket = this.rawSocket;
        if (socket != null) {
            _UtilJvmKt.closeQuietly(socket);
        }
        int nextAttempt = this.attempt + 1;
        if (nextAttempt >= 21) {
            ProtocolException failure = new ProtocolException("Too many tunnel connections attempted: 21");
            this.call.getEventListener$okhttp().connectFailed(this.call, this.getRoute().socketAddress(), this.getRoute().proxy(), null, failure);
            this.connectionPool.getConnectionListener$okhttp().connectFailed(this.getRoute(), this.call, failure);
            return new RoutePlanner.ConnectResult(this, null, failure, 2, null);
        }
        this.call.getEventListener$okhttp().connectEnd(this.call, this.getRoute().socketAddress(), this.getRoute().proxy(), null);
        return new RoutePlanner.ConnectResult(this, ConnectPlan.copy$default(this, nextAttempt, nextTunnelRequest, 0, false, 12, null), null, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void connectTls(SSLSocket sslSocket, ConnectionSpec connectionSpec) throws IOException {
        Address address = this.getRoute().address();
        boolean success = false;
        try {
            Handshake handshake;
            if (connectionSpec.supportsTlsExtensions()) {
                Platform.Companion.get().configureTlsExtensions(sslSocket, address.url().host(), address.protocols());
            }
            sslSocket.startHandshake();
            SSLSession sslSocketSession = sslSocket.getSession();
            Intrinsics.checkNotNull(sslSocketSession);
            Handshake unverifiedHandshake = Handshake.Companion.get(sslSocketSession);
            HostnameVerifier hostnameVerifier = address.hostnameVerifier();
            Intrinsics.checkNotNull(hostnameVerifier);
            if (!hostnameVerifier.verify(address.url().host(), sslSocketSession)) {
                List<Certificate> peerCertificates = unverifiedHandshake.peerCertificates();
                if (!((Collection)peerCertificates).isEmpty()) {
                    Certificate certificate = peerCertificates.get(0);
                    Intrinsics.checkNotNull(certificate, "null cannot be cast to non-null type java.security.cert.X509Certificate");
                    X509Certificate cert = (X509Certificate)certificate;
                    throw new SSLPeerUnverifiedException(StringsKt.trimMargin$default("\n            |Hostname " + address.url().host() + " not verified:\n            |    certificate: " + CertificatePinner.Companion.pin(cert) + "\n            |    DN: " + cert.getSubjectDN().getName() + "\n            |    subjectAltNames: " + OkHostnameVerifier.INSTANCE.allSubjectAltNames(cert) + "\n            ", null, 1, null));
                }
                throw new SSLPeerUnverifiedException("Hostname " + address.url().host() + " not verified (no certificates)");
            }
            CertificatePinner certificatePinner = address.certificatePinner();
            Intrinsics.checkNotNull(certificatePinner);
            CertificatePinner certificatePinner2 = certificatePinner;
            this.handshake = handshake = new Handshake(unverifiedHandshake.tlsVersion(), unverifiedHandshake.cipherSuite(), unverifiedHandshake.localCertificates(), () -> ConnectPlan.connectTls$lambda$0(certificatePinner2, unverifiedHandshake, address));
            certificatePinner2.check$okhttp(address.url().host(), () -> ConnectPlan.connectTls$lambda$1(handshake));
            String maybeProtocol = connectionSpec.supportsTlsExtensions() ? Platform.Companion.get().getSelectedProtocol(sslSocket) : null;
            this.javaNetSocket = sslSocket;
            this.socket = BufferedSocketKt.asBufferedSocket(sslSocket);
            String string = maybeProtocol;
            this.protocol = string != null ? Protocol.Companion.get(string) : Protocol.HTTP_1_1;
            success = true;
            Platform.Companion.get().afterHandshake(sslSocket);
        }
        catch (Throwable throwable) {
            Platform.Companion.get().afterHandshake(sslSocket);
            _UtilJvmKt.closeQuietly(sslSocket);
            throw throwable;
        }
    }

    private final Request createTunnel() throws IOException {
        Response response;
        Request request = this.tunnelRequest;
        Intrinsics.checkNotNull(request);
        Request nextRequest = request;
        HttpUrl url = this.getRoute().address().url();
        String requestLine = "CONNECT " + _UtilJvmKt.toHostHeader(url, true) + " HTTP/1.1";
        block4: while (true) {
            ExchangeCodec.Carrier carrier = this;
            BufferedSocket bufferedSocket2 = this.socket;
            if (bufferedSocket2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("socket");
                bufferedSocket2 = null;
            }
            Http1ExchangeCodec tunnelCodec = new Http1ExchangeCodec(null, carrier, bufferedSocket2);
            BufferedSocket bufferedSocket3 = this.socket;
            if (bufferedSocket3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("socket");
                bufferedSocket3 = null;
            }
            bufferedSocket3.getSource().timeout().timeout(this.readTimeoutMillis, TimeUnit.MILLISECONDS);
            BufferedSocket bufferedSocket4 = this.socket;
            if (bufferedSocket4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("socket");
                bufferedSocket4 = null;
            }
            bufferedSocket4.getSink().timeout().timeout(this.writeTimeoutMillis, TimeUnit.MILLISECONDS);
            tunnelCodec.writeRequest(nextRequest.headers(), requestLine);
            tunnelCodec.finishRequest();
            Response.Builder builder = tunnelCodec.readResponseHeaders(false);
            Intrinsics.checkNotNull(builder);
            response = builder.request(nextRequest).build();
            tunnelCodec.skipConnectBody(response);
            switch (response.code()) {
                case 200: {
                    return null;
                }
                case 407: {
                    if (this.getRoute().address().proxyAuthenticator().authenticate(this.getRoute(), response) != null) continue block4;
                    throw new IOException("Failed to authenticate with proxy");
                    if (!StringsKt.equals("close", Response.header$default(response, "Connection", null, 2, null), true)) continue block4;
                    return nextRequest;
                }
            }
            break;
        }
        throw new IOException("Unexpected response code for CONNECT: " + response.code());
    }

    @NotNull
    public final ConnectPlan planWithCurrentOrInitialConnectionSpec$okhttp(@NotNull List<ConnectionSpec> connectionSpecs, @NotNull SSLSocket sslSocket) throws IOException {
        Intrinsics.checkNotNullParameter(connectionSpecs, "connectionSpecs");
        Intrinsics.checkNotNullParameter(sslSocket, "sslSocket");
        if (this.connectionSpecIndex != -1) {
            return this;
        }
        ConnectPlan connectPlan = this.nextConnectionSpec$okhttp(connectionSpecs, sslSocket);
        if (connectPlan == null) {
            StringBuilder stringBuilder = new StringBuilder().append("Unable to find acceptable protocols. isFallback=").append(this.isTlsFallback).append(", modes=").append(connectionSpecs).append(", supported protocols=");
            Object[] objectArray = sslSocket.getEnabledProtocols();
            Intrinsics.checkNotNull(objectArray);
            String string = Arrays.toString(objectArray);
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            throw new UnknownServiceException(stringBuilder.append(string).toString());
        }
        return connectPlan;
    }

    @Nullable
    public final ConnectPlan nextConnectionSpec$okhttp(@NotNull List<ConnectionSpec> connectionSpecs, @NotNull SSLSocket sslSocket) {
        Intrinsics.checkNotNullParameter(connectionSpecs, "connectionSpecs");
        Intrinsics.checkNotNullParameter(sslSocket, "sslSocket");
        int n = connectionSpecs.size();
        for (int i = this.connectionSpecIndex + 1; i < n; ++i) {
            if (!connectionSpecs.get(i).isCompatible(sslSocket)) continue;
            return ConnectPlan.copy$default(this, 0, null, i, this.connectionSpecIndex != -1, 3, null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public RealConnection handleSuccess() {
        this.call.getClient().getRouteDatabase$okhttp().connected(this.getRoute());
        RealConnection realConnection = this.connection;
        Intrinsics.checkNotNull(realConnection);
        RealConnection connection = realConnection;
        connection.getConnectionListener$okhttp().connectEnd(connection, this.getRoute(), this.call);
        ReusePlan pooled3 = this.routePlanner.planReusePooledConnection$okhttp(this, this.routes);
        if (pooled3 != null) {
            return pooled3.getConnection();
        }
        Lockable $this$withLock$iv = connection;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            this.connectionPool.put(connection);
            this.call.acquireConnectionNoEvents(connection);
            Unit unit = Unit.INSTANCE;
        }
        this.call.getEventListener$okhttp().connectionAcquired(this.call, connection);
        connection.getConnectionListener$okhttp().connectionAcquired(connection, this.call);
        return connection;
    }

    @Override
    public void trackFailure(@NotNull RealCall call, @Nullable IOException e) {
        Intrinsics.checkNotNullParameter(call, "call");
    }

    @Override
    public void noNewExchanges() {
    }

    @Override
    public void cancel() {
        block0: {
            this.canceled = true;
            Socket socket = this.rawSocket;
            if (socket == null) break block0;
            _UtilJvmKt.closeQuietly(socket);
        }
    }

    @Override
    @NotNull
    public RoutePlanner.Plan retry() {
        return new ConnectPlan(this.taskRunner, this.connectionPool, this.readTimeoutMillis, this.writeTimeoutMillis, this.socketConnectTimeoutMillis, this.socketReadTimeoutMillis, this.pingIntervalMillis, this.retryOnConnectionFailure, this.call, this.routePlanner, this.getRoute(), this.routes, this.attempt, this.tunnelRequest, this.connectionSpecIndex, this.isTlsFallback);
    }

    public final void closeQuietly() {
        block0: {
            Socket socket = this.javaNetSocket;
            if (socket == null) break block0;
            _UtilJvmKt.closeQuietly(socket);
        }
    }

    private static final List connectTls$lambda$0(CertificatePinner $certificatePinner, Handshake $unverifiedHandshake, Address $address) {
        CertificateChainCleaner certificateChainCleaner = $certificatePinner.getCertificateChainCleaner$okhttp();
        Intrinsics.checkNotNull(certificateChainCleaner);
        return certificateChainCleaner.clean($unverifiedHandshake.peerCertificates(), $address.url().host());
    }

    /*
     * WARNING - void declaration
     */
    private static final List connectTls$lambda$1(Handshake $handshake) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $handshake.peerCertificates();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Certificate certificate = (Certificate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it, "null cannot be cast to non-null type java.security.cert.X509Certificate");
            collection.add((X509Certificate)it);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lokhttp3/internal/connection/ConnectPlan$Companion;", "", "<init>", "()V", "NPE_THROW_WITH_NULL", "", "MAX_TUNNEL_ATTEMPTS", "", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Proxy.Type.values().length];
            try {
                nArray[Proxy.Type.DIRECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Proxy.Type.HTTP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

