/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.utils.bot;

import com.jokerhub.paper.plugin.orzmc.OrzMC;
import com.jokerhub.paper.plugin.orzmc.utils.ThrottledLogger;
import com.jokerhub.paper.plugin.orzmc.utils.bot.OrzBaseBot;
import com.jokerhub.paper.plugin.orzmc.utils.bot.OrzDiscordBot;
import com.jokerhub.paper.plugin.orzmc.utils.bot.OrzLarkBot;
import com.jokerhub.paper.plugin.orzmc.utils.bot.OrzQQBot;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

public class OrzBotManager {
    private final OrzMC plugin;
    private Map<String, OrzBaseBot> bots;
    private final ConcurrentLinkedQueue<PendingMessage> pending = new ConcurrentLinkedQueue();
    private volatile boolean initialized = false;

    public OrzBotManager(OrzMC plugin) {
        this.plugin = plugin;
        this.bots = Collections.emptyMap();
    }

    public void setup() {
        this.bots = Map.of("qq", new OrzQQBot(this.plugin), "discord", new OrzDiscordBot(this.plugin), "lark", new OrzLarkBot(this.plugin));
        this.bots.values().forEach(OrzBaseBot::setup);
        this.initialized = true;
        this.flushPending();
    }

    public void sendMessage(String message, boolean isPrivate) {
        if (!this.initialized) {
            long throttleMs = this.plugin.configManager.getConfig("bot").getLong("log_throttle_ms");
            ThrottledLogger.info("bots-init", "\u673a\u5668\u4eba\u5c1a\u672a\u5c31\u7eea\uff0c\u6d88\u606f\u5df2\u7f13\u5b58", throttleMs <= 0L ? 5000L : throttleMs);
            this.pending.add(new PendingMessage(message, isPrivate));
            return;
        }
        long throttleMs = this.plugin.configManager.getConfig("bot").getLong("log_throttle_ms");
        this.bots.values().forEach(bot -> {
            try {
                if (isPrivate) {
                    bot.sendPrivateMessage(message);
                } else {
                    bot.sendMessage(message);
                }
            }
            catch (Exception e) {
                ThrottledLogger.warning("bot-send", "\u6d88\u606f\u53d1\u9001\u5931\u8d25: " + bot.getClass().getSimpleName() + " - " + String.valueOf(e), throttleMs <= 0L ? 5000L : throttleMs);
            }
        });
    }

    public void tearDown() {
        this.initialized = false;
        this.bots.values().forEach(OrzBaseBot::teardown);
        this.bots = Collections.emptyMap();
        this.pending.clear();
    }

    private void flushPending() {
        PendingMessage pm;
        while ((pm = this.pending.poll()) != null) {
            this.sendMessage(pm.message, pm.isPrivate);
        }
    }

    private record PendingMessage(String message, boolean isPrivate) {
    }
}

