/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.utils;

import com.jokerhub.paper.plugin.orzmc.OrzMC;
import com.jokerhub.paper.plugin.orzmc.utils.WebSocketEventListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public class RobustWebSocketClient {
    private final URI serverUri;
    private final ScheduledExecutorService executor;
    private final int maxRetries;
    private final long baseRetryInterval;
    private final Map<String, String> httpHeaders;
    private final WebSocketEventListener listener;
    private WebSocketClient client;
    private volatile boolean shouldReconnect = true;
    private int retryCount = 0;

    public RobustWebSocketClient(String url, int maxRetries, long baseRetryInterval, Map<String, String> httpHeaders, WebSocketEventListener listener) throws URISyntaxException {
        this.serverUri = new URI(url);
        this.maxRetries = maxRetries;
        this.baseRetryInterval = baseRetryInterval;
        this.httpHeaders = httpHeaders;
        this.listener = listener;
        this.executor = Executors.newScheduledThreadPool(3);
        this.createClient();
    }

    private void createClient() {
        this.client = new WebSocketClient(this.serverUri, this.httpHeaders){

            @Override
            public void onOpen(ServerHandshake handshakeData) {
                OrzMC.logger().info("WebSocket\u8fde\u63a5\u5efa\u7acb");
                RobustWebSocketClient.this.retryCount = 0;
                if (RobustWebSocketClient.this.listener != null) {
                    RobustWebSocketClient.this.listener.onOpen();
                }
            }

            @Override
            public void onMessage(String message) {
                OrzMC.debugInfo("\u63a5\u6536\u5230\u6d88\u606f: " + message);
                RobustWebSocketClient.this.handleMessage(message);
            }

            @Override
            public void onClose(int code, String reason, boolean remote) {
                OrzMC.logger().info("WebSocket\u8fde\u63a5\u5173\u95ed: " + reason);
                if (RobustWebSocketClient.this.listener != null) {
                    RobustWebSocketClient.this.listener.onClose(code, reason, remote);
                }
                if (RobustWebSocketClient.this.shouldReconnect) {
                    RobustWebSocketClient.this.scheduleReconnect();
                }
            }

            @Override
            public void onError(Exception ex) {
                OrzMC.logger().severe("WebSocket\u9519\u8bef: " + ex.getMessage());
                if (RobustWebSocketClient.this.listener != null) {
                    RobustWebSocketClient.this.listener.onError(ex);
                }
                if (!this.isOpen() && RobustWebSocketClient.this.shouldReconnect) {
                    RobustWebSocketClient.this.scheduleReconnect();
                }
            }
        };
        this.client.setConnectionLostTimeout(30);
    }

    public void connect() {
        try {
            OrzMC.logger().info("\u5c1d\u8bd5\u8fde\u63a5WebSocket...");
            this.client.connect();
        }
        catch (Exception e) {
            OrzMC.logger().severe("\u8fde\u63a5\u5931\u8d25: " + e.getMessage());
            this.scheduleReconnect();
        }
    }

    public void disconnect() {
        this.shouldReconnect = false;
        this.client.close();
        this.executor.shutdown();
    }

    private void scheduleReconnect() {
        if (this.retryCount >= this.maxRetries) {
            OrzMC.logger().severe("\u8fbe\u5230\u6700\u5927\u91cd\u8bd5\u6b21\u6570\uff0c\u505c\u6b62\u91cd\u8fde");
            return;
        }
        ++this.retryCount;
        long delay = this.calculateBackoffDelay();
        OrzMC.logger().info("\u7b2c " + this.retryCount + " \u6b21\u91cd\u8fde\u5c06\u5728 " + delay + "ms \u540e\u8fdb\u884c");
        this.executor.schedule(() -> {
            if (this.shouldReconnect) {
                try {
                    if (this.client != null) {
                        this.client.reconnect();
                    } else {
                        this.createClient();
                        this.connect();
                    }
                }
                catch (Exception e) {
                    OrzMC.logger().severe("\u91cd\u8fde\u5931\u8d25: " + e.getMessage());
                    this.scheduleReconnect();
                }
            }
        }, delay, TimeUnit.MILLISECONDS);
    }

    private long calculateBackoffDelay() {
        return (long)((double)this.baseRetryInterval * Math.pow(2.0, this.retryCount - 1));
    }

    protected void handleMessage(String message) {
    }
}

