/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.utils;

import com.jokerhub.orzmc.world.Optimizer;
import com.jokerhub.orzmc.world.ProgressMode;
import com.jokerhub.orzmc.world.ProgressStage;
import com.jokerhub.paper.plugin.orzmc.OrzMC;
import com.jokerhub.paper.plugin.orzmc.utils.OrzUserCmd;
import com.jokerhub.paper.plugin.orzmc.utils.OrzUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class OrzMessageParser {
    public static volatile boolean isBackupRunning = false;

    public static void parse(String message, Boolean isAdmin, Consumer<String> callback) {
        if (!OrzUserCmd.isValidCmd(message)) {
            return;
        }
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList(message.split("[, ]+")));
        String cmdString = cmd.removeFirst();
        HashSet<String> userNameSet = new HashSet<String>(cmd);
        if (cmdString.equals(OrzUserCmd.SHOW_PLAYERS.getCmdString())) {
            OrzMessageParser.onlinePlayersInfo(callback);
        } else if (cmdString.equals(OrzUserCmd.SHOW_WHITELIST.getCmdString())) {
            Integer page = null;
            if (!cmd.isEmpty()) {
                String token = cmd.getFirst();
                try {
                    page = Integer.parseInt(token);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            OrzMessageParser.whiteListInfo(callback, page, isAdmin);
        } else if (cmdString.equals(OrzUserCmd.SHOW_HELP.getCmdString())) {
            callback.accept(OrzUserCmd.helpInfo());
        } else if (cmdString.equals(OrzUserCmd.ADD_PLAYER_TO_WHITELIST.getCmdString())) {
            OrzMessageParser.addWhiteListInfo(isAdmin, userNameSet, callback);
        } else if (cmdString.equals(OrzUserCmd.REMOVE_PLAYER_FROM_WHITELIST.getCmdString())) {
            OrzMessageParser.removeWhiteListInfo(isAdmin, userNameSet, callback);
        } else if (cmdString.equals(OrzUserCmd.BACKUP.getCmdString())) {
            OrzMessageParser.backup(isAdmin, callback);
        } else {
            callback.accept(OrzUserCmd.helpInfo());
        }
    }

    public static String playerDisplayName(Player player) {
        Object ret = player.getPlayerProfile().getName();
        if (player.isOp()) {
            ret = (String)ret + "(op)";
        }
        String gameMode = "";
        switch (player.getGameMode()) {
            case CREATIVE: {
                gameMode = "\u521b\u9020";
                break;
            }
            case SURVIVAL: {
                gameMode = "\u751f\u5b58";
                break;
            }
            case ADVENTURE: {
                gameMode = "\u5192\u9669";
                break;
            }
            case SPECTATOR: {
                gameMode = "\u89c2\u5bdf";
                break;
            }
        }
        ret = (String)ret + " " + gameMode + "\u6a21\u5f0f";
        return ret;
    }

    private static void onlinePlayersInfo(Consumer<String> callback) {
        OrzMC.server().getScheduler().runTaskAsynchronously((Plugin)OrzMC.plugin(), () -> {
            Object[] objects;
            ArrayList<Player> onlinePlayers = new ArrayList<Player>();
            for (Object obj : objects = OrzMC.server().getOnlinePlayers().toArray()) {
                if (!(obj instanceof Player)) continue;
                Player p = (Player)obj;
                onlinePlayers.add(p);
            }
            String tip = String.format("------\u5f53\u524d\u5728\u7ebf(%d/%d)------", onlinePlayers.size(), OrzMC.server().getMaxPlayers());
            StringBuilder msgBuilder = new StringBuilder(tip);
            for (Player p : onlinePlayers) {
                String name = OrzMessageParser.playerDisplayName(p);
                msgBuilder.append("\n").append(name);
            }
            String ret = msgBuilder.toString();
            callback.accept(ret);
        });
    }

    private static void whiteListInfo(Consumer<String> callback, Integer page, boolean isAdmin) {
        OrzMC.server().getScheduler().runTaskAsynchronously((Plugin)OrzMC.plugin(), () -> {
            ArrayList<OfflinePlayer> whiteListPlayers = OrzMessageParser.allWhiteListPlayer();
            String header = String.format("------\u5f53\u524d\u767d\u540d\u5355\u73a9\u5bb6(%d)------", whiteListPlayers.size());
            ArrayList<String> lines = new ArrayList<String>();
            for (OfflinePlayer player : whiteListPlayers) {
                String playerName = player.getName();
                String isOnline = player.isOnline() ? "\u2022" : "\u25e6";
                StringBuilder line = new StringBuilder().append(isOnline).append(" ").append(playerName);
                long lastSeenTimestamp = player.getLastSeen();
                if (lastSeenTimestamp > 0L) {
                    String lastSeen = new SimpleDateFormat("yyyy/MM/dd HH:mm").format(new Date(lastSeenTimestamp));
                    line.append(" ").append(lastSeen);
                }
                lines.add(line.toString());
            }
            FileConfiguration cfg = OrzMC.plugin().configManager.getConfig("config");
            int delayTicks = cfg.getInt("whitelist_pagination_delay_ticks", 5);
            int inactiveDays = cfg.getInt("whitelist_cleanup_inactive_days", 90);
            ArrayList<OfflinePlayer> toRemove = new ArrayList<OfflinePlayer>();
            if (isAdmin) {
                long now = System.currentTimeMillis();
                long threshold = now - (long)inactiveDays * 24L * 60L * 60L * 1000L;
                for (OfflinePlayer p : whiteListPlayers) {
                    long lastSeen = p.getLastSeen();
                    if (lastSeen > 0L && lastSeen >= threshold) continue;
                    toRemove.add(p);
                }
            }
            if (!toRemove.isEmpty()) {
                OrzMC.server().getScheduler().runTask((Plugin)OrzMC.plugin(), () -> {
                    for (OfflinePlayer p : toRemove) {
                        if (!p.isWhitelisted()) continue;
                        p.setWhitelisted(false);
                        Player onlinePlayer = OrzMC.server().getPlayer(p.getUniqueId());
                        if (onlinePlayer == null) continue;
                        onlinePlayer.kick();
                    }
                    OrzMC.server().reloadWhitelist();
                    OrzMC.server().getScheduler().runTaskAsynchronously((Plugin)OrzMC.plugin(), () -> {
                        ArrayList<OfflinePlayer> updated = OrzMessageParser.allWhiteListPlayer();
                        String updatedHeader = String.format("------\u5f53\u524d\u767d\u540d\u5355\u73a9\u5bb6(%d)------", updated.size());
                        ArrayList<String> updatedLines = new ArrayList<String>();
                        for (OfflinePlayer player : updated) {
                            String playerName = player.getName();
                            String isOnline2 = player.isOnline() ? "\u2022" : "\u25e6";
                            StringBuilder line2 = new StringBuilder().append(isOnline2).append(" ").append(playerName);
                            long lastSeen2 = player.getLastSeen();
                            if (lastSeen2 > 0L) {
                                String lastSeenStr = new SimpleDateFormat("yyyy/MM/dd HH:mm").format(new Date(lastSeen2));
                                line2.append(" ").append(lastSeenStr);
                            }
                            updatedLines.add(line2.toString());
                        }
                        ArrayList<String> chunks2 = OrzMessageParser.buildChunks(updatedLines);
                        int total2 = chunks2.size();
                        String removedMsg = "------\u767d\u540d\u5355\u6e05\u7406------\n" + String.join((CharSequence)"\n", toRemove.stream().map(p -> "\u2714\ufe0e " + (p.getName() == null ? "(unknown)" : p.getName())).collect(Collectors.toSet()));
                        callback.accept(removedMsg);
                        if (total2 == 0) {
                            callback.accept(updatedHeader + "\n(\u6682\u65e0\u767d\u540d\u5355\u73a9\u5bb6)");
                            return;
                        }
                        if (page != null) {
                            int idx = Math.max(1, Math.min(page, total2)) - 1;
                            String pageHeader = updatedHeader + "\n\u7b2c" + (idx + 1) + "/" + total2 + "\u9875";
                            String body = chunks2.get(idx);
                            callback.accept(pageHeader + "\n" + body);
                        } else {
                            for (int i = 0; i < total2; ++i) {
                                int pageIndex = i;
                                OrzMC.server().getScheduler().runTaskLater((Plugin)OrzMC.plugin(), () -> {
                                    String pageHeader = updatedHeader + "\n\u7b2c" + (pageIndex + 1) + "/" + total2 + "\u9875";
                                    String body = (String)chunks2.get(pageIndex);
                                    callback.accept(pageHeader + "\n" + body);
                                }, (long)i * (delayTicks <= 0 ? 5L : (long)delayTicks));
                            }
                        }
                    });
                });
            } else {
                ArrayList<String> chunks = OrzMessageParser.buildChunks(lines);
                int total = chunks.size();
                if (total == 0) {
                    callback.accept(header + "\n(\u6682\u65e0\u767d\u540d\u5355\u73a9\u5bb6)");
                    return;
                }
                if (page != null) {
                    int idx = Math.max(1, Math.min(page, total)) - 1;
                    String pageHeader = header + "\n\u7b2c" + (idx + 1) + "/" + total + "\u9875";
                    String body = chunks.get(idx);
                    callback.accept(pageHeader + "\n" + body);
                } else {
                    for (int i = 0; i < total; ++i) {
                        int pageIndex = i;
                        OrzMC.server().getScheduler().runTaskLater((Plugin)OrzMC.plugin(), () -> {
                            String pageHeader = header + "\n\u7b2c" + (pageIndex + 1) + "/" + total + "\u9875";
                            String body = (String)chunks.get(pageIndex);
                            callback.accept(pageHeader + "\n" + body);
                        }, (long)i * (delayTicks <= 0 ? 5L : (long)delayTicks));
                    }
                }
            }
        });
    }

    private static void addWhiteListInfo(boolean isAdmin, Set<String> userNames, Consumer<String> callback) {
        if (!isAdmin) {
            callback.accept(OrzUserCmd.ADD_PLAYER_TO_WHITELIST.adminPermissionRequiredTip());
            return;
        }
        if (userNames.isEmpty()) {
            callback.accept(OrzUserCmd.ADD_PLAYER_TO_WHITELIST.usageTip());
            return;
        }
        OrzMC.server().getScheduler().runTask((Plugin)OrzMC.plugin(), () -> {
            for (String userName : userNames) {
                OfflinePlayer player = OrzMC.server().getOfflinePlayer(userName);
                if (player.isWhitelisted()) continue;
                player.setWhitelisted(true);
            }
            OrzMC.server().getScheduler().runTaskAsynchronously((Plugin)OrzMC.plugin(), () -> {
                OrzMC.server().reloadWhitelist();
                Set<String> allWhiteListName = OrzMessageParser.allWhiteListPlayerName();
                Object message = "------\u767d\u540d\u5355\u6dfb\u52a0------\n";
                if (allWhiteListName.containsAll(userNames)) {
                    message = (String)message + String.join((CharSequence)"\n", userNames.stream().map(name -> "\u2714\ufe0e \ufe0e" + name).collect(Collectors.toSet()));
                }
                userNames.removeAll(allWhiteListName);
                if (!userNames.isEmpty()) {
                    message = (String)message + String.join((CharSequence)"\n", userNames.stream().map(name -> "\u2718 " + name).collect(Collectors.toSet()));
                }
                callback.accept((String)message);
            });
        });
    }

    private static ArrayList<String> buildChunks(ArrayList<String> lines) {
        ArrayList<String> chunks = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        for (String line : lines) {
            if (current.isEmpty()) {
                current.append(line);
                continue;
            }
            if (current.length() + 1 + line.length() <= 1800) {
                current.append("\n").append(line);
                continue;
            }
            chunks.add(current.toString());
            current = new StringBuilder(line);
        }
        if (!current.isEmpty()) {
            chunks.add(current.toString());
        }
        return chunks;
    }

    private static void removeWhiteListInfo(boolean isAdmin, Set<String> userNames, Consumer<String> callback) {
        if (!isAdmin) {
            callback.accept(OrzUserCmd.REMOVE_PLAYER_FROM_WHITELIST.adminPermissionRequiredTip());
            return;
        }
        if (userNames.isEmpty()) {
            callback.accept(OrzUserCmd.REMOVE_PLAYER_FROM_WHITELIST.usageTip());
            return;
        }
        OrzMC.server().getScheduler().runTask((Plugin)OrzMC.plugin(), () -> {
            for (String userName : userNames) {
                OfflinePlayer player = OrzMC.server().getOfflinePlayer(userName);
                if (!player.isWhitelisted()) continue;
                player.setWhitelisted(false);
                Player onlinePlayer = OrzMC.server().getPlayer(player.getUniqueId());
                if (onlinePlayer == null) continue;
                onlinePlayer.kick();
            }
            OrzMC.server().getScheduler().runTaskAsynchronously((Plugin)OrzMC.plugin(), () -> {
                OrzMC.server().reloadWhitelist();
                Set<String> allWhiteListName = OrzMessageParser.allWhiteListPlayerName();
                Object message = "------\u767d\u540d\u5355\u79fb\u9664------\n";
                if (!allWhiteListName.containsAll(userNames)) {
                    message = (String)message + String.join((CharSequence)"\n", userNames.stream().map(name -> "\u2714\ufe0e " + name).collect(Collectors.toSet()));
                }
                userNames.retainAll(allWhiteListName);
                if (!userNames.isEmpty()) {
                    message = (String)message + String.join((CharSequence)"\n", userNames.stream().map(name -> "\u2718 " + name).collect(Collectors.toSet()));
                }
                callback.accept((String)message);
            });
        });
    }

    private static ArrayList<OfflinePlayer> allWhiteListPlayer() {
        ArrayList<OfflinePlayer> whiteListPlayers = new ArrayList<OfflinePlayer>(OrzMC.server().getWhitelistedPlayers());
        whiteListPlayers.sort((o1, o2) -> Long.compare(o2.getLastSeen(), o1.getLastSeen()));
        return whiteListPlayers;
    }

    private static Set<String> allWhiteListPlayerName() {
        return OrzMessageParser.allWhiteListPlayer().stream().map(OfflinePlayer::getName).collect(Collectors.toSet());
    }

    private static void backup(boolean isAdmin, Consumer<String> callback) {
        if (!isAdmin) {
            callback.accept(OrzUserCmd.BACKUP.adminPermissionRequiredTip());
            return;
        }
        if (isBackupRunning) {
            callback.accept("\u6b63\u5728\u5907\u4efd\u4e2d\uff0c\u8bf7\u7a0d\u5019...");
            return;
        }
        OrzMC.server().getScheduler().runTask((Plugin)OrzMC.plugin(), () -> {
            isBackupRunning = true;
            OrzMC.server().getOnlinePlayers().forEach(p -> p.kick((Component)Component.text((String)"\u670d\u52a1\u5668\u5730\u56fe\u5907\u4efd\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u5c1d\u8bd5\u767b\u5f55\u3002")));
            OrzUtil.executeConsoleCmd(() -> callback.accept("\u505c\u6b62\u670d\u52a1\u5668\u81ea\u52a8\u5730\u56fe\u4fdd\u5b58\u529f\u80fd"), "save-off", "save-all");
            OrzMC.server().getScheduler().runTaskAsynchronously((Plugin)OrzMC.plugin(), () -> {
                boolean created;
                File worldContainerDir = OrzMC.server().getWorldContainer();
                File worldBackupDir = new File(OrzMC.plugin().getDataFolder(), "backup");
                if (!worldBackupDir.exists() && !(created = worldBackupDir.mkdirs())) {
                    OrzMC.logger().warning("\u521b\u5efa\u5730\u56fe\u5907\u4efd\u76ee\u5f55\u5931\u8d25: " + worldBackupDir.getAbsolutePath());
                    OrzUtil.executeConsoleCmd(() -> callback.accept("\u6062\u590d\u670d\u52a1\u5668\u81ea\u52a8\u5730\u56fe\u4fdd\u5b58\u529f\u80fd"), "save-on");
                    return;
                }
                Path input = Path.of(worldContainerDir.getAbsolutePath(), new String[0]);
                callback.accept("\u5730\u56fe\u76ee\u5f55\uff1a" + String.valueOf(input));
                File worldBackupTempDir = new File(worldBackupDir, "tempDir");
                Path output = Path.of(worldBackupTempDir.getAbsolutePath(), new String[0]);
                callback.accept("\u5907\u4efd\u76ee\u5f55\uff1a" + String.valueOf(worldBackupDir));
                long tickTimeThreshold = 300L;
                callback.accept("\u6b63\u5728\u5907\u4efd\u5730\u56fe\uff0c\u8bf7\u7a0d\u7b49......");
                Optimizer.run(input, output, tickTimeThreshold, false, ProgressMode.Region, true, false, true, true, 100L, 1000L, optimizeError -> {
                    OrzMC.logger().warning(optimizeError.toString());
                    callback.accept("\u5730\u56fe\u5907\u4efd\u5931\u8d25");
                    return null;
                }, progressEvent -> {
                    Long current = progressEvent.getCurrent();
                    Long total = progressEvent.getTotal();
                    if (current == null || total == null || current <= 0L || total <= 0L) {
                        return null;
                    }
                    int percent = (int)Math.ceil((double)progressEvent.getCurrent().longValue() * 100.0 / (double)progressEvent.getTotal().longValue());
                    OrzMC.logger().info("\u5730\u56fe\u5907\u4efd\u8fdb\u5ea6\uff1a" + percent + "%");
                    if (progressEvent.getStage() == ProgressStage.Done && Objects.equals(progressEvent.getCurrent(), progressEvent.getTotal())) {
                        callback.accept("\u5730\u56fe\u5907\u4efd\u5b8c\u6210");
                    }
                    return null;
                });
                OrzMessageParser.pruneOldZips(worldBackupDir);
                OrzUtil.executeConsoleCmd(() -> callback.accept("\u6062\u590d\u670d\u52a1\u5668\u81ea\u52a8\u5730\u56fe\u4fdd\u5b58\u529f\u80fd"), "save-on");
                isBackupRunning = false;
            });
        });
    }

    private static void pruneOldZips(File backupDir) {
        File[] zips;
        int retain = OrzMC.plugin().getConfig().getInt("backup_retention_count", 10);
        if (retain <= 0) {
            retain = 10;
        }
        if ((zips = backupDir.listFiles(f -> f.isFile() && f.getName().endsWith(".zip"))) == null || zips.length <= retain) {
            return;
        }
        Arrays.sort(zips, (a, b) -> {
            try {
                BasicFileAttributes ab = Files.readAttributes(a.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                BasicFileAttributes bb = Files.readAttributes(b.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                return Long.compare(bb.creationTime().toMillis(), ab.creationTime().toMillis());
            }
            catch (Exception e) {
                return Long.compare(b.lastModified(), a.lastModified());
            }
        });
        for (int i = retain; i < zips.length; ++i) {
            try {
                boolean deleted = zips[i].delete();
                if (deleted) continue;
                OrzMC.logger().warning("\u5220\u9664\u65e7\u5907\u4efd\u5931\u8d25: " + zips[i].getName());
                continue;
            }
            catch (Exception e) {
                OrzMC.logger().severe("\u6e05\u7406\u65e7\u5907\u4efd\u5f02\u5e38: " + String.valueOf(e));
            }
        }
    }
}

