/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc;

import com.jokerhub.paper.plugin.orzmc.commands.OrzBotStatus;
import com.jokerhub.paper.plugin.orzmc.commands.OrzGuideBook;
import com.jokerhub.paper.plugin.orzmc.commands.OrzMenuCommand;
import com.jokerhub.paper.plugin.orzmc.commands.OrzTPBow;
import com.jokerhub.paper.plugin.orzmc.events.OrzBowShootEvent;
import com.jokerhub.paper.plugin.orzmc.events.OrzDebugEvent;
import com.jokerhub.paper.plugin.orzmc.events.OrzMenuEvent;
import com.jokerhub.paper.plugin.orzmc.events.OrzPlayerEvent;
import com.jokerhub.paper.plugin.orzmc.events.OrzServerEvent;
import com.jokerhub.paper.plugin.orzmc.events.OrzTNTEvent;
import com.jokerhub.paper.plugin.orzmc.events.OrzTPEvent;
import com.jokerhub.paper.plugin.orzmc.events.OrzWhiteListEvent;
import com.jokerhub.paper.plugin.orzmc.utils.bot.OrzBotManager;
import com.jokerhub.paper.plugin.orzmc.utils.config.AdvancedConfigManager;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.GameMode;
import org.bukkit.Server;
import org.bukkit.command.PluginCommand;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class OrzMC
extends JavaPlugin
implements Listener {
    public AdvancedConfigManager configManager;
    private OrzBotManager botManager;

    public void onEnable() {
        this.getLogger().info("OrzMC \u63d2\u4ef6\u751f\u6548!");
        this.setupConfigManager();
        this.setupEventListener();
        this.setupCommandHandler();
        this.setupBotManager();
        this.setupServerForceWhitelist();
    }

    public void onDisable() {
        this.getLogger().info("OrzMC \u63d2\u4ef6\u5931\u6548!");
        this.tearDownBotManager();
        this.tearDownConfigManager();
        this.notifyServerStop();
    }

    public static OrzMC plugin() {
        return (OrzMC)JavaPlugin.getPlugin(OrzMC.class);
    }

    public static Server server() {
        return OrzMC.plugin().getServer();
    }

    public static Logger logger() {
        return OrzMC.plugin().getLogger();
    }

    public void sendPublicMessage(String message) {
        OrzMC.debugInfo(message);
        this.botManager.sendMessage(message, false);
    }

    public void sendPrivateMessage(String message) {
        OrzMC.debugInfo(message);
        this.botManager.sendMessage(message, true);
    }

    public static void debugInfo(String msg) {
        if (!OrzDebugEvent.debug) {
            return;
        }
        OrzMC.logger().info(msg);
    }

    private void notifyServerStop() {
        String minecraftVersion = this.getServer().getMinecraftVersion();
        String stringBuilder = "Minecraft " + minecraftVersion + "\n------\n\u670d\u52a1\u505c\u6b62\n\n\u505c\u6b62\u72b6\u6001\u65e0\u6cd5\u54cd\u5e94\u547d\u4ee4\u6d88\u606f";
        this.sendPublicMessage(stringBuilder);
    }

    private void setupServerForceWhitelist() {
        boolean forceWhitelist = this.configManager.getConfig("config").getBoolean("force_whitelist");
        this.getServer().setWhitelist(forceWhitelist);
        this.getServer().setWhitelistEnforced(forceWhitelist);
        this.getServer().reloadWhitelist();
        this.getServer().setDefaultGameMode(GameMode.SURVIVAL);
        if (forceWhitelist) {
            this.getLogger().info("\u670d\u52a1\u7aef\u4f7f\u7528\u5f3a\u5236\u767d\u540d\u5355\u673a\u5236");
        }
    }

    private void setupEventListener() {
        Listener[] eventListeners = new Listener[]{new OrzBowShootEvent(), new OrzPlayerEvent(this), new OrzTPEvent(), new OrzTNTEvent(this), new OrzMenuEvent(), new OrzServerEvent(this), new OrzWhiteListEvent(this), new OrzDebugEvent()};
        Arrays.stream(eventListeners).forEach(eventListener -> this.getServer().getPluginManager().registerEvents(eventListener, (Plugin)this));
    }

    private void setupCommandHandler() {
        Map<String, OrzBotStatus> commandHandlers = Map.of("tpbow", new OrzTPBow(), "guide", new OrzGuideBook(), "menu", new OrzMenuCommand(), "botstatus", new OrzBotStatus());
        commandHandlers.forEach((key, value) -> {
            PluginCommand cmd = this.getCommand((String)key);
            if (cmd != null) {
                cmd.setExecutor(value);
            }
        });
    }

    private void setupBotManager() {
        this.botManager = new OrzBotManager(this);
        this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            try {
                this.botManager.setup();
            }
            catch (Exception e) {
                this.getLogger().severe("BotManager \u521d\u59cb\u5316\u5931\u8d25: " + e.getMessage());
            }
        });
    }

    private void tearDownBotManager() {
        this.botManager.tearDown();
    }

    private void setupConfigManager() {
        this.configManager = new AdvancedConfigManager(this);
        this.configManager.registerConfig("config");
        this.configManager.setDefaults("config", config -> {});
        this.configManager.registerConfig("bot");
        this.configManager.setDefaults("bot", config -> {});
        this.configManager.registerConfig("guide_book");
        this.configManager.setDefaults("guide_book", config -> {});
        this.configManager.registerConfig("tnt");
        this.configManager.setDefaults("tnt", config -> {});
    }

    private void tearDownConfigManager() {
        for (String configName : this.configManager.getConfigNames()) {
            this.configManager.saveConfig(configName);
        }
    }
}

