/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.orzmc.world;

import com.jokerhub.orzmc.mca.McaEntry;
import com.jokerhub.orzmc.mca.McaReader;
import com.jokerhub.orzmc.mca.McaWriter;
import com.jokerhub.orzmc.patterns.ChunkPattern;
import com.jokerhub.orzmc.patterns.InhabitedTimePattern;
import com.jokerhub.orzmc.patterns.ListPattern;
import com.jokerhub.orzmc.world.ForceLoadedParseException;
import com.jokerhub.orzmc.world.InPlaceReplacementException;
import com.jokerhub.orzmc.world.NbtForceLoader;
import com.jokerhub.orzmc.world.OptimizeError;
import com.jokerhub.orzmc.world.OptimizeReport;
import com.jokerhub.orzmc.world.Optimizer;
import com.jokerhub.orzmc.world.ProgressEvent;
import com.jokerhub.orzmc.world.ProgressMode;
import com.jokerhub.orzmc.world.ProgressStage;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\t\u001a\u00020\u0007H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002J*\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f0\u00062\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u00a0\u0001\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u000b2\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u000b2\b\b\u0002\u0010\u001c\u001a\u00020\u000b2\b\b\u0002\u0010\u001d\u001a\u00020\u000b2\b\b\u0002\u0010\u0012\u001a\u00020\u000b2\b\b\u0002\u0010\u001e\u001a\u00020\u00042\b\b\u0002\u0010\u001f\u001a\u00020\u00042\u0016\b\u0002\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#\u0018\u00010!2\u0016\b\u0002\u0010$\u001a\u0010\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020#\u0018\u00010!H\u0007J\u00a0\u0001\u0010&\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u000b2\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u000b2\b\b\u0002\u0010\u001c\u001a\u00020\u000b2\b\b\u0002\u0010\u001d\u001a\u00020\u000b2\b\b\u0002\u0010\u0012\u001a\u00020\u000b2\b\b\u0002\u0010\u001e\u001a\u00020\u00042\b\b\u0002\u0010\u001f\u001a\u00020\u00042\u0016\b\u0002\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#\u0018\u00010!2\u0016\b\u0002\u0010$\u001a\u0010\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020#\u0018\u00010!H\u0007\u00a8\u0006'"}, d2={"Lcom/jokerhub/orzmc/world/Optimizer;", "", "()V", "countTotalChunks", "", "dims", "", "Ljava/nio/file/Path;", "discoverDimensions", "root", "isDimensionDir", "", "path", "isValidMca", "parseForceLoaded", "Lkotlin/Pair;", "", "dimension", "strict", "run", "Lcom/jokerhub/orzmc/world/OptimizeReport;", "input", "output", "inhabitedThresholdSeconds", "removeUnknown", "progressMode", "Lcom/jokerhub/orzmc/world/ProgressMode;", "zipOutput", "inPlace", "force", "progressInterval", "progressIntervalMs", "onError", "Lkotlin/Function1;", "Lcom/jokerhub/orzmc/world/OptimizeError;", "", "onProgress", "Lcom/jokerhub/orzmc/world/ProgressEvent;", "runWithReport", "core"})
@SourceDebugExtension(value={"SMAP\nOptimizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Optimizer.kt\ncom/jokerhub/orzmc/world/Optimizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,332:1\n1855#2,2:333\n1855#2:335\n1855#2:336\n1856#2:338\n1856#2:339\n1#3:337\n*S KotlinDebug\n*F\n+ 1 Optimizer.kt\ncom/jokerhub/orzmc/world/Optimizer\n*L\n113#1:333,2\n211#1:335\n215#1:336\n215#1:338\n211#1:339\n*E\n"})
public final class Optimizer {
    @NotNull
    public static final Optimizer INSTANCE = new Optimizer();

    private Optimizer() {
    }

    @JvmStatic
    @NotNull
    public static final OptimizeReport run(@NotNull Path input, @Nullable Path output, long inhabitedThresholdSeconds, boolean removeUnknown, @NotNull ProgressMode progressMode, boolean zipOutput, boolean inPlace, boolean force, boolean strict, long progressInterval, long progressIntervalMs, @Nullable Function1<? super OptimizeError, Unit> onError, @Nullable Function1<? super ProgressEvent, Unit> onProgress) {
        Intrinsics.checkNotNullParameter(input, "input");
        Intrinsics.checkNotNullParameter((Object)progressMode, "progressMode");
        return Optimizer.runWithReport(input, output, inhabitedThresholdSeconds, removeUnknown, progressMode, zipOutput, inPlace, force, strict, progressInterval, progressIntervalMs, onError, onProgress);
    }

    public static /* synthetic */ OptimizeReport run$default(Path path, Path path2, long l, boolean bl, ProgressMode progressMode, boolean bl2, boolean bl3, boolean bl4, boolean bl5, long l2, long l3, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 0x10) != 0) {
            progressMode = ProgressMode.Region;
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        if ((n & 0x40) != 0) {
            bl3 = false;
        }
        if ((n & 0x80) != 0) {
            bl4 = false;
        }
        if ((n & 0x100) != 0) {
            bl5 = false;
        }
        if ((n & 0x200) != 0) {
            l2 = 1000L;
        }
        if ((n & 0x400) != 0) {
            l3 = 0L;
        }
        if ((n & 0x800) != 0) {
            function1 = null;
        }
        if ((n & 0x1000) != 0) {
            function12 = null;
        }
        return Optimizer.run(path, path2, l, bl, progressMode, bl2, bl3, bl4, bl5, l2, l3, function1, function12);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JvmStatic
    @NotNull
    public static final OptimizeReport runWithReport(@NotNull Path input, @Nullable Path output, long inhabitedThresholdSeconds, boolean removeUnknown, @NotNull ProgressMode progressMode, boolean zipOutput, boolean inPlace, boolean force, boolean strict, long progressInterval, long progressIntervalMs, @Nullable Function1<? super OptimizeError, Unit> onError, @Nullable Function1<? super ProgressEvent, Unit> onProgress) {
        block64: {
            Intrinsics.checkNotNullParameter(input, "input");
            Intrinsics.checkNotNullParameter((Object)progressMode, "progressMode");
            errors = new ArrayList<E>();
            useTime = progressIntervalMs > 0L;
            lastEmit = new Ref.LongRef();
            lastEmit.element = System.currentTimeMillis();
            if (!Files.isDirectory(input, new LinkOption[0])) {
                msg = "\u8f93\u5165\u76ee\u5f55\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u76ee\u5f55";
                Optimizer.runWithReport$record(onError, errors, input, "Input", msg);
                return new OptimizeReport(0L, 0L, errors);
            }
            Optimizer.runWithReport$emit(onProgress, ProgressStage.Init, 0L, 0L, input, "\u5f00\u59cb");
            ticks = inhabitedThresholdSeconds * (long)20;
            if (inPlace) {
                var22_18 = Files.createTempDirectory("thanos-", new FileAttribute[0]);
                Intrinsics.checkNotNull(var22_18);
                v0 = var22_18;
            } else {
                block59: {
                    if (output == null) {
                        msg = "\u975e\u539f\u5730\u6a21\u5f0f\u5fc5\u987b\u6307\u5b9a\u8f93\u51fa\u76ee\u5f55";
                        v1 = Path.of("<none>", new String[0]);
                        Intrinsics.checkNotNullExpressionValue(v1, "of(...)");
                        Optimizer.runWithReport$record(onError, errors, v1, "Output", msg);
                        return new OptimizeReport(0L, 0L, errors);
                    }
                    try {
                        if (Files.exists(output, new LinkOption[0])) {
                            nonEmpty = Files.list(output).findFirst().isPresent();
                            if (nonEmpty) {
                                if (!force) {
                                    msg = "\u8f93\u51fa\u76ee\u5f55\u5df2\u5b58\u5728\u4e14\u975e\u7a7a\uff0c\u4f7f\u7528 --force \u8986\u76d6";
                                    Optimizer.runWithReport$record(onError, errors, output, "Output", msg);
                                    return new OptimizeReport(0L, 0L, errors);
                                }
                                Files.walk(output, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach((Consumer<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, runWithReport$lambda$0(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)V)((Function1)runWithReport.out.1.INSTANCE));
                                Files.createDirectories(output, new FileAttribute[0]);
                            }
                            break block59;
                        }
                        Files.createDirectories(output, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        msg = "\u8f93\u51fa\u76ee\u5f55\u4e0d\u53ef\u5199\u6216\u8bbf\u95ee\u53d7\u9650\uff1a" + output;
                        Optimizer.runWithReport$record(onError, errors, output, "Output", msg);
                        return new OptimizeReport(0L, 0L, errors);
                    }
                }
                v0 = output;
            }
            out = v0;
            Optimizer.runWithReport$emit(onProgress, ProgressStage.Discover, null, null, input, "\u626b\u63cf\u7ef4\u5ea6");
            tasks = Optimizer.INSTANCE.discoverDimensions(input);
            totalChunks = Optimizer.INSTANCE.countTotalChunks(tasks);
            processedChunks = new Ref.LongRef();
            removedTotal = new Ref.LongRef();
            Optimizer.runWithReport$emit(onProgress, ProgressStage.Discover, 0L, totalChunks, input, "\u7edf\u8ba1\u533a\u5757");
            $this$forEach$iv = tasks;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                dim = (Path)element$iv /* !! */ ;
                $i$a$-forEach-Optimizer$runWithReport$1 = false;
                Optimizer.runWithReport$emit(onProgress, ProgressStage.DimensionStart, null, null, (Path)dim, null);
                rel = input.relativize((Path)dim);
                targetDim = out.resolve(rel);
                Files.createDirectories(targetDim, new FileAttribute[0]);
                try {
                    var35_44 /* !! */  = Optimizer.INSTANCE.parseForceLoaded((Path)dim, strict);
                }
                catch (ForceLoadedParseException e) {
                    if (strict) {
                        v2 = e.getMessage();
                        if (v2 == null) {
                            v2 = "\u89e3\u6790\u5f3a\u5236\u52a0\u8f7d\u5217\u8868\u5931\u8d25";
                        }
                        Optimizer.runWithReport$record(onError, errors, (Path)dim, "ForceLoaded", v2);
                    }
                    var35_44 /* !! */  = CollectionsKt.emptyList();
                }
                forced /* !! */  = var35_44 /* !! */ ;
                e = new ChunkPattern[]{new ListPattern(forced /* !! */ ), new InhabitedTimePattern(ticks, removeUnknown)};
                patterns = CollectionsKt.mutableListOf(e);
                regionDir /* !! */  = dim.resolve("region");
                entitiesDir = dim.resolve("entities");
                poiDir = dim.resolve("poi");
                Files.createDirectories(targetDim.resolve("region"), new FileAttribute[0]);
                if (Files.isDirectory(entitiesDir, new LinkOption[0])) {
                    Files.createDirectories(targetDim.resolve("entities"), new FileAttribute[0]);
                }
                if (Files.isDirectory(poiDir, new LinkOption[0])) {
                    Files.createDirectories(targetDim.resolve("poi"), new FileAttribute[0]);
                }
                var40_51 = Files.list((Path)regionDir /* !! */ );
                var41_52 = null;
                try {
                    stream = (Stream)var40_51;
                    $i$a$-use-Optimizer$runWithReport$1$1 = false;
                    stream.filter((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, runWithReport$lambda$4$lambda$3$lambda$1(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Z)((Function1)runWithReport.1.1.1.INSTANCE)).forEach((Consumer<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, runWithReport$lambda$4$lambda$3$lambda$2(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)V)((Function1)new Function1<Path, Unit>(strict, targetDim, entitiesDir, poiDir, patterns, removedTotal, processedChunks, useTime, lastEmit, progressIntervalMs, totalChunks, progressInterval, progressMode, onProgress, onError, (List<OptimizeError>)errors){
                        final /* synthetic */ boolean $strict;
                        final /* synthetic */ Path $targetDim;
                        final /* synthetic */ Path $entitiesDir;
                        final /* synthetic */ Path $poiDir;
                        final /* synthetic */ List<ChunkPattern> $patterns;
                        final /* synthetic */ Ref.LongRef $removedTotal;
                        final /* synthetic */ Ref.LongRef $processedChunks;
                        final /* synthetic */ boolean $useTime;
                        final /* synthetic */ Ref.LongRef $lastEmit;
                        final /* synthetic */ long $progressIntervalMs;
                        final /* synthetic */ long $totalChunks;
                        final /* synthetic */ long $progressInterval;
                        final /* synthetic */ ProgressMode $progressMode;
                        final /* synthetic */ Function1<ProgressEvent, Unit> $onProgress;
                        final /* synthetic */ Function1<OptimizeError, Unit> $onError;
                        final /* synthetic */ List<OptimizeError> $errors;
                        {
                            this.$strict = $strict;
                            this.$targetDim = $targetDim;
                            this.$entitiesDir = $entitiesDir;
                            this.$poiDir = $poiDir;
                            this.$patterns = $patterns;
                            this.$removedTotal = $removedTotal;
                            this.$processedChunks = $processedChunks;
                            this.$useTime = $useTime;
                            this.$lastEmit = $lastEmit;
                            this.$progressIntervalMs = $progressIntervalMs;
                            this.$totalChunks = $totalChunks;
                            this.$progressInterval = $progressInterval;
                            this.$progressMode = $progressMode;
                            this.$onProgress = $onProgress;
                            this.$onError = $onError;
                            this.$errors = $errors;
                            super(1);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        public final void invoke(Path rf) {
                            Optimizer.access$runWithReport$emit(this.$onProgress, ProgressStage.RegionStart, null, null, rf, null);
                            Intrinsics.checkNotNull(rf);
                            if (!Optimizer.access$isValidMca(Optimizer.INSTANCE, rf)) {
                                Optimizer.access$runWithReport$record(this.$onError, this.$errors, rf, "MCA", "MCA \u6587\u4ef6\u635f\u574f\u6216\u4e0d\u5b8c\u6574");
                                if (!this.$strict) {
                                    return;
                                }
                            }
                            name = rf.getFileName().toString();
                            try {
                                var4_3 = McaReader.Companion.open(rf.toString());
                            }
                            catch (Exception e) {
                                Optimizer.access$runWithReport$record(this.$onError, this.$errors, rf, "MCA", "\u65e0\u6cd5\u8bfb\u53d6 MCA \u6587\u4ef6");
                                return;
                            }
                            cr = var4_3;
                            cw = new McaWriter(this.$targetDim.resolve("region").resolve(name).toString());
                            efile = this.$entitiesDir.resolve(name);
                            pfile = this.$poiDir.resolve(name);
                            if (!Files.isRegularFile(efile, new LinkOption[0])) ** GOTO lbl-1000
                            Intrinsics.checkNotNull(efile);
                            if (Optimizer.access$isValidMca(Optimizer.INSTANCE, efile)) {
                                v0 = new McaWriter(this.$targetDim.resolve("entities").resolve(name).toString());
                            } else lbl-1000:
                            // 2 sources

                            {
                                v0 = ew = null;
                            }
                            if (!Files.isRegularFile(pfile, new LinkOption[0])) ** GOTO lbl-1000
                            Intrinsics.checkNotNull(pfile);
                            if (Optimizer.access$isValidMca(Optimizer.INSTANCE, pfile)) {
                                v1 = new McaWriter(this.$targetDim.resolve("poi").resolve(name).toString());
                            } else lbl-1000:
                            // 2 sources

                            {
                                v1 = null;
                            }
                            pw = v1;
                            removed = 0L;
                            try {
                                var12_11 = cr.entries();
                            }
                            catch (Exception e) {
                                Optimizer.access$runWithReport$record(this.$onError, this.$errors, rf, "Entries", "\u8bfb\u53d6\u533a\u5757\u6761\u76ee\u5931\u8d25");
                                var12_11 = CollectionsKt.emptyList();
                            }
                            entries = var12_11;
                            for (McaEntry entry : entries) {
                                block41: {
                                    block42: {
                                        keep = false;
                                        for (ChunkPattern p : this.$patterns) {
                                            try {
                                                if (!p.matches(entry)) continue;
                                                keep = true;
                                                break;
                                            }
                                            catch (Exception e) {
                                                Optimizer.access$runWithReport$record(this.$onError, this.$errors, rf, "Pattern", "\u5339\u914d\u6a21\u5f0f\u5931\u8d25");
                                            }
                                        }
                                        if (!keep) break block42;
                                        try {
                                            cw.writeEntry(entry);
                                        }
                                        catch (Exception e) {
                                            Optimizer.access$runWithReport$record(this.$onError, this.$errors, rf, "Write", "\u5199\u5165\u6761\u76ee\u5931\u8d25");
                                        }
                                        try {
                                            if (!Files.isRegularFile(efile, new LinkOption[0])) ** GOTO lbl-1000
                                            Intrinsics.checkNotNull(efile);
                                            if (Optimizer.access$isValidMca(Optimizer.INSTANCE, efile)) {
                                                v2 = McaReader.Companion.open(efile.toString());
                                            } else lbl-1000:
                                            // 2 sources

                                            {
                                                v2 = null;
                                            }
                                            v3 = er = v2;
                                            v4 = eentry = v3 != null ? v3.get(entry.regionIndex()) : null;
                                            if (eentry != null && ew != null) {
                                                try {
                                                    ew.writeEntry(eentry);
                                                }
                                                catch (Exception e) {
                                                    Intrinsics.checkNotNull(efile);
                                                    Optimizer.access$runWithReport$record(this.$onError, this.$errors, efile, "WriteEntities", "\u5199\u5165\u5b9e\u4f53\u6761\u76ee\u5931\u8d25");
                                                }
                                            }
                                        }
                                        catch (Exception e) {
                                            Intrinsics.checkNotNull(efile);
                                            Optimizer.access$runWithReport$record(this.$onError, this.$errors, efile, "Entities", "\u8bfb\u53d6\u5b9e\u4f53\u5931\u8d25");
                                        }
                                        try {
                                            if (!Files.isRegularFile(pfile, new LinkOption[0])) ** GOTO lbl-1000
                                            Intrinsics.checkNotNull(pfile);
                                            if (Optimizer.access$isValidMca(Optimizer.INSTANCE, pfile)) {
                                                v5 = McaReader.Companion.open(pfile.toString());
                                            } else lbl-1000:
                                            // 2 sources

                                            {
                                                v5 = null;
                                            }
                                            v6 = pr = v5;
                                            v7 = pentry = v6 != null ? v6.get(entry.regionIndex()) : null;
                                            if (pentry == null || pw == null) break block41;
                                            try {
                                                pw.writeEntry(pentry);
                                                break block41;
                                            }
                                            catch (Exception e) {
                                                Intrinsics.checkNotNull(pfile);
                                                Optimizer.access$runWithReport$record(this.$onError, this.$errors, pfile, "WritePoi", "\u5199\u5165 POI \u6761\u76ee\u5931\u8d25");
                                            }
                                        }
                                        catch (Exception e) {
                                            Intrinsics.checkNotNull(pfile);
                                            Optimizer.access$runWithReport$record(this.$onError, this.$errors, pfile, "Poi", "\u8bfb\u53d6 POI \u5931\u8d25");
                                        }
                                        break block41;
                                    }
                                    ++removed;
                                    ++this.$removedTotal.element;
                                }
                                ++this.$processedChunks.element;
                                if (this.$useTime) {
                                    now = System.currentTimeMillis();
                                    if (now - this.$lastEmit.element >= this.$progressIntervalMs) {
                                        Optimizer.access$runWithReport$emit(this.$onProgress, ProgressStage.ChunkProgress, this.$processedChunks.element, this.$totalChunks, rf, null);
                                        this.$lastEmit.element = now;
                                    }
                                } else if (this.$progressInterval > 0L && this.$processedChunks.element % this.$progressInterval == 0L) {
                                    Optimizer.access$runWithReport$emit(this.$onProgress, ProgressStage.ChunkProgress, this.$processedChunks.element, this.$totalChunks, rf, null);
                                }
                                if (this.$progressMode != ProgressMode.Global) continue;
                                pct = (int)(this.$processedChunks.element * (long)100 / RangesKt.coerceAtLeast(this.$totalChunks, 1L));
                                if (this.$processedChunks.element % (long)100 != 0L) continue;
                                System.out.println((Object)("\u8fdb\u5ea6: " + pct + "% (" + this.$processedChunks.element + "/" + this.$totalChunks + ")"));
                            }
                            try {
                                cw.finalizeFile();
                            }
                            catch (Exception e) {
                                Optimizer.access$runWithReport$record(this.$onError, this.$errors, rf, "Finalize", "\u5b8c\u6210\u5199\u5165\u5931\u8d25");
                            }
                            try {
                                v8 = ew;
                                if (v8 != null) {
                                    v8.finalizeFile();
                                }
                            }
                            catch (Exception e) {
                                Intrinsics.checkNotNull(efile);
                                Optimizer.access$runWithReport$record(this.$onError, this.$errors, efile, "FinalizeEntities", "\u5b8c\u6210\u5b9e\u4f53\u5199\u5165\u5931\u8d25");
                            }
                            try {
                                v9 = pw;
                                if (v9 != null) {
                                    v9.finalizeFile();
                                }
                            }
                            catch (Exception e) {
                                Intrinsics.checkNotNull(pfile);
                                Optimizer.access$runWithReport$record(this.$onError, this.$errors, pfile, "FinalizePoi", "\u5b8c\u6210 POI \u5199\u5165\u5931\u8d25");
                            }
                        }
                    }));
                    stream = Unit.INSTANCE;
                }
                catch (Throwable stream) {
                    var41_52 = stream;
                    throw stream;
                }
                finally {
                    AutoCloseableKt.closeFinally(var40_51, var41_52);
                }
                Optimizer.runWithReport$emit(onProgress, ProgressStage.DimensionEnd, null, null, (Path)dim, null);
            }
            if (inPlace) break block64;
            if (zipOutput) {
                ts = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                v3 = out.getParent();
                if (v3 == null) {
                    v3 = Path.of(".", new String[0]);
                }
                parent = v3;
                zipPath = parent.resolve(ts + ".zip");
                try {
                    Optimizer.runWithReport$emit(onProgress, ProgressStage.Compress, null, null, out, null);
                    element$iv /* !! */  = new ZipOutputStream(Files.newOutputStream(zipPath, new OpenOption[0]));
                    dim = null;
                    try {
                        zos = (ZipOutputStream)element$iv /* !! */ ;
                        $i$a$-use-Optimizer$runWithReport$4 = false;
                        Files.walk(out, new FileVisitOption[0]).forEach((Consumer<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, runWithReport$lambda$18$lambda$17(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)V)((Function1)new Function1<Path, Unit>(out, zos){
                            final /* synthetic */ Path $out;
                            final /* synthetic */ ZipOutputStream $zos;
                            {
                                this.$out = $out;
                                this.$zos = $zos;
                                super(1);
                            }

                            public final void invoke(Path p) {
                                Path rel = this.$out.relativize(p);
                                if (((CharSequence)((Object)rel).toString()).length() == 0) {
                                    return;
                                }
                                if (Files.isDirectory(p, new LinkOption[0])) {
                                    char[] cArray = new char[]{'/'};
                                    String name = StringsKt.trimEnd(((Object)rel).toString(), cArray) + "/";
                                    this.$zos.putNextEntry(new ZipEntry(name));
                                    this.$zos.closeEntry();
                                } else {
                                    this.$zos.putNextEntry(new ZipEntry(((Object)rel).toString()));
                                    Files.copy(p, this.$zos);
                                    this.$zos.closeEntry();
                                }
                            }
                        }));
                        var32_38 = Unit.INSTANCE;
                    }
                    catch (Throwable var32_39) {
                        dim = var32_39;
                        throw var32_39;
                    }
                    finally {
                        CloseableKt.closeFinally(element$iv /* !! */ , (Throwable)dim);
                    }
                }
                catch (IOException e) {
                    msg = "\u538b\u7f29\u8f93\u51fa\u76ee\u5f55\u5931\u8d25\uff1a" + out;
                    Optimizer.runWithReport$record(onError, errors, out, "Compress", msg);
                }
                try {
                    Optimizer.runWithReport$emit(onProgress, ProgressStage.Cleanup, null, null, out, null);
                    Files.walk(out, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach((Consumer<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, runWithReport$lambda$19(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)V)((Function1)runWithReport.5.INSTANCE));
                }
                catch (IOException e) {
                    msg = "\u5220\u9664\u8f93\u51fa\u76ee\u5f55\u5931\u8d25\uff1a" + out;
                    Optimizer.runWithReport$record(onError, errors, out, "Cleanup", msg);
                }
            }
            ** GOTO lbl162
        }
        $this$forEach$iv = tasks;
        $i$f$forEach = false;
        var29_32 = $this$forEach$iv.iterator();
        block42: while (true) {
            block65: {
                if (!var29_32.hasNext()) {
                    try {
                        Files.walk(out, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach((Consumer<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, runWithReport$lambda$16(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)V)((Function1)runWithReport.3.INSTANCE));
                    }
                    catch (IOException e) {
                        throw new InPlaceReplacementException("\u6e05\u7406\u4e34\u65f6\u76ee\u5f55\u5931\u8d25\uff1a" + out, e);
                    }
                }
                break block65;
lbl162:
                // 3 sources

                Optimizer.runWithReport$emit(onProgress, ProgressStage.Done, processedChunks.element, totalChunks, input, null);
                return new OptimizeReport(processedChunks.element, removedTotal.element, errors);
            }
            element$iv /* !! */  = var29_32.next();
            dim = (Path)element$iv /* !! */ ;
            $i$a$-forEach-Optimizer$runWithReport$2 = false;
            rel = input.relativize((Path)dim);
            outDim = out.resolve(rel);
            inDim = input.resolve(rel);
            regionDir /* !! */  = new String[]{"region", "entities", "poi"};
            $this$forEach$iv = CollectionsKt.listOf(regionDir /* !! */ );
            $i$f$forEach = false;
            var38_49 = $this$forEach$iv.iterator();
            while (true) {
                if (!var38_49.hasNext()) continue block42;
                element$iv = var38_49.next();
                name = (String)element$iv;
                $i$a$-forEach-Optimizer$runWithReport$2$1 = false;
                src = outDim.resolve(name);
                if (!Files.isDirectory(src, new LinkOption[0])) continue;
                dst = inDim.resolve(name);
                try {
                    Files.createDirectories(dst, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new InPlaceReplacementException("\u65e0\u6cd5\u521b\u5efa\u76ee\u6807\u76ee\u5f55\uff1a" + dst, e);
                }
                keep = new HashSet<String>();
                var45_61 = Files.list(src);
                var46_64 = null;
                try {
                    s = (Stream)var45_61;
                    $i$a$-use-Optimizer$runWithReport$2$1$1 = false;
                    s.filter((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, runWithReport$lambda$15$lambda$14$lambda$7$lambda$5(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Z)((Function1)runWithReport.2.1.1.1.INSTANCE)).forEach((Consumer<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, runWithReport$lambda$15$lambda$14$lambda$7$lambda$6(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)V)((Function1)new Function1<Path, Unit>(keep){
                        final /* synthetic */ HashSet<String> $keep;
                        {
                            this.$keep = $keep;
                            super(1);
                        }

                        public final void invoke(Path it) {
                            this.$keep.add(((Object)it.getFileName()).toString());
                        }
                    }));
                    s = Unit.INSTANCE;
                }
                catch (Throwable s) {
                    var46_64 = s;
                    throw s;
                }
                finally {
                    AutoCloseableKt.closeFinally(var45_61, var46_64);
                }
                if (Files.isDirectory(dst, new LinkOption[0])) {
                    try {
                        var45_61 = Files.list(dst);
                        var46_64 = null;
                        try {
                            s = (Stream)var45_61;
                            $i$a$-use-Optimizer$runWithReport$2$1$2 = false;
                            s.filter((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, runWithReport$lambda$15$lambda$14$lambda$10$lambda$8(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Z)((Function1)runWithReport.2.1.2.1.INSTANCE)).forEach((Consumer<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, runWithReport$lambda$15$lambda$14$lambda$10$lambda$9(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)V)((Function1)new Function1<Path, Unit>(keep){
                                final /* synthetic */ HashSet<String> $keep;
                                {
                                    this.$keep = $keep;
                                    super(1);
                                }

                                public final void invoke(Path p) {
                                    if (!this.$keep.contains(((Object)p.getFileName()).toString())) {
                                        Files.deleteIfExists(p);
                                    }
                                }
                            }));
                            s = Unit.INSTANCE;
                        }
                        catch (Throwable s) {
                            var46_64 = s;
                            throw s;
                        }
                        finally {
                            AutoCloseableKt.closeFinally(var45_61, var46_64);
                        }
                    }
                    catch (IOException e) {
                        throw new InPlaceReplacementException("\u6e05\u7406\u76ee\u6807\u76ee\u5f55\u5931\u8d25\uff1a" + dst, e);
                    }
                }
                try {
                    e = Files.list(src);
                    var46_64 = null;
                    try {
                        s = (Stream)e;
                        $i$a$-use-Optimizer$runWithReport$2$1$3 = false;
                        s.filter((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, runWithReport$lambda$15$lambda$14$lambda$13$lambda$11(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Z)((Function1)runWithReport.2.1.3.1.INSTANCE)).forEach((Consumer<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, runWithReport$lambda$15$lambda$14$lambda$13$lambda$12(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)V)((Function1)new Function1<Path, Unit>(dst){
                            final /* synthetic */ Path $dst;
                            {
                                this.$dst = $dst;
                                super(1);
                            }

                            public final void invoke(Path p) {
                                Path target = this.$dst.resolve(((Object)p.getFileName()).toString());
                                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                                Files.copy(p, target, copyOptionArray);
                            }
                        }));
                        var47_65 = Unit.INSTANCE;
                    }
                    catch (Throwable var47_70) {
                        var46_64 = var47_70;
                        throw var47_70;
                    }
                    finally {
                        AutoCloseableKt.closeFinally(e, var46_64);
                    }
                }
                catch (IOException e) {
                    throw new InPlaceReplacementException("\u590d\u5236\u6587\u4ef6\u5230\u76ee\u6807\u76ee\u5f55\u5931\u8d25\uff1a" + dst, e);
                }
            }
            break;
        }
    }

    public static /* synthetic */ OptimizeReport runWithReport$default(Path path, Path path2, long l, boolean bl, ProgressMode progressMode, boolean bl2, boolean bl3, boolean bl4, boolean bl5, long l2, long l3, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 0x10) != 0) {
            progressMode = ProgressMode.Region;
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        if ((n & 0x40) != 0) {
            bl3 = false;
        }
        if ((n & 0x80) != 0) {
            bl4 = false;
        }
        if ((n & 0x100) != 0) {
            bl5 = false;
        }
        if ((n & 0x200) != 0) {
            l2 = 1000L;
        }
        if ((n & 0x400) != 0) {
            l3 = 0L;
        }
        if ((n & 0x800) != 0) {
            function1 = null;
        }
        if ((n & 0x1000) != 0) {
            function12 = null;
        }
        return Optimizer.runWithReport(path, path2, l, bl, progressMode, bl2, bl3, bl4, bl5, l2, l3, function1, function12);
    }

    private final boolean isDimensionDir(Path path) {
        return Files.isDirectory(path.resolve("region"), new LinkOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Path> discoverDimensions(Path root) {
        Object s2;
        List tasks = new ArrayList();
        if (this.isDimensionDir(root)) {
            tasks.add(root);
        }
        AutoCloseable autoCloseable = Files.list(root);
        Throwable throwable = null;
        try {
            s2 = (Stream)autoCloseable;
            boolean bl = false;
            s2.filter(arg_0 -> Optimizer.discoverDimensions$lambda$22$lambda$20(discoverDimensions.1.1.INSTANCE, arg_0)).forEach(arg_0 -> Optimizer.discoverDimensions$lambda$22$lambda$21(new Function1<Path, Unit>((List<Path>)tasks){
                final /* synthetic */ List<Path> $tasks;
                {
                    this.$tasks = $tasks;
                    super(1);
                }

                public final void invoke(Path it) {
                    Intrinsics.checkNotNull(it);
                    this.$tasks.add(it);
                }
            }, arg_0));
            s2 = Unit.INSTANCE;
        }
        catch (Throwable s2) {
            throwable = s2;
            throw s2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        autoCloseable = Files.walk(root, new FileVisitOption[0]);
        throwable = null;
        try {
            s2 = (Stream)autoCloseable;
            boolean bl = false;
            s2.filter(arg_0 -> Optimizer.discoverDimensions$lambda$25$lambda$23(discoverDimensions.2.1.INSTANCE, arg_0)).forEach(arg_0 -> Optimizer.discoverDimensions$lambda$25$lambda$24(new Function1<Path, Unit>((List<Path>)tasks){
                final /* synthetic */ List<Path> $tasks;
                {
                    this.$tasks = $tasks;
                    super(1);
                }

                public final void invoke(Path p) {
                    if (!this.$tasks.contains(p)) {
                        Intrinsics.checkNotNull(p);
                        this.$tasks.add(p);
                    }
                }
            }, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long countTotalChunks(List<? extends Path> dims) {
        Ref.LongRef total = new Ref.LongRef();
        for (Path path : dims) {
            Path regionDir = path.resolve("region");
            if (!Files.isDirectory(regionDir, new LinkOption[0])) continue;
            AutoCloseable autoCloseable = Files.list(regionDir);
            Throwable throwable = null;
            try {
                Stream s = (Stream)autoCloseable;
                boolean bl = false;
                s.filter(arg_0 -> Optimizer.countTotalChunks$lambda$28$lambda$26(countTotalChunks.1.1.INSTANCE, arg_0)).forEach(arg_0 -> Optimizer.countTotalChunks$lambda$28$lambda$27(new Function1<Path, Unit>(total){
                    final /* synthetic */ Ref.LongRef $total;
                    {
                        this.$total = $total;
                        super(1);
                    }

                    public final void invoke(Path p) {
                        try {
                            McaReader r = McaReader.Companion.open(((Object)p).toString());
                            this.$total.element += (long)r.entries().size();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }, arg_0));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable, throwable);
            }
        }
        return total.element;
    }

    private final boolean isValidMca(Path path) {
        boolean bl;
        try {
            bl = Files.size(path) >= 8192L;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private final List<Pair<Integer, Integer>> parseForceLoaded(Path dimension, boolean strict) {
        List<Pair<Integer, Integer>> list;
        File f = dimension.resolve("data").resolve("chunks.dat").toFile();
        if (!f.isFile()) {
            return CollectionsKt.emptyList();
        }
        try {
            Intrinsics.checkNotNull(f);
            list = NbtForceLoader.INSTANCE.parse(f);
        }
        catch (Exception e) {
            if (strict) {
                throw new ForceLoadedParseException("\u89e3\u6790\u5f3a\u5236\u52a0\u8f7d\u5217\u8868\u5931\u8d25\uff1a" + f, e);
            }
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final void runWithReport$record(Function1<? super OptimizeError, Unit> $onError, List<OptimizeError> errors, Path path, String kind, String msg) {
        OptimizeError e = new OptimizeError(((Object)path).toString(), kind, msg);
        Function1<? super OptimizeError, Unit> function1 = $onError;
        if (function1 != null) {
            function1.invoke(e);
        }
        errors.add(e);
    }

    private static final void runWithReport$emit(Function1<? super ProgressEvent, Unit> $onProgress, ProgressStage stage, Long current, Long total, Path path, String message) {
        block0: {
            Function1<? super ProgressEvent, Unit> function1 = $onProgress;
            if (function1 == null) break block0;
            Path path2 = path;
            function1.invoke(new ProgressEvent(stage, current, total, path2 != null ? ((Object)path2).toString() : null, message));
        }
    }

    static /* synthetic */ void runWithReport$emit$default(Function1 function1, ProgressStage progressStage, Long l, Long l2, Path path, String string, int n, Object object) {
        if ((n & 4) != 0) {
            l = null;
        }
        if ((n & 8) != 0) {
            l2 = null;
        }
        if ((n & 0x10) != 0) {
            path = null;
        }
        if ((n & 0x20) != 0) {
            string = null;
        }
        Optimizer.runWithReport$emit(function1, progressStage, l, l2, path, string);
    }

    private static final void runWithReport$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean runWithReport$lambda$4$lambda$3$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void runWithReport$lambda$4$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean runWithReport$lambda$15$lambda$14$lambda$7$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void runWithReport$lambda$15$lambda$14$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean runWithReport$lambda$15$lambda$14$lambda$10$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void runWithReport$lambda$15$lambda$14$lambda$10$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean runWithReport$lambda$15$lambda$14$lambda$13$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void runWithReport$lambda$15$lambda$14$lambda$13$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void runWithReport$lambda$16(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void runWithReport$lambda$18$lambda$17(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void runWithReport$lambda$19(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean discoverDimensions$lambda$22$lambda$20(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void discoverDimensions$lambda$22$lambda$21(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean discoverDimensions$lambda$25$lambda$23(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void discoverDimensions$lambda$25$lambda$24(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean countTotalChunks$lambda$28$lambda$26(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void countTotalChunks$lambda$28$lambda$27(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$runWithReport$emit(Function1 $onProgress, ProgressStage stage, Long current, Long total, Path path, String message) {
        Optimizer.runWithReport$emit($onProgress, stage, current, total, path, message);
    }

    public static final /* synthetic */ boolean access$isValidMca(Optimizer $this, Path path) {
        return $this.isValidMca(path);
    }

    public static final /* synthetic */ void access$runWithReport$record(Function1 $onError, List errors, Path path, String kind, String msg) {
        Optimizer.runWithReport$record($onError, errors, path, kind, msg);
    }

    public static final /* synthetic */ boolean access$isDimensionDir(Optimizer $this, Path path) {
        return $this.isDimensionDir(path);
    }
}

