/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.orzmc.mca;

import com.jokerhub.orzmc.mca.McaEntry;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jokerhub/orzmc/mca/McaWriter;", "", "path", "", "(Ljava/lang/String;)V", "dataOffset", "", "file", "Ljava/io/RandomAccessFile;", "offsets", "", "sizes", "timestamps", "finalizeFile", "", "writeEntry", "entry", "Lcom/jokerhub/orzmc/mca/McaEntry;", "core"})
public final class McaWriter {
    @NotNull
    private final RandomAccessFile file;
    private long dataOffset;
    @NotNull
    private final int[] offsets;
    @NotNull
    private final int[] sizes;
    @NotNull
    private final int[] timestamps;

    public McaWriter(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        this.file = new RandomAccessFile(new File(path), "rw");
        this.dataOffset = 8192L;
        this.offsets = new int[1024];
        this.sizes = new int[1024];
        this.timestamps = new int[1024];
        this.file.setLength(0L);
        this.file.write(new byte[8192]);
    }

    public final void writeEntry(@NotNull McaEntry entry) {
        Intrinsics.checkNotNullParameter(entry, "entry");
        byte[] serialized = entry.serializedBytes();
        long start = this.dataOffset;
        this.file.seek(start);
        this.file.write(serialized);
        long written = serialized.length;
        long pad = ((long)4096 - written % (long)4096) % (long)4096;
        if (pad > 0L) {
            this.file.write(new byte[(int)pad]);
        }
        this.dataOffset += written + pad;
        int idx = entry.regionIndex();
        this.offsets[idx] = (int)start;
        this.sizes[idx] = (int)(written + pad);
        this.timestamps[idx] = entry.modifiedTime();
    }

    public final void finalizeFile() {
        byte[] loc = new byte[4096];
        ByteBuffer bbLoc = ByteBuffer.wrap(loc).order(ByteOrder.BIG_ENDIAN);
        for (int i = 0; i < 1024; ++i) {
            int offSectors = this.offsets[i] / 4096;
            int sizeSectors = this.sizes[i] / 4096;
            int v = offSectors << 8 | sizeSectors & 0xFF;
            bbLoc.putInt(v);
        }
        byte[] time = new byte[4096];
        ByteBuffer bbTime = ByteBuffer.wrap(time).order(ByteOrder.BIG_ENDIAN);
        for (int i = 0; i < 1024; ++i) {
            bbTime.putInt(this.timestamps[i]);
        }
        this.file.seek(0L);
        this.file.write(loc);
        this.file.write(time);
        this.file.getFD().sync();
    }
}

