/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.orzmc.mca;

import com.jokerhub.orzmc.mca.McaEntry;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u0007J\b\u0010\u0018\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/jokerhub/orzmc/mca/McaReader;", "", "file", "Ljava/io/RandomAccessFile;", "path", "", "xPos", "", "zPos", "(Ljava/io/RandomAccessFile;Ljava/lang/String;II)V", "offsets", "", "sizes", "timestamps", "getXPos", "()I", "getZPos", "ensure", "", "entries", "", "Lcom/jokerhub/orzmc/mca/McaEntry;", "get", "index", "readHeader", "Companion", "core"})
public final class McaReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RandomAccessFile file;
    @NotNull
    private final String path;
    private final int xPos;
    private final int zPos;
    @Nullable
    private int[] offsets;
    @Nullable
    private int[] sizes;
    @Nullable
    private int[] timestamps;
    private static final Pattern FILENAME_RE = Pattern.compile("r\\.(-?\\d+)\\.(-?\\d+)\\.mca$");

    public McaReader(@NotNull RandomAccessFile file, @NotNull String path, int xPos, int zPos) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(path, "path");
        this.file = file;
        this.path = path;
        this.xPos = xPos;
        this.zPos = zPos;
    }

    public final int getXPos() {
        return this.xPos;
    }

    public final int getZPos() {
        return this.zPos;
    }

    private final void readHeader() {
        this.file.seek(0L);
        byte[] loc = new byte[4096];
        this.file.readFully(loc);
        byte[] time = new byte[4096];
        this.file.readFully(time);
        int[] offs = new int[1024];
        int[] sizesArr = new int[1024];
        for (int i = 0; i < 1024; ++i) {
            int base = i * 4;
            int v = ByteBuffer.wrap(loc, base, 4).order(ByteOrder.BIG_ENDIAN).getInt();
            int off = (v >>> 8) * 4096;
            int size = (v & 0xFF) * 4096;
            offs[i] = off;
            sizesArr[i] = size;
        }
        int[] ts = new int[1024];
        for (int i = 0; i < 1024; ++i) {
            int base = i * 4;
            ts[i] = ByteBuffer.wrap(time, base, 4).order(ByteOrder.BIG_ENDIAN).getInt();
        }
        this.offsets = offs;
        this.sizes = sizesArr;
        this.timestamps = ts;
    }

    private final void ensure() {
        if (this.offsets == null) {
            this.readHeader();
        }
    }

    @NotNull
    public final List<McaEntry> entries() {
        this.ensure();
        Intrinsics.checkNotNull(this.offsets);
        int[] offs = this.offsets;
        Intrinsics.checkNotNull(this.sizes);
        int[] sizesArr = this.sizes;
        Intrinsics.checkNotNull(this.timestamps);
        int[] ts = this.timestamps;
        ArrayList<McaEntry> out2 = new ArrayList<McaEntry>();
        for (int i = 0; i < 1024; ++i) {
            int off = offs[i];
            int size = sizesArr[i];
            int t = ts[i];
            if (off == 0 || size == 0) continue;
            out2.add(new McaEntry(new RandomAccessFile(new File(this.path), "r"), off, size, i, t, this.xPos, this.zPos));
        }
        return out2;
    }

    @Nullable
    public final McaEntry get(int index) {
        this.ensure();
        Intrinsics.checkNotNull(this.offsets);
        int off = this.offsets[index];
        Intrinsics.checkNotNull(this.sizes);
        int size = this.sizes[index];
        Intrinsics.checkNotNull(this.timestamps);
        int ts = this.timestamps[index];
        if (off == 0 || size == 0) {
            return null;
        }
        return new McaEntry(new RandomAccessFile(new File(this.path), "r"), off, size, index, ts, this.xPos, this.zPos);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jokerhub/orzmc/mca/McaReader$Companion;", "", "()V", "FILENAME_RE", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "open", "Lcom/jokerhub/orzmc/mca/McaReader;", "path", "", "core"})
    @SourceDebugExtension(value={"SMAP\nMcaReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McaReader.kt\ncom/jokerhub/orzmc/mca/McaReader$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final McaReader open(@NotNull String path) {
            Intrinsics.checkNotNullParameter(path, "path");
            Matcher m = FILENAME_RE.matcher(path);
            if (!m.find()) {
                boolean $i$a$-require-McaReader$Companion$open$22 = false;
                String $i$a$-require-McaReader$Companion$open$22 = "invalid mca filename: " + path;
                throw new IllegalArgumentException($i$a$-require-McaReader$Companion$open$22.toString());
            }
            String string = m.group(1);
            Intrinsics.checkNotNullExpressionValue(string, "group(...)");
            int x = Integer.parseInt(string);
            String string2 = m.group(2);
            Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
            int z = Integer.parseInt(string2);
            RandomAccessFile raf = new RandomAccessFile(new File(path), "r");
            return new McaReader(raf, path, x, z);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

