/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.commands;

import com.jokerhub.paper.plugin.orzmc.OrzMC;
import com.jokerhub.paper.plugin.orzmc.utils.OrzUtil;
import com.jokerhub.paper.plugin.orzmc.utils.guidebook.GuideBookConfigParser;
import com.jokerhub.paper.plugin.orzmc.utils.guidebook.models.ContentItem;
import com.jokerhub.paper.plugin.orzmc.utils.guidebook.models.GuideBookConfig;
import com.jokerhub.paper.plugin.orzmc.utils.guidebook.models.LinkContent;
import com.jokerhub.paper.plugin.orzmc.utils.guidebook.models.TextContent;
import com.jokerhub.paper.plugin.orzmc.utils.guidebook.models.TextStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OrzGuideBook
implements CommandExecutor {
    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, String @NotNull [] strings) {
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            this.openNewPlayerGuideBook(player);
        }
        return false;
    }

    @Nullable
    private static ItemStack guideBook() {
        GuideBookConfigParser guideBookConfigParser = new GuideBookConfigParser(OrzMC.plugin());
        GuideBookConfig guideBookConfig = guideBookConfigParser.parseConfig();
        if (guideBookConfig == null || !guideBookConfig.enable()) {
            return null;
        }
        ItemStack guideBook = new ItemStack(Material.WRITTEN_BOOK);
        BookMeta bookMeta = (BookMeta)guideBook.getItemMeta();
        bookMeta.setTitle(guideBookConfig.title());
        bookMeta.setAuthor(guideBookConfig.author());
        bookMeta.setGeneration(BookMeta.Generation.COPY_OF_COPY);
        ArrayList<TextComponent> bookPageComponents = new ArrayList<TextComponent>();
        TextComponent.Builder guideBookPageBuilder = Component.text();
        for (ContentItem item : guideBookConfig.content()) {
            TextComponent.Builder textComponentBuilder = Component.text();
            if (item.isText()) {
                TextContent textItem = item.getText();
                if (textItem.content().isEmpty()) continue;
                textComponentBuilder.append((Component)Component.text((String)textItem.content()));
            } else if (item.isLink()) {
                LinkContent linkItem = item.getLink();
                TextComponent.Builder linkTextBuilder = Component.text();
                if (linkItem.content().isEmpty()) continue;
                linkTextBuilder.append((Component)Component.text((String)linkItem.content()));
                if (!linkItem.url().isEmpty()) {
                    Style defaultLinkStyle = Style.style().color(TextColor.fromCSSHexString((String)"#5555FF")).build();
                    linkTextBuilder.style(defaultLinkStyle);
                    linkTextBuilder.clickEvent(ClickEvent.openUrl((String)linkItem.url()));
                    linkTextBuilder.hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)linkItem.hoverText())));
                }
                textComponentBuilder.append((Component)linkTextBuilder.build());
            }
            if (item.getStyle() != null) {
                TextStyle style = item.getStyle();
                if (style.getBold().booleanValue()) {
                    textComponentBuilder.decorate(TextDecoration.BOLD);
                }
                if (style.getUnderlined().booleanValue()) {
                    textComponentBuilder.decorate(TextDecoration.UNDERLINED);
                }
                if (!style.getColor().isEmpty()) {
                    TextColor textColor = TextColor.fromCSSHexString((String)style.getColor());
                    textComponentBuilder.color(textColor);
                }
            }
            Collections.nCopies(item.getNewlineCount(), Component.newline()).forEach(arg_0 -> ((TextComponent.Builder)textComponentBuilder).append(arg_0));
            TextComponent textComponent = (TextComponent)textComponentBuilder.build();
            guideBookPageBuilder.append((Component)textComponent);
            if (!item.getPageBreak()) continue;
            TextComponent pageContent = (TextComponent)guideBookPageBuilder.build();
            bookPageComponents.add(pageContent);
            guideBookPageBuilder = Component.text();
        }
        TextComponent lastPageContent = (TextComponent)guideBookPageBuilder.build();
        if (!lastPageContent.children().isEmpty()) {
            bookPageComponents.add(lastPageContent);
        }
        bookMeta.addPages((Component[])bookPageComponents.toArray(new TextComponent[0]));
        guideBook.setItemMeta((ItemMeta)bookMeta);
        return guideBook;
    }

    private void openNewPlayerGuideBook(Player player) {
        ItemStack guideBook = OrzGuideBook.guideBook();
        if (guideBook == null) {
            player.sendMessage((Component)OrzUtil.failureText("\u670d\u4e3b\u672a\u914d\u7f6e\u65b0\u624b\u6307\u5357"));
            return;
        }
        player.openBook(guideBook);
    }

    public static void giveNewPlayerAGuideBook(Player player) {
        ItemStack guideBook;
        UUID playerUUID = player.getPlayerProfile().getId();
        if (playerUUID == null) {
            return;
        }
        OfflinePlayer offlinePlayer = OrzMC.server().getOfflinePlayer(playerUUID);
        if (!offlinePlayer.hasPlayedBefore() && (guideBook = OrzGuideBook.guideBook()) != null) {
            player.getInventory().addItem(new ItemStack[]{guideBook});
            player.sendMessage((Component)OrzUtil.successText("\u83b7\u5f97\u65b0\u624b\u6307\u5357"));
        }
    }
}

