/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.utils.config;

import com.jokerhub.paper.plugin.orzmc.utils.config.ConfigManager;
import com.jokerhub.paper.plugin.orzmc.utils.config.ConfigWrapper;
import java.util.function.Consumer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class AdvancedConfigManager
extends ConfigManager {
    private final JavaPlugin plugin;

    public AdvancedConfigManager(JavaPlugin plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    public ConfigWrapper getWrapper(String configName) {
        return new ConfigWrapper(this.getConfig(configName));
    }

    public ConfigWrapper getWrapper(String configName, String pathPrefix) {
        return new ConfigWrapper(this.getConfig(configName), pathPrefix);
    }

    public <T> T getOrSetDefault(String configName, String path, T defaultValue) {
        FileConfiguration config = this.getConfig(configName);
        if (!config.contains(path)) {
            config.set(path, defaultValue);
            this.saveConfig(configName);
            this.plugin.getLogger().info("\u4e3a\u914d\u7f6e " + configName + " \u8bbe\u7f6e\u9ed8\u8ba4\u503c: " + path + " = " + String.valueOf(defaultValue));
        }
        return (T)config.get(path);
    }

    public void setDefaults(String configName, Consumer<FileConfiguration> defaultsSetter) {
        FileConfiguration config = this.getConfig(configName);
        defaultsSetter.accept(config);
        this.saveConfig(configName);
    }

    public boolean checkAndUpdateConfigVersion(String configName, double currentVersion) {
        ConfigWrapper wrapper = this.getWrapper(configName);
        double configVersion = wrapper.getDouble("config-version", 0.0);
        if (configVersion < currentVersion) {
            this.plugin.getLogger().warning("\u914d\u7f6e\u6587\u4ef6 " + configName + " \u7248\u672c\u8fc7\u65e7 (" + configVersion + " < " + currentVersion + ")\uff0c\u5efa\u8bae\u66f4\u65b0\uff01");
            return false;
        }
        return true;
    }
}

