/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.utils;

import com.jokerhub.paper.plugin.orzmc.OrzMC;
import com.jokerhub.paper.plugin.orzmc.utils.OrzUserCmd;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class OrzMessageParser {
    public static void parse(String message, Boolean isAdmin, Consumer<String> callback) {
        if (!OrzUserCmd.isValidCmd(message)) {
            return;
        }
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList(message.split("[, ]+")));
        String cmdString = cmd.removeFirst();
        HashSet<String> userNameSet = new HashSet<String>(cmd);
        if (cmdString.equals(OrzUserCmd.SHOW_PLAYERS.getCmdString())) {
            OrzMessageParser.onlinePlayersInfo(callback);
        } else if (cmdString.equals(OrzUserCmd.SHOW_WHITELIST.getCmdString())) {
            OrzMessageParser.whiteListInfo(callback);
        } else if (cmdString.equals(OrzUserCmd.SHOW_HELP.getCmdString())) {
            callback.accept(OrzUserCmd.helpInfo());
        } else if (cmdString.equals(OrzUserCmd.ADD_PLAYER_TO_WHITELIST.getCmdString())) {
            OrzMessageParser.addWhiteListInfo(isAdmin, userNameSet, callback);
        } else if (cmdString.equals(OrzUserCmd.REMOVE_PLAYER_FROM_WHITELIST.getCmdString())) {
            OrzMessageParser.removeWhiteListInfo(isAdmin, userNameSet, callback);
        } else {
            callback.accept(OrzUserCmd.helpInfo());
        }
    }

    public static String playerDisplayName(Player player) {
        Object ret = player.getPlayerProfile().getName();
        if (player.isOp()) {
            ret = (String)ret + "(op)";
        }
        String gameMode = "";
        switch (player.getGameMode()) {
            case CREATIVE: {
                gameMode = "\u521b\u9020";
                break;
            }
            case SURVIVAL: {
                gameMode = "\u751f\u5b58";
                break;
            }
            case ADVENTURE: {
                gameMode = "\u5192\u9669";
                break;
            }
            case SPECTATOR: {
                gameMode = "\u89c2\u5bdf";
                break;
            }
        }
        ret = (String)ret + " " + gameMode + "\u6a21\u5f0f";
        return ret;
    }

    private static void onlinePlayersInfo(Consumer<String> callback) {
        OrzMC.server().getScheduler().runTaskAsynchronously((Plugin)OrzMC.plugin(), () -> {
            Object[] objects;
            ArrayList<Player> onlinePlayers = new ArrayList<Player>();
            for (Object obj : objects = OrzMC.server().getOnlinePlayers().toArray()) {
                if (!(obj instanceof Player)) continue;
                Player p = (Player)obj;
                onlinePlayers.add(p);
            }
            String tip = String.format("------\u5f53\u524d\u5728\u7ebf(%d/%d)------", onlinePlayers.size(), OrzMC.server().getMaxPlayers());
            StringBuilder msgBuilder = new StringBuilder(tip);
            for (Player p : onlinePlayers) {
                String name = OrzMessageParser.playerDisplayName(p);
                msgBuilder.append("\n").append(name);
            }
            String ret = msgBuilder.toString();
            callback.accept(ret);
        });
    }

    private static void whiteListInfo(Consumer<String> callback) {
        OrzMC.server().getScheduler().runTaskAsynchronously((Plugin)OrzMC.plugin(), () -> {
            ArrayList<OfflinePlayer> whiteListPlayers = OrzMessageParser.allWhiteListPlayer();
            StringBuilder whiteListInfo = new StringBuilder(String.format("------\u5f53\u524d\u767d\u540d\u5355\u73a9\u5bb6(%d)------", whiteListPlayers.size()));
            for (OfflinePlayer player : whiteListPlayers) {
                String playerName = player.getName();
                String isOnline = player.isOnline() ? "\u2022" : "\u25e6";
                whiteListInfo.append("\n").append(isOnline).append(" ").append(playerName);
                long lastSeenTimestamp = player.getLastSeen();
                if (lastSeenTimestamp <= 0L) continue;
                String lastSeen = new SimpleDateFormat("yyyy/MM/dd HH:mm").format(new Date(lastSeenTimestamp));
                whiteListInfo.append(" ").append(String.format("%s", lastSeen));
            }
            String ret = whiteListInfo.toString();
            callback.accept(ret);
        });
    }

    private static void addWhiteListInfo(boolean isAdmin, Set<String> userNames, Consumer<String> callback) {
        if (!isAdmin) {
            callback.accept(OrzUserCmd.ADD_PLAYER_TO_WHITELIST.adminPermissionRequiredTip());
            return;
        }
        if (userNames.isEmpty()) {
            callback.accept(OrzUserCmd.ADD_PLAYER_TO_WHITELIST.usageTip());
            return;
        }
        OrzMC.server().getScheduler().runTask((Plugin)OrzMC.plugin(), () -> {
            for (String userName : userNames) {
                OfflinePlayer player = OrzMC.server().getOfflinePlayer(userName);
                if (player.isWhitelisted()) continue;
                player.setWhitelisted(true);
            }
            OrzMC.server().getScheduler().runTaskAsynchronously((Plugin)OrzMC.plugin(), () -> {
                OrzMC.server().reloadWhitelist();
                Set<String> allWhiteListName = OrzMessageParser.allWhiteListPlayerName();
                Object message = "------\u767d\u540d\u5355\u6dfb\u52a0------\n";
                if (allWhiteListName.containsAll(userNames)) {
                    message = (String)message + String.join((CharSequence)"\n", userNames.stream().map(name -> "\u2714\ufe0e \ufe0e" + name).collect(Collectors.toSet()));
                }
                userNames.removeAll(allWhiteListName);
                if (!userNames.isEmpty()) {
                    message = (String)message + String.join((CharSequence)"\n", userNames.stream().map(name -> "\u2718 " + name).collect(Collectors.toSet()));
                }
                callback.accept((String)message);
            });
        });
    }

    private static void removeWhiteListInfo(boolean isAdmin, Set<String> userNames, Consumer<String> callback) {
        if (!isAdmin) {
            callback.accept(OrzUserCmd.REMOVE_PLAYER_FROM_WHITELIST.adminPermissionRequiredTip());
            return;
        }
        if (userNames.isEmpty()) {
            callback.accept(OrzUserCmd.REMOVE_PLAYER_FROM_WHITELIST.usageTip());
            return;
        }
        OrzMC.server().getScheduler().runTask((Plugin)OrzMC.plugin(), () -> {
            for (String userName : userNames) {
                OfflinePlayer player = OrzMC.server().getOfflinePlayer(userName);
                if (!player.isWhitelisted()) continue;
                player.setWhitelisted(false);
                Player onlinePlayer = OrzMC.server().getPlayer(player.getUniqueId());
                if (onlinePlayer == null) continue;
                onlinePlayer.kick();
            }
            OrzMC.server().getScheduler().runTaskAsynchronously((Plugin)OrzMC.plugin(), () -> {
                OrzMC.server().reloadWhitelist();
                Set<String> allWhiteListName = OrzMessageParser.allWhiteListPlayerName();
                Object message = "------\u767d\u540d\u5355\u79fb\u9664------\n";
                if (!allWhiteListName.containsAll(userNames)) {
                    message = (String)message + String.join((CharSequence)"\n", userNames.stream().map(name -> "\u2714\ufe0e " + name).collect(Collectors.toSet()));
                }
                userNames.retainAll(allWhiteListName);
                if (!userNames.isEmpty()) {
                    message = (String)message + String.join((CharSequence)"\n", userNames.stream().map(name -> "\u2718 " + name).collect(Collectors.toSet()));
                }
                callback.accept((String)message);
            });
        });
    }

    private static ArrayList<OfflinePlayer> allWhiteListPlayer() {
        ArrayList<OfflinePlayer> whiteListPlayers = new ArrayList<OfflinePlayer>(OrzMC.server().getWhitelistedPlayers());
        whiteListPlayers.sort((o1, o2) -> Long.compare(o2.getLastSeen(), o1.getLastSeen()));
        return whiteListPlayers;
    }

    private static Set<String> allWhiteListPlayerName() {
        return OrzMessageParser.allWhiteListPlayer().stream().map(OfflinePlayer::getName).collect(Collectors.toSet());
    }
}

