/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.events;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jokerhub.paper.plugin.orzmc.OrzMC;
import com.jokerhub.paper.plugin.orzmc.commands.OrzGuideBook;
import com.jokerhub.paper.plugin.orzmc.events.OrzBaseListener;
import com.jokerhub.paper.plugin.orzmc.utils.OrzMessageParser;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class OrzPlayerEvent
extends OrzBaseListener {
    public OrzPlayerEvent(OrzMC plugin) {
        super(plugin);
    }

    private static JsonObject parseToJsonObject(String json) {
        return JsonParser.parseString((String)json).getAsJsonObject();
    }

    private static String toPrettyFormat(JsonObject jsonObject) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((JsonElement)jsonObject);
    }

    private List<String> allowCountryList() {
        return this.plugin.configManager.getConfig("config").getStringList("allow_country_code");
    }

    @EventHandler
    public void onPlayerPreLogin(AsyncPlayerPreLoginEvent event) {
        List<String> allowCountList = this.allowCountryList();
        if (allowCountList.isEmpty() && event.getLoginResult().equals((Object)AsyncPlayerPreLoginEvent.Result.ALLOWED)) {
            return;
        }
        String ipAddress = event.getAddress().getHostAddress();
        String playerName = event.getPlayerProfile().getName();
        if (!ipAddress.isEmpty()) {
            try (HttpClient client = HttpClient.newHttpClient();){
                String url = "https://get.geojs.io/v1/ip/geo/" + ipAddress + ".json";
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).build();
                ((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAcceptAsync(response -> {
                    OrzMC.debugInfo("Response Code : " + response.toString());
                    if (response.statusCode() == 200) {
                        String result = (String)response.body();
                        JsonObject jsonObject = OrzPlayerEvent.parseToJsonObject(result);
                        String addressInfo = OrzPlayerEvent.toPrettyFormat(jsonObject);
                        if (jsonObject.has("country_code")) {
                            String countryCode = String.valueOf(jsonObject.get("country_code").getAsString());
                            if (!allowCountList.contains(countryCode)) {
                                String msg = playerName + "(" + ipAddress + ")\n" + countryCode + "\nIP\u4f4d\u7f6e\u4e0d\u5728\u670d\u52a1\u652f\u6301\u533a\u57df" + String.join((CharSequence)",", allowCountList);
                                this.plugin.sendPublicMessage(msg + "\n" + addressInfo);
                                event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, (Component)Component.text((String)msg));
                            } else {
                                OrzMC.debugInfo("allowCountList contains: " + countryCode);
                            }
                        } else {
                            OrzMC.debugInfo("ip info has no field: country_code");
                        }
                    }
                })).exceptionally(e -> {
                    String msg = "IP\u5730\u5740\u89e3\u6790\u670d\u52a1\u5f02\u5e38: " + e.toString();
                    OrzMC.logger().warning(msg);
                    this.plugin.sendPublicMessage(msg);
                    return null;
                });
            }
            catch (Exception e2) {
                String msg = e2.toString();
                this.plugin.getLogger().severe(msg);
                this.plugin.sendPublicMessage(msg);
            }
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        OrzGuideBook.giveNewPlayerAGuideBook(event.getPlayer());
        this.notifyPlayerChatGroupWithMsg(event.getPlayer(), PlayerState.JOIN);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.notifyPlayerChatGroupWithMsg(event.getPlayer(), PlayerState.QUIT);
    }

    @EventHandler
    public void onPlayerKickLeave(PlayerKickEvent event) {
        this.notifyPlayerChatGroupWithMsg(event.getPlayer(), PlayerState.KICK);
    }

    private void notifyPlayerChatGroupWithMsg(Player player, PlayerState state) {
        Object[] objects;
        ArrayList<Player> onlinePlayers = new ArrayList<Player>();
        for (Object obj : objects = OrzMC.server().getOnlinePlayers().toArray()) {
            if (!(obj instanceof Player)) continue;
            Player p = (Player)obj;
            onlinePlayers.add(p);
        }
        int onlinePlayerCount = onlinePlayers.size();
        int maxPlayerCount = OrzMC.server().getMaxPlayers();
        String playerName = OrzMessageParser.playerDisplayName(player);
        StringBuilder msgBuilder = new StringBuilder(playerName).append(" ");
        boolean isMinusCurrentPlayer = false;
        switch (state.ordinal()) {
            case 0: {
                msgBuilder.append("\u4e0a\u7ebf");
                break;
            }
            case 1: {
                isMinusCurrentPlayer = true;
                msgBuilder.append("\u4e0b\u7ebf");
                break;
            }
            case 2: {
                isMinusCurrentPlayer = true;
                msgBuilder.append("\u88ab\u8e22");
                break;
            }
        }
        if (isMinusCurrentPlayer) {
            --onlinePlayerCount;
        }
        msgBuilder.append("\n");
        String tip = String.format("------\u5f53\u524d\u5728\u7ebf(%d/%d)------", onlinePlayerCount, maxPlayerCount);
        msgBuilder.append(tip);
        for (Player p : onlinePlayers) {
            if (p.getUniqueId() == player.getUniqueId() && isMinusCurrentPlayer) continue;
            String name = OrzMessageParser.playerDisplayName(p);
            msgBuilder.append("\n").append(name);
        }
        this.plugin.sendPublicMessage(msgBuilder.toString());
        this.plugin.getLogger().info(msgBuilder.toString());
        if (onlinePlayerCount == 0) {
            this.plugin.sendPrivateMessage("\u670d\u52a1\u5668\u5f53\u524d\u65e0\u73a9\u5bb6\uff0c\u53ef\u8fdb\u884c\u670d\u52a1\u5668\u7ef4\u62a4");
        }
    }

    static enum PlayerState {
        JOIN,
        QUIT,
        KICK;

    }
}

