/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.utils.bot;

import com.jokerhub.paper.plugin.orzmc.OrzMC;
import com.jokerhub.paper.plugin.orzmc.utils.OrzMessageParser;
import com.jokerhub.paper.plugin.orzmc.utils.bot.OrzBaseBot;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.entities.channel.unions.MessageChannelUnion;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.events.session.ReadyEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.dv8tion.jda.api.utils.SplitUtil;
import org.jetbrains.annotations.NotNull;

public class OrzDiscordBot
extends OrzBaseBot {
    private final ArrayList<String> toBeSendMessageWhenApiReady = new ArrayList();
    private final String codeBlockPrefix = "```\n";
    private final String codeBlockSuffix = "```";
    private JDA api;
    private boolean isApiReady;

    public OrzDiscordBot(OrzMC plugin) {
        super(plugin);
    }

    private List<String> codeBlockSplitMessage(String rawMessage) {
        int discordTextLengthLimit = 2000;
        return SplitUtil.split(rawMessage, discordTextLengthLimit - "```\n".length() - "```".length(), true, SplitUtil.Strategy.NEWLINE, SplitUtil.Strategy.ANYWHERE).stream().map(part -> "```\n" + part + "```").collect(Collectors.toList());
    }

    @Override
    public boolean isEnable() {
        return this.botConfig.getBoolean("enable_discord_bot");
    }

    @Override
    public void setup() {
        if (!this.isEnable()) {
            OrzMC.debugInfo("Discord Bot Disabled!");
            return;
        }
        String minecraftVersion = OrzMC.server().getMinecraftVersion();
        String serverInfo = "Minecraft(" + minecraftVersion + ")";
        String botTokenBase64Encoded = this.botConfig.getString("discord_bot_token_base64_encoded");
        String botToken = new String(Base64.getDecoder().decode(botTokenBase64Encoded));
        this.api = JDABuilder.createLight(botToken, GatewayIntent.GUILD_MESSAGES, GatewayIntent.MESSAGE_CONTENT, GatewayIntent.GUILD_MEMBERS).addEventListeners(new ListenerAdapter(){

            @Override
            public void onReady(@NotNull ReadyEvent event) {
                super.onReady(event);
                OrzDiscordBot.this.isApiReady = true;
                OrzDiscordBot.this.toBeSendMessageWhenApiReady.forEach(message -> OrzDiscordBot.this.sendMessage((String)message));
                OrzDiscordBot.this.toBeSendMessageWhenApiReady.clear();
            }

            @Override
            public void onMessageReceived(@NotNull MessageReceivedEvent event) {
                super.onMessageReceived(event);
                if (event.getAuthor().isBot()) {
                    return;
                }
                Member member = event.getMember();
                if (member == null) {
                    return;
                }
                boolean isAdmin = member.hasPermission(Permission.MANAGE_SERVER) || member.hasPermission(Permission.ADMINISTRATOR) || member.hasPermission(Permission.MANAGE_CHANNEL);
                String content = event.getMessage().getContentRaw();
                OrzMessageParser.parse(content, isAdmin, info -> {
                    if (info != null) {
                        MessageChannelUnion channel = event.getChannel();
                        OrzDiscordBot.this.codeBlockSplitMessage((String)info).forEach(part -> channel.sendMessage((CharSequence)part).queue());
                    }
                });
            }
        }).setActivity(Activity.playing(serverInfo)).build();
    }

    @Override
    public void teardown() {
        if (this.isEnable()) {
            this.api.shutdown();
        }
    }

    @Override
    public void sendMessage(String message) {
        if (!this.isEnable()) {
            OrzMC.debugInfo("Discord Bot Disabled!");
            return;
        }
        if (!this.isApiReady) {
            this.toBeSendMessageWhenApiReady.add(message);
            return;
        }
        String playerTextChannelId = this.botConfig.getString("discord_player_text_channel_id");
        TextChannel channel = playerTextChannelId != null ? this.api.getTextChannelById(playerTextChannelId) : null;
        if (channel != null) {
            this.codeBlockSplitMessage(message).forEach(part -> channel.sendMessage((CharSequence)part).queue());
        } else {
            OrzMC.logger().warning("your discord bot not in this text channel: " + playerTextChannelId);
        }
    }

    @Override
    public void sendPrivateMessage(String message) {
    }
}

