/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.utils.bot;

import com.jokerhub.paper.plugin.orzmc.OrzMC;
import com.jokerhub.paper.plugin.orzmc.utils.bot.OrzBaseBot;
import com.jokerhub.paper.plugin.orzmc.utils.bot.OrzDiscordBot;
import com.jokerhub.paper.plugin.orzmc.utils.bot.OrzLarkBot;
import com.jokerhub.paper.plugin.orzmc.utils.bot.OrzQQBot;
import java.util.Map;

public class OrzBotManager {
    private final OrzMC plugin;
    private Map<String, OrzBaseBot> bots;

    public OrzBotManager(OrzMC plugin) {
        this.plugin = plugin;
    }

    public void setup() {
        this.bots = Map.of("qq", new OrzQQBot(this.plugin), "discord", new OrzDiscordBot(this.plugin), "lark", new OrzLarkBot(this.plugin));
        this.bots.values().forEach(OrzBaseBot::setup);
    }

    public void sendMessage(String message, boolean isPrivate) {
        this.bots.values().forEach(bot -> {
            if (isPrivate) {
                bot.sendPrivateMessage(message);
            } else {
                bot.sendMessage(message);
            }
        });
    }

    public void tearDown() {
        this.bots.values().forEach(OrzBaseBot::teardown);
    }
}

