/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.utils.bot;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jokerhub.paper.plugin.orzmc.OrzMC;
import com.jokerhub.paper.plugin.orzmc.utils.OrzMessageParser;
import com.jokerhub.paper.plugin.orzmc.utils.RobustWebSocketClient;
import com.jokerhub.paper.plugin.orzmc.utils.bot.OrzBaseBot;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class OrzQQBot
extends OrzBaseBot {
    private RobustWebSocketClient webSocketClient;

    public OrzQQBot(OrzMC plugin) {
        super(plugin);
    }

    @Override
    public boolean isEnable() {
        return this.botConfig.getBoolean("enable_qq_bot");
    }

    @Override
    public void setup() {
        this.setupWebSocketClient();
    }

    @Override
    public void teardown() {
        this.shutdownWebSocketClient();
    }

    @Override
    public void sendMessage(String message) {
        if (!this.isEnable()) {
            return;
        }
        try {
            String groupId = this.botConfig.getString("qq_group_id");
            String url = this.botConfig.getString("qq_bot_api_server") + "/send_group_msg?group_id=" + groupId + "&message=" + URLEncoder.encode(message, StandardCharsets.UTF_8);
            this.asyncHttpRequest(url);
        }
        catch (Exception e) {
            OrzMC.logger().info(e.toString());
        }
    }

    @Override
    public void sendPrivateMessage(String message) {
        if (!this.isEnable()) {
            return;
        }
        try {
            String userId = this.botConfig.getString("qq_admin_id");
            String url = this.botConfig.getString("qq_bot_api_server") + "/send_msg?user_id=" + userId + "&message=" + URLEncoder.encode(message, StandardCharsets.UTF_8);
            this.asyncHttpRequest(url);
        }
        catch (Exception e) {
            OrzMC.logger().info(e.toString());
        }
    }

    public void processJsonStringPayload(String jsonString) {
        if (jsonString == null || jsonString.isEmpty()) {
            return;
        }
        try {
            JsonObject json = JsonParser.parseString((String)jsonString).getAsJsonObject();
            if (json.get("group_id") == null || json.get("raw_message") == null) {
                return;
            }
            String groupId = json.get("group_id").getAsString();
            String message = json.get("raw_message").getAsString().trim();
            String senderRole = json.get("sender").getAsJsonObject().get("role").getAsString();
            boolean isOwner = senderRole.equals("owner");
            boolean isAdmin = senderRole.equals("admin");
            String qqGroupId = this.botConfig.getString("qq_group_id");
            if (groupId.equals(qqGroupId)) {
                OrzMessageParser.parse(message, isAdmin || isOwner, info -> {
                    if (info != null) {
                        this.sendMessage((String)info);
                    }
                });
            }
        }
        catch (Exception e) {
            OrzMC.logger().info(e.toString());
        }
    }

    private void asyncHttpRequest(String url) {
        try (HttpClient client = HttpClient.newHttpClient();){
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder();
            requestBuilder.uri(URI.create(url));
            this.httpServerHeaderMap().forEach(requestBuilder::setHeader);
            HttpRequest request = requestBuilder.build();
            ((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAcceptAsync(response -> OrzMC.debugInfo("Response Code : " + response.toString()))).exceptionally(e -> {
                OrzMC.logger().severe("QQ\u673a\u5668\u4eba\u65e0\u6cd5\u8fde\u63a5\uff0c\u5de5\u4f5c\u5f02\u5e38: " + e.toString());
                return null;
            });
        }
        catch (Exception e2) {
            OrzMC.logger().severe(e2.toString());
        }
    }

    private Map<String, String> httpServerHeaderMap() {
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        String httpServerBearerToken = this.botConfig.getString("qq_bot_api_server_token");
        if (httpServerBearerToken != null && !httpServerBearerToken.isEmpty()) {
            httpHeaders.put("Authorization", "Bearer " + httpServerBearerToken);
        }
        return httpHeaders;
    }

    private Map<String, String> websocketServerHeaderMap() {
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        String websocketServerBearerToken = this.botConfig.getString("qq_bot_ws_server_token");
        if (websocketServerBearerToken != null && !websocketServerBearerToken.isEmpty()) {
            httpHeaders.put("Authorization", "Bearer " + websocketServerBearerToken);
        }
        return httpHeaders;
    }

    public void setupWebSocketClient() {
        String wsServer = this.botConfig.getString("qq_bot_ws_server");
        if (!this.isEnable() || wsServer == null || wsServer.isEmpty()) {
            return;
        }
        try {
            this.webSocketClient = new RobustWebSocketClient(wsServer, 10, 5000L, this.websocketServerHeaderMap()){

                @Override
                public void handleMessage(String message) {
                    OrzQQBot.this.processJsonStringPayload(message);
                }
            };
            this.webSocketClient.connect();
        }
        catch (Exception e) {
            OrzMC.logger().info(e.toString());
        }
    }

    public void shutdownWebSocketClient() {
        if (this.webSocketClient == null) {
            return;
        }
        this.webSocketClient.disconnect();
    }
}

