/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.utils.bot;

import com.google.gson.Gson;
import com.jokerhub.paper.plugin.orzmc.OrzMC;
import com.jokerhub.paper.plugin.orzmc.utils.bot.OrzBaseBot;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import org.bukkit.plugin.java.JavaPlugin;

public class OrzLarkBot
extends OrzBaseBot {
    public OrzLarkBot(JavaPlugin plugin) {
        super(plugin);
    }

    @Override
    public boolean isEnable() {
        return OrzMC.config().getBoolean("enable_lark_bot");
    }

    @Override
    public void setup() {
    }

    @Override
    public void teardown() {
    }

    @Override
    public void sendMessage(String msg) {
        if (!this.isEnable()) {
            OrzMC.debugInfo("Lark Bot Disabled!");
            return;
        }
        try {
            String larkBotWebhookUrl = OrzMC.config().getString("lark_bot_webhook");
            this.asyncHttpRequest(larkBotWebhookUrl, msg);
        }
        catch (Exception e) {
            OrzMC.logger().info(e.toString());
        }
    }

    @Override
    public void sendPrivateMessage(String message) {
    }

    private void asyncHttpRequest(String url, String msg) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("msg_type", "text");
        HashMap<String, String> content = new HashMap<String, String>();
        content.put("text", msg);
        params.put("content", content);
        String postBodyJsonString = new Gson().toJson(params);
        try (HttpClient client = HttpClient.newHttpClient();){
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(postBodyJsonString)).build();
            ((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAcceptAsync(response -> OrzMC.debugInfo("Response : " + response.toString()))).exceptionally(e -> {
                OrzMC.logger().severe("Lark\u673a\u5668\u4eba\u65e0\u6cd5\u8fde\u63a5\uff0c\u5de5\u4f5c\u5f02\u5e38: " + e.toString());
                return null;
            });
        }
        catch (Exception e2) {
            OrzMC.logger().severe(e2.toString());
        }
    }
}

