/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc;

import com.jokerhub.paper.plugin.orzmc.commands.OrzGuideBook;
import com.jokerhub.paper.plugin.orzmc.commands.OrzMenuCommand;
import com.jokerhub.paper.plugin.orzmc.commands.OrzTPBow;
import com.jokerhub.paper.plugin.orzmc.events.OrzBowShootEvent;
import com.jokerhub.paper.plugin.orzmc.events.OrzDebugEvent;
import com.jokerhub.paper.plugin.orzmc.events.OrzMenuEvent;
import com.jokerhub.paper.plugin.orzmc.events.OrzPlayerEvent;
import com.jokerhub.paper.plugin.orzmc.events.OrzServerEvent;
import com.jokerhub.paper.plugin.orzmc.events.OrzTNTEvent;
import com.jokerhub.paper.plugin.orzmc.events.OrzTPEvent;
import com.jokerhub.paper.plugin.orzmc.events.OrzWhiteListEvent;
import com.jokerhub.paper.plugin.orzmc.utils.bot.OrzBaseBot;
import com.jokerhub.paper.plugin.orzmc.utils.bot.OrzDiscordBot;
import com.jokerhub.paper.plugin.orzmc.utils.bot.OrzLarkBot;
import com.jokerhub.paper.plugin.orzmc.utils.bot.OrzQQBot;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.GameMode;
import org.bukkit.Server;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class OrzMC
extends JavaPlugin
implements Listener {
    private Listener[] eventListeners;
    private Map<String, CommandExecutor> commandHandlers;
    private Map<String, OrzBaseBot> bots;

    Listener[] getEventListeners() {
        if (this.eventListeners == null) {
            this.eventListeners = new Listener[]{new OrzBowShootEvent(), new OrzPlayerEvent(this), new OrzTPEvent(), new OrzTNTEvent(this), new OrzMenuEvent(), new OrzServerEvent(this), new OrzWhiteListEvent(this), new OrzDebugEvent()};
        }
        return this.eventListeners;
    }

    Map<String, CommandExecutor> getCommandHandlers() {
        if (this.commandHandlers == null) {
            this.commandHandlers = Map.of("tpbow", new OrzTPBow(), "guide", new OrzGuideBook(), "menu", new OrzMenuCommand());
        }
        return this.commandHandlers;
    }

    Map<String, OrzBaseBot> getBots() {
        if (this.bots == null) {
            this.bots = Map.of("qq", new OrzQQBot(this), "discord", new OrzDiscordBot(this), "lark", new OrzLarkBot(this));
        }
        return this.bots;
    }

    public void onEnable() {
        super.onEnable();
        this.getLogger().info("OrzMC \u63d2\u4ef6\u751f\u6548!");
        this.saveDefaultConfig();
        Arrays.stream(this.getEventListeners()).forEach(eventListener -> this.getServer().getPluginManager().registerEvents(eventListener, (Plugin)this));
        this.getCommandHandlers().forEach((key, value) -> {
            PluginCommand cmd = this.getCommand((String)key);
            if (cmd != null) {
                cmd.setExecutor(value);
            }
        });
        this.getBots().values().forEach(OrzBaseBot::setup);
        this.setupServerForceWhitelist();
    }

    public void onDisable() {
        super.onDisable();
        this.notifyServerStop();
        this.bots.values().forEach(OrzBaseBot::teardown);
    }

    public static JavaPlugin plugin() {
        return JavaPlugin.getPlugin(OrzMC.class);
    }

    public static Server server() {
        return OrzMC.plugin().getServer();
    }

    public static Logger logger() {
        return OrzMC.plugin().getLogger();
    }

    public static FileConfiguration config() {
        return OrzMC.plugin().getConfig();
    }

    public void sendPublicMessage(String message) {
        OrzMC.debugInfo(message);
        this.bots.values().forEach(bot -> bot.sendMessage(message));
    }

    public void sendPrivateMessage(String message) {
        OrzMC.debugInfo(message);
        this.bots.values().forEach(bot -> bot.sendPrivateMessage(message));
    }

    public static void debugInfo(String msg) {
        if (!OrzDebugEvent.debug) {
            return;
        }
        OrzMC.logger().info(msg);
    }

    private void notifyServerStop() {
        String minecraftVersion = this.getServer().getMinecraftVersion();
        String stringBuilder = "Minecraft " + minecraftVersion + "\n------\n\u670d\u52a1\u505c\u6b62\n\n\u505c\u6b62\u72b6\u6001\u65e0\u6cd5\u54cd\u5e94\u547d\u4ee4\u6d88\u606f";
        this.sendPublicMessage(stringBuilder);
    }

    private void setupServerForceWhitelist() {
        boolean forceWhitelist = this.getConfig().getBoolean("force_whitelist");
        this.getServer().setWhitelist(forceWhitelist);
        this.getServer().setWhitelistEnforced(forceWhitelist);
        this.getServer().reloadWhitelist();
        this.getServer().setDefaultGameMode(GameMode.SURVIVAL);
        if (forceWhitelist) {
            this.getLogger().info("\u670d\u52a1\u7aef\u4f7f\u7528\u5f3a\u5236\u767d\u540d\u5355\u673a\u5236");
        }
    }
}

