/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.events;

import com.jokerhub.paper.plugin.orzmc.OrzMC;
import com.jokerhub.paper.plugin.orzmc.utils.OrzMessageParser;
import io.papermc.paper.event.block.BlockPreDispenseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.TNTPrimeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OrzTNTEvent
implements Listener {
    private final List<Region> whiteListRegions = new ArrayList<Region>();
    private final boolean enableTNT;
    private final boolean enableRespawnAnchor;
    private final int tntPlaceCooldown;
    private final Map<UUID, Long> playerCooldowns = new ConcurrentHashMap<UUID, Long>();

    public OrzTNTEvent() {
        this.enableTNT = OrzMC.config().getBoolean("tnt.enable", false);
        this.enableRespawnAnchor = OrzMC.config().getBoolean("tnt.enable_respawn_anchor", false);
        this.tntPlaceCooldown = OrzMC.config().getInt("tnt.place_cooldown", 0);
        List regions = OrzMC.config().getMapList("tnt.whitelist");
        for (Map regionMap : regions) {
            Region region = new Region(((Number)regionMap.get("minX")).intValue(), ((Number)regionMap.get("maxX")).intValue(), ((Number)regionMap.get("minY")).intValue(), ((Number)regionMap.get("maxY")).intValue(), ((Number)regionMap.get("minZ")).intValue(), ((Number)regionMap.get("maxZ")).intValue(), (String)regionMap.get("world"));
            this.whiteListRegions.add(region);
        }
    }

    @EventHandler
    public void onTNTPrime(@NotNull TNTPrimeEvent event) {
        Block placedBlock = event.getBlock();
        if (!this.enableTNT && this.isNotInWhiteList(placedBlock)) {
            event.setCancelled(true);
            this.notifyTNTEvent(placedBlock, "TNT\u88ab\u70b9\u71c3\uff08\u5df2\u7981\u6b62\uff09");
            return;
        }
        this.notifyTNTEvent(placedBlock, "TNT\u88ab\u70b9\u71c3");
    }

    @EventHandler
    public void onPlaceBlock(@NotNull BlockPlaceEvent event) {
        Block placedBlock = event.getBlockPlaced();
        Material placedBlockType = placedBlock.getType();
        Player player = event.getPlayer();
        if (placedBlockType == Material.TNT) {
            this.handleTNTPlace(event, player, placedBlock);
            return;
        }
        if (placedBlockType == Material.RESPAWN_ANCHOR && !this.enableRespawnAnchor) {
            event.setCancelled(true);
            player.sendMessage(Component.text((String)"\u91cd\u751f\u951a\u653e\u7f6e\u5df2\u88ab\u7ba1\u7406\u5458\u7981\u7528").color(TextColor.color((int)0xFF5555)));
        }
    }

    private void handleTNTPlace(BlockPlaceEvent event, Player player, Block placedBlock) {
        if (this.tntPlaceCooldown > 0 && this.checkCooldown(player)) {
            event.setCancelled(true);
            long remaining = (this.playerCooldowns.get(player.getUniqueId()) + (long)this.tntPlaceCooldown * 1000L - System.currentTimeMillis()) / 1000L;
            player.sendMessage((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"\u653e\u7f6eTNT\u51b7\u5374\u4e2d\uff0c\u8bf7\u7b49\u5f85 "))).append(Component.text((String)(remaining + "\u79d2")).color(TextColor.color((int)0xFFAA00)))).build());
            return;
        }
        if (!this.enableTNT && this.isNotInWhiteList(placedBlock)) {
            event.setCancelled(true);
            player.sendMessage(Component.text((String)"TNT\u653e\u7f6e\u5df2\u88ab\u7ba1\u7406\u5458\u7981\u7528").color(TextColor.color((int)0xFF5555)));
            return;
        }
        if (this.tntPlaceCooldown > 0) {
            this.playerCooldowns.put(player.getUniqueId(), System.currentTimeMillis());
        }
        this.sendPlacementNotification(player, placedBlock);
    }

    private boolean checkCooldown(@NotNull Player player) {
        if (!this.playerCooldowns.containsKey(player.getUniqueId())) {
            return false;
        }
        long lastPlaceTime = this.playerCooldowns.get(player.getUniqueId());
        return System.currentTimeMillis() - lastPlaceTime < (long)this.tntPlaceCooldown * 1000L;
    }

    @EventHandler
    public void onBlockPreDispense(@NotNull BlockPreDispenseEvent event) {
        ItemStack itemStack = event.getItemStack();
        Material itemType = itemStack.getType();
        if (itemType != Material.TNT && itemType != Material.TNT_MINECART) {
            return;
        }
        Block dispenser = event.getBlock();
        if (!this.enableTNT && this.isNotInWhiteList(dispenser)) {
            event.setCancelled(true);
            this.notifyTNTEvent(dispenser, "\u53d1\u5c04" + itemType.name() + "\u88ab\u7981\u6b62");
        }
    }

    @EventHandler
    public void onBlockExplode(@NotNull BlockExplodeEvent event) {
        Block block = event.getBlock();
        this.notifyExplosionEvent(block.getLocation(), block.getType().name() + "\u7206\u70b8");
    }

    @EventHandler
    public void onEntityExplode(@NotNull EntityExplodeEvent event) {
        if (event.getEntityType() == EntityType.CREEPER) {
            return;
        }
        this.notifyExplosionEvent(event.getLocation(), event.getEntityType().name() + "\u7206\u70b8");
    }

    private boolean isNotInWhiteList(@NotNull Block block) {
        Location loc = block.getLocation();
        for (Region region : this.whiteListRegions) {
            if (!region.contains(loc)) continue;
            return false;
        }
        return true;
    }

    private void notifyTNTEvent(Block block, String message) {
        TextComponent msg = (TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text((String)"[TNT\u8b66\u62a5] ").color(TextColor.color((int)0xFF5555)))).append((Component)this.playerInfo(null))).append((Component)Component.space())).append((Component)this.locationComponent(block))).append((Component)Component.space())).append((Component)Component.text((String)message))).build();
        OrzMC.server().sendMessage((Component)msg);
        OrzMC.sendPublicMessage("[TNT\u8b66\u62a5] " + this.locationString(block) + message);
    }

    private void notifyExplosionEvent(Location location, String message) {
        TextComponent msg = (TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text((String)"[\u7206\u70b8\u8b66\u62a5] ").color(TextColor.color((int)0xFFAA00)))).append((Component)this.locationComponent(location))).append((Component)Component.space())).append((Component)Component.text((String)message))).build();
        OrzMC.server().sendMessage((Component)msg);
        OrzMC.sendPublicMessage("[\u7206\u70b8\u8b66\u62a5] " + this.locationString(location) + message);
    }

    private void sendPlacementNotification(Player player, Block block) {
        TextComponent msg = (TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)this.playerInfo(player))).append((Component)Component.space())).append((Component)Component.text((String)"\u5728"))).append((Component)this.locationComponent(block))).append((Component)Component.space())).append((Component)Component.text((String)"\u653e\u7f6e\u4e86 TNT"))).build();
        OrzMC.server().sendMessage((Component)msg);
        OrzMC.sendPublicMessage(OrzMessageParser.playerDisplayName(player) + " \u5728" + this.locationString(block) + "\u653e\u7f6e\u4e86 TNT");
    }

    @NotNull
    private TextComponent playerInfo(@Nullable Player player) {
        if (player != null) {
            return (TextComponent)Component.text((String)player.getName()).color(TextColor.color((int)0xFF5555));
        }
        return (TextComponent)Component.text((String)"\u672a\u77e5\u73a9\u5bb6").color(TextColor.color((int)0xAAAAAA));
    }

    @NotNull
    private TextComponent locationComponent(@NotNull Block block) {
        return this.locationComponent(block.getLocation());
    }

    @NotNull
    private TextComponent locationComponent(Location location) {
        String locString = this.locationString(location);
        return (TextComponent)((TextComponent)((TextComponent)Component.text((String)locString).color(TextColor.color((int)0x55FF55))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"\u70b9\u51fb\u590d\u5236\u5750\u6807")))).clickEvent(ClickEvent.copyToClipboard((String)locString.trim()));
    }

    @NotNull
    private String locationString(@NotNull Block block) {
        return this.locationString(block.getLocation());
    }

    @NotNull
    private String locationString(@NotNull Location location) {
        return String.format(" [%s] %d %d %d ", location.getWorld().getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    private record Region(int minX, int maxX, int minY, int maxY, int minZ, int maxZ, String world) {
        private Region(int minX, int maxX, int minY, int maxY, int minZ, int maxZ, String world) {
            this.minX = Math.min(minX, maxX);
            this.maxX = Math.max(minX, maxX);
            this.minY = Math.min(minY, maxY);
            this.maxY = Math.max(minY, maxY);
            this.minZ = Math.min(minZ, maxZ);
            this.maxZ = Math.max(minZ, maxZ);
            this.world = world;
        }

        public boolean contains(@NotNull Location loc) {
            return loc.getWorld().getName().equals(this.world) && loc.getX() >= (double)this.minX && loc.getX() <= (double)this.maxX && loc.getY() >= (double)this.minY && loc.getY() <= (double)this.maxY && loc.getZ() >= (double)this.minZ && loc.getZ() <= (double)this.maxZ;
        }
    }
}

