/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc;

import com.jokerhub.paper.plugin.orzmc.bot.OrzDiscordBot;
import com.jokerhub.paper.plugin.orzmc.bot.OrzLarkBot;
import com.jokerhub.paper.plugin.orzmc.bot.OrzQQBot;
import com.jokerhub.paper.plugin.orzmc.commands.OrzGuideBook;
import com.jokerhub.paper.plugin.orzmc.commands.OrzMenuCommand;
import com.jokerhub.paper.plugin.orzmc.commands.OrzTPBow;
import com.jokerhub.paper.plugin.orzmc.events.OrzBowShootEvent;
import com.jokerhub.paper.plugin.orzmc.events.OrzDebugEvent;
import com.jokerhub.paper.plugin.orzmc.events.OrzMenuEvent;
import com.jokerhub.paper.plugin.orzmc.events.OrzPlayerEvent;
import com.jokerhub.paper.plugin.orzmc.events.OrzServerEvent;
import com.jokerhub.paper.plugin.orzmc.events.OrzTNTEvent;
import com.jokerhub.paper.plugin.orzmc.events.OrzTPEvent;
import com.jokerhub.paper.plugin.orzmc.events.OrzWhiteListEvent;
import java.util.logging.Logger;
import org.bukkit.Server;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class OrzMC
extends JavaPlugin
implements Listener {
    public static final OrzDiscordBot discordBot = new OrzDiscordBot();
    public static final OrzQQBot qqBot = new OrzQQBot();
    private static final OrzLarkBot larkBot = new OrzLarkBot();

    public static JavaPlugin plugin() {
        return JavaPlugin.getPlugin(OrzMC.class);
    }

    public static Server server() {
        return OrzMC.plugin().getServer();
    }

    public static Logger logger() {
        return OrzMC.plugin().getLogger();
    }

    public static FileConfiguration config() {
        return OrzMC.plugin().getConfig();
    }

    public static void sendPublicMessage(String message) {
        OrzMC.debugInfo(message);
        discordBot.sendMessage(message);
        larkBot.sendMessage(message);
        qqBot.sendQQGroupMsg(message);
    }

    public static void sendPrivateMessage(String message) {
        OrzMC.debugInfo(message);
        qqBot.sendPrivateMsg(message);
    }

    public static void debugInfo(String msg) {
        if (!OrzDebugEvent.debug) {
            return;
        }
        OrzMC.logger().info(msg);
    }

    public void onEnable() {
        PluginCommand menuCmd;
        PluginCommand guideCmd;
        super.onEnable();
        this.saveDefaultConfig();
        this.getLogger().info("OrzMC \u63d2\u4ef6\u751f\u6548!");
        this.getServer().getPluginManager().registerEvents((Listener)new OrzBowShootEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new OrzPlayerEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new OrzTPEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new OrzTNTEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new OrzMenuEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new OrzServerEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new OrzWhiteListEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new OrzDebugEvent(), (Plugin)this);
        PluginCommand tpbowCmd = this.getCommand("tpbow");
        if (tpbowCmd != null) {
            tpbowCmd.setExecutor((CommandExecutor)new OrzTPBow());
        }
        if ((guideCmd = this.getCommand("guide")) != null) {
            guideCmd.setExecutor((CommandExecutor)new OrzGuideBook());
        }
        if ((menuCmd = this.getCommand("menu")) != null) {
            menuCmd.setExecutor((CommandExecutor)new OrzMenuCommand());
        }
        OrzWhiteListEvent.setupServerForceWhitelist();
        this.setupBots();
    }

    public void onDisable() {
        super.onDisable();
        this.teardownBots();
        OrzServerEvent.notifyServerStop();
    }

    private void setupBots() {
        discordBot.setup();
        larkBot.setup();
        qqBot.setup();
    }

    private void teardownBots() {
        discordBot.teardown();
        larkBot.teardown();
        qqBot.teardown();
    }
}

