/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.utils;

import org.bukkit.Location;
import org.bukkit.block.Block;

public class LocationKeyUtil {
    public static long packBlock(Block block) {
        return LocationKeyUtil.packCoordinates(block.getX(), block.getY(), block.getZ());
    }

    public static long packLocation(Location location) {
        return LocationKeyUtil.packCoordinates(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public static long packCoordinates(int x, int y, int z) {
        long key = 0L;
        key |= ((long)x & 0xFFFFFFFFL) << 38;
        key |= ((long)z & 0xFFFFFFFFL) << 12;
        return key |= (long)y & 0xFFFL;
    }

    public static int getX(long key) {
        return (int)(key >> 38);
    }

    public static int getY(long key) {
        return (int)(key & 0xFFFL);
    }

    public static int getZ(long key) {
        return (int)(key >> 12 & 0x3FFFFFFL);
    }

    public static boolean matchBlock(Block block, long packedKey) {
        long blockKey = LocationKeyUtil.packBlock(block);
        return blockKey == packedKey;
    }

    public static boolean matchLocation(Location location, long packedKey) {
        long locationKey = LocationKeyUtil.packLocation(location);
        return locationKey == packedKey;
    }
}

