/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.vermulst.multibreak.multibreak.MultiBreak;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class BreakUtils {
    public static final Map<UUID, Double> interactionRangeCache = new HashMap<UUID, Double>();
    private static final int INTERACTION_RANGE_LEEWAY = 2;

    private static double getRange(Player p) {
        UUID uuid = p.getUniqueId();
        return interactionRangeCache.computeIfAbsent(uuid, u -> p.getAttribute(Attribute.BLOCK_INTERACTION_RANGE).getValue() + 2.0);
    }

    public static RayTraceResult getRayTraceResultExact(Player p) {
        return p.rayTraceBlocks(BreakUtils.getRange(p) - 2.0, FluidCollisionMode.NEVER);
    }

    public static RayTraceResult getRayTraceResult(Player p) {
        return p.rayTraceBlocks(BreakUtils.getRange(p), FluidCollisionMode.NEVER);
    }

    public static BlockFace getBlockFace(Player p) {
        RayTraceResult rayTraceResult = BreakUtils.getRayTraceResult(p);
        if (rayTraceResult == null) {
            return null;
        }
        return rayTraceResult.getHitBlockFace();
    }

    public static BlockFace getThickRaytraceBlockFace(Player p, Block targetBlock) {
        double[] thicknesses = new double[]{0.1, 0.2, 0.35};
        double range = BreakUtils.getRange(p);
        for (int attempt = 0; attempt < 3; ++attempt) {
            BlockFace result = BreakUtils.performThickRaycast(p, targetBlock, thicknesses[attempt], range);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static BlockFace performThickRaycast(Player p, Block targetBlock, double thickness, double range) {
        double[] offsets;
        Location eyeLoc = p.getEyeLocation();
        Vector direction = eyeLoc.getDirection();
        Vector right = direction.clone().crossProduct(new Vector(0, 1, 0)).normalize();
        Vector up = direction.clone().crossProduct(right).normalize();
        for (double xOff : offsets = new double[]{-thickness, 0.0, thickness}) {
            for (double yOff : offsets) {
                Location origin = eyeLoc.clone().add(right.clone().multiply(xOff)).add(up.clone().multiply(yOff));
                RayTraceResult rayResult = p.getWorld().rayTraceBlocks(origin, direction, BreakUtils.getRange(p), FluidCollisionMode.NEVER, false);
                if (rayResult == null || rayResult.getHitBlock() == null || !rayResult.getHitBlock().equals((Object)targetBlock)) continue;
                return rayResult.getHitBlockFace();
            }
        }
        return null;
    }

    public static Block getTargetBlock(Player p) {
        RayTraceResult rayTraceResult = BreakUtils.getRayTraceResult(p);
        if (rayTraceResult == null) {
            return null;
        }
        return rayTraceResult.getHitBlock();
    }

    public static float getDestroySpeed(Player p, MultiBreak multiBreak) {
        if (multiBreak == null) {
            return -1.0f;
        }
        multiBreak.invalidateHasCorrectToolCache();
        multiBreak.checkDestroySpeedChange(p);
        return multiBreak.getDestroySpeedMain(p);
    }

    public static float getDestroySpeed(ServerPlayer serverPlayer, MultiBreak multiBreak) {
        return multiBreak.getDestroySpeedMain(serverPlayer);
    }

    public static float getDestroySpeed(ServerPlayer serverPlayer, BlockPos blockPos, MultiBreak multiBreak) {
        return multiBreak.getDestroySpeed(serverPlayer, blockPos);
    }
}

