/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.multibreak.runnables;

import java.util.UUID;
import me.vermulst.multibreak.figure.Figure;
import me.vermulst.multibreak.multibreak.BreakManager;
import me.vermulst.multibreak.multibreak.MultiBreak;
import me.vermulst.multibreak.multibreak.MultiBreakType;
import me.vermulst.multibreak.utils.BreakUtils;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class MultiBreakRunnable
extends BukkitRunnable {
    private final Player p;
    private final Block block;
    private boolean init = false;
    @NotNull
    private final Figure figure;
    private final BreakManager breakManager;
    private final MultiBreakType multiBreakType;

    public MultiBreakRunnable(Player p, Block block, @NotNull Figure figure, BreakManager breakManager, MultiBreakType multiBreakType) {
        this.p = p;
        this.block = block;
        this.figure = figure;
        this.breakManager = breakManager;
        this.multiBreakType = multiBreakType;
    }

    public void run() {
        RayTraceResult rayTraceResult;
        boolean hasMoved;
        UUID uuid = this.p.getUniqueId();
        MultiBreak multiBreak = this.breakManager.getMultiBreak(this.p);
        boolean isInitializedStaticBreak = multiBreak != null && this.multiBreakType.isStatic();
        boolean bl = hasMoved = !this.init;
        if (!hasMoved && this.breakManager.getMovedPlayers().containsKey(uuid) && !isInitializedStaticBreak) {
            int potentialRaytraceDelayTicks;
            int movedTick = this.breakManager.getMovedPlayers().get(uuid);
            int difference = Bukkit.getCurrentTick() - movedTick;
            if (difference <= (potentialRaytraceDelayTicks = 2 + (this.p.getPing() + 49) / 50)) {
                hasMoved = true;
            } else {
                this.breakManager.getMovedPlayers().remove(uuid);
            }
        }
        RayTraceResult rayTraceResult2 = rayTraceResult = hasMoved ? BreakUtils.getRayTraceResult(this.p) : null;
        if (hasMoved) {
            if (rayTraceResult == null) {
                this.cancelMultiBreak(multiBreak);
                return;
            }
            Block blockMining = rayTraceResult.getHitBlock();
            BlockFace blockFace = rayTraceResult.getHitBlockFace();
            if (!this.init) {
                if (this.block.getType().isAir() || !blockMining.equals((Object)this.block)) {
                    this.cancelMultiBreak(multiBreak);
                    return;
                }
                this.init = true;
            }
            if (multiBreak == null) {
                multiBreak = this.breakManager.initMultiBreak(this.p, blockMining, this.figure, this.multiBreakType);
                if (multiBreak == null) {
                    this.cancelMultiBreak(null);
                    return;
                }
                if (this.multiBreakType.isStatic()) {
                    multiBreak.setLastTick(Bukkit.getCurrentTick());
                }
            }
            Vector direction = blockFace.getDirection();
            if (!multiBreak.getPlayerDirection().equalsVector(direction)) {
                if ((multiBreak = this.replaceMultiBreak(this.p, multiBreak)) == null) {
                    this.cancelMultiBreak(null);
                    return;
                }
                this.breakManager.scheduleMultiBreak(this.p, this.figure, this.block, this.multiBreakType);
            }
        }
        multiBreak.tick();
    }

    public void cancelMultiBreak(MultiBreak multiBreak) {
        this.breakManager.endMultiBreak(this.p, multiBreak, false);
        if (!this.isCancelled()) {
            this.cancel();
        }
    }

    public MultiBreak replaceMultiBreak(Player p, MultiBreak multiBreak) {
        this.breakManager.endMultiBreak(p, multiBreak, false);
        float progressBroken = multiBreak.getProgressBroken();
        int progressTicks = multiBreak.getProgressTicks();
        multiBreak = this.breakManager.initMultiBreak(p, this.block, this.figure, this.multiBreakType);
        if (multiBreak == null) {
            return null;
        }
        multiBreak.setProgressBroken(progressBroken);
        multiBreak.setProgressTicks(progressTicks);
        return multiBreak;
    }
}

