/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.multibreak.event;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.destroystokyo.paper.event.server.ServerTickStartEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.vermulst.multibreak.config.Config;
import me.vermulst.multibreak.multibreak.BreakManager;
import me.vermulst.multibreak.utils.SimpleLocation;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.CrafterInventory;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class RefreshEvents
implements Listener {
    private final BreakManager breakManager;
    private final Map<UUID, SimpleLocation> previousLocations = new HashMap<UUID, SimpleLocation>();

    public RefreshEvents(BreakManager breakManager) {
        this.breakManager = breakManager;
    }

    @EventHandler
    public void tickStartEvent(ServerTickStartEvent e) {
        for (UUID uuid : this.breakManager.getBreakingPlayers()) {
            Player p = Bukkit.getPlayer((UUID)uuid);
            if (p == null) continue;
            Location loc = p.getLocation();
            SimpleLocation previousLocation = this.previousLocations.get(uuid);
            if (previousLocation != null && !previousLocation.isDifferent(loc)) continue;
            SimpleLocation newLocation = new SimpleLocation(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
            this.previousLocations.put(uuid, newLocation);
            this.breakManager.getMovedPlayers().put(uuid, Bukkit.getCurrentTick());
        }
    }

    @EventHandler
    public void quitEvent(PlayerQuitEvent e) {
        this.previousLocations.remove(e.getPlayer().getUniqueId());
    }

    @EventHandler
    public void tickEvent(ServerTickEndEvent e) {
        boolean fairMode = Config.getInstance().isFairModeEnabled();
        if (!fairMode) {
            return;
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.breakManager.refreshBreakSpeed(p);
        }
    }

    @EventHandler
    public void deathEvent(PlayerRespawnEvent e) {
        this.breakManager.refreshTool(e.getPlayer());
    }

    @EventHandler
    public void pickupIntoHand(EntityPickupItemEvent e) {
        LivingEntity livingEntity = e.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player p = (Player)livingEntity;
        PlayerInventory inventory = p.getInventory();
        ItemStack[] items = inventory.getContents();
        int heldSlot = inventory.getHeldItemSlot();
        if (items[heldSlot] != null) {
            return;
        }
        int firstEmptySlot = -1;
        for (int i = 0; i < 9; ++i) {
            if (items[i] != null) continue;
            firstEmptySlot = i;
            break;
        }
        if (firstEmptySlot == heldSlot) {
            this.breakManager.refreshTool(p);
        }
    }

    @EventHandler
    public void emptyHeldSlot(PlayerDropItemEvent e) {
        Player p = e.getPlayer();
        if (p.getInventory().getItemInMainHand().getType() != Material.AIR) {
            return;
        }
        this.breakManager.refreshTool(p);
    }

    @EventHandler
    public void placeLastBlock(BlockPlaceEvent e) {
        Player p = e.getPlayer();
        if (p.getInventory().getItemInMainHand().getAmount() != 1) {
            return;
        }
        this.breakManager.refreshTool(p);
    }

    @EventHandler
    public void eatEvent(PlayerItemConsumeEvent e) {
        Player p = e.getPlayer();
        if (p.getInventory().getItemInMainHand().getAmount() != 1) {
            return;
        }
        this.breakManager.refreshTool(e.getPlayer());
    }

    @EventHandler
    public void joinEvent(PlayerJoinEvent e) {
        this.breakManager.refreshTool(e.getPlayer());
    }

    @EventHandler
    public void hotbarSwap(PlayerItemHeldEvent e) {
        Player p = e.getPlayer();
        this.breakManager.refreshTool(p);
    }

    @EventHandler
    public void offhandSwap(PlayerSwapHandItemsEvent e) {
        this.breakManager.refreshTool(e.getPlayer());
    }

    @EventHandler
    public void heldItemClick(InventoryClickEvent e) {
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player p = (Player)humanEntity;
        if (e.isShiftClick()) {
            this.shiftClick(e, p);
        } else if (ClickType.NUMBER_KEY.equals((Object)e.getClick())) {
            int playerHeldSlotRelative = p.getInventory().getHeldItemSlot();
            Inventory topInv = e.getInventory();
            if (e.getHotbarButton() == playerHeldSlotRelative || e.getRawSlot() == this.getPlayerHeldSlotRaw(p, topInv)) {
                this.breakManager.refreshTool(p);
            }
        } else {
            Inventory topInv = e.getInventory();
            int playerHeldSlotRaw = this.getPlayerHeldSlotRaw(p, topInv);
            if (e.getRawSlot() == playerHeldSlotRaw) {
                this.breakManager.refreshTool(p);
            }
        }
    }

    public void shiftClick(InventoryClickEvent e, Player p) {
        Inventory topInv = e.getInventory();
        boolean refresh = false;
        int playerHeldSlot = p.getInventory().getHeldItemSlot();
        int playerHeldSlotRaw = this.getPlayerHeldSlotRaw(p, topInv);
        int baseHotbarSlotRaw = playerHeldSlotRaw - playerHeldSlot;
        int click = e.getRawSlot();
        if (click >= baseHotbarSlotRaw && click <= baseHotbarSlotRaw + 8) {
            refresh = click == playerHeldSlotRaw;
        } else if (topInv instanceof CraftingInventory) {
            if (click <= 8 || click == 45) {
                return;
            }
            ItemStack[] items = p.getInventory().getContents();
            int firstEmptySlot = -1;
            for (int i = 0; i < 9; ++i) {
                if (items[i] != null) continue;
                firstEmptySlot = i;
                break;
            }
            refresh = firstEmptySlot == playerHeldSlot;
        } else {
            int topInventorySize;
            int slot = e.getRawSlot();
            if (slot <= (topInventorySize = this.getTopInventorySize(topInv))) {
                ItemStack[] items = p.getInventory().getContents();
                int firstEmptySlot = -1;
                for (int i = 8; i >= 0; ++i) {
                    if (items[i] != null) continue;
                    firstEmptySlot = i;
                    break;
                }
                boolean bl = refresh = firstEmptySlot == playerHeldSlot;
            }
        }
        if (refresh) {
            this.breakManager.refreshTool(p);
        }
    }

    @EventHandler
    public void dragIntoHeldItemEvent(InventoryDragEvent e) {
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player p = (Player)humanEntity;
        Inventory topInv = e.getInventory();
        int playerHeldSlotRaw = this.getPlayerHeldSlotRaw(p, topInv);
        if (e.getRawSlots().contains(playerHeldSlotRaw)) {
            this.breakManager.refreshTool(p);
        }
    }

    private int getPlayerHeldSlotRaw(Player p, Inventory topInv) {
        return this.getTopInventorySize(topInv) + 27 + p.getInventory().getHeldItemSlot();
    }

    private int getTopInventorySize(Inventory topInv) {
        int inventorySize = topInv.getSize();
        if (topInv instanceof CraftingInventory) {
            inventorySize += 4;
        } else if (topInv instanceof CrafterInventory) {
            --inventorySize;
        }
        return inventorySize;
    }
}

