/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.config;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import me.vermulst.multibreak.figure.Figure;
import me.vermulst.multibreak.figure.types.FigureType;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Config {
    private Map<String, Figure> configOptions;
    private Map<Material, String> materialOptions;
    private final EnumSet<Material> includedMaterials = EnumSet.noneOf(Material.class);
    private final EnumSet<Material> ignoredMaterials = EnumSet.noneOf(Material.class);
    private int playSoundPingTreshold = 50;
    private final boolean[] options = new boolean[]{true};
    private static final String[] optionNames = new String[]{"fair_mode"};
    private static final String OLD_MATERIAL_PRESETS_PATH = "material_configs";
    private static final String NEW_MATERIAL_PRESETS_PATH = "material_presets";
    private static final String OLD_PRESETS_PATH = "config_options";
    private static final String NEW_PRESETS_PATH = "presets";
    private static final Config INSTANCE = new Config();

    private Config() {
    }

    public static Config getInstance() {
        return INSTANCE;
    }

    public Inventory getMenu() {
        Inventory inventory = Bukkit.createInventory(null, (int)54, (Component)Component.text((String)"Configurations"));
        int index = 0;
        for (Map.Entry<String, Figure> entry : this.configOptions.entrySet()) {
            String name = entry.getKey();
            Figure figure = entry.getValue();
            ItemStack item = new ItemStack(Material.WRITABLE_BOOK);
            ItemMeta meta = item.getItemMeta();
            meta.displayName((Component)Component.text((String)name));
            meta.lore(figure.getLore());
            item.setItemMeta(meta);
            inventory.setItem(index, item);
            ++index;
        }
        return inventory;
    }

    public void save(FileConfiguration fileConfiguration) {
        List<List<String>> optionComments = List.of(List.of("If enabled, player will slow down to the slowest block."));
        for (int i = 0; i < this.options.length; ++i) {
            String string = optionNames[i];
            boolean option = this.options[i];
            fileConfiguration.set(string, (Object)option);
            fileConfiguration.setComments(string, optionComments.get(i));
        }
        fileConfiguration.set(OLD_PRESETS_PATH, null);
        for (Map.Entry<String, Figure> entry : this.getConfigOptions().entrySet()) {
            String name = entry.getKey();
            String path = "presets." + name;
            String figurePath = path + ".figure.";
            Figure figure = entry.getValue();
            fileConfiguration.set(figurePath + "type", (Object)figure.getFigureType().name());
            fileConfiguration.set(figurePath + "width", (Object)figure.getWidth());
            fileConfiguration.set(figurePath + "height", (Object)figure.getHeight());
            fileConfiguration.set(figurePath + "depth", (Object)figure.getDepth());
            fileConfiguration.set(figurePath + "width_rotation", (Object)figure.getRotationWidth());
            fileConfiguration.set(figurePath + "height_rotation", (Object)figure.getRotationHeight());
            fileConfiguration.set(figurePath + "depth_rotation", (Object)figure.getRotationDepth());
            fileConfiguration.set(figurePath + "width_offset", (Object)figure.getOffSetWidth());
            fileConfiguration.set(figurePath + "height_offset", (Object)figure.getOffSetHeight());
            fileConfiguration.set(figurePath + "depth_offset", (Object)figure.getOffSetDepth());
        }
        fileConfiguration.set(OLD_MATERIAL_PRESETS_PATH, null);
        for (Map.Entry<String, Object> entry : this.materialOptions.entrySet()) {
            fileConfiguration.set("material_presets." + ((Material)entry.getKey()).name(), entry.getValue());
        }
        ArrayList includedMaterialNames = new ArrayList(this.includedMaterials.size());
        this.includedMaterials.forEach(material -> includedMaterialNames.add(material.toString()));
        fileConfiguration.set("included_materials", includedMaterialNames);
        fileConfiguration.setComments("included_materials", List.of("", "List of block types strictly included by multibreaks.", "if empty, all block types count"));
        ArrayList arrayList = new ArrayList(this.ignoredMaterials.size());
        this.ignoredMaterials.forEach(material -> ignoredMaterialNames.add(material.toString()));
        fileConfiguration.set("ignored_materials", arrayList);
        fileConfiguration.setComments("ignored_materials", List.of("", "List of block types ignored by multibreaks."));
        fileConfiguration.set("play_sound_ping_treshold", (Object)this.playSoundPingTreshold);
        fileConfiguration.setComments("play_sound_ping_treshold", List.of("", "The maximum ping (in ms) a player can have to hear multiple block breaks.", "For players with high ping, this sound can become annoying, since it is desynced with the main block."));
        fileConfiguration.set("fair_mode_leeway", null);
        fileConfiguration.set("legacy_mode", null);
        fileConfiguration.set("max_break_range", null);
    }

    public boolean load(FileConfiguration fileConfiguration) {
        this.configOptions = new HashMap<String, Figure>();
        this.materialOptions = new HashMap<Material, String>();
        boolean save = this.loadOptions(fileConfiguration);
        save = save || this.loadPresets(fileConfiguration);
        save = save || this.loadMaterialPresets(fileConfiguration);
        save = save || this.loadIncludedMaterials(fileConfiguration);
        save = save || this.loadIgnoredMaterials(fileConfiguration);
        boolean bl = save = save || this.loadPlaySoundPingTreshold(fileConfiguration);
        if (save) {
            this.save(fileConfiguration);
        }
        return save;
    }

    public boolean loadOptions(FileConfiguration fileConfiguration) {
        boolean save = false;
        int index = 0;
        for (String option : optionNames) {
            if (fileConfiguration.getKeys(false).contains(option)) {
                this.options[index] = fileConfiguration.getBoolean(option);
            } else {
                save = true;
            }
            ++index;
        }
        return save;
    }

    private boolean loadPresets(FileConfiguration fileConfiguration) {
        String path = null;
        boolean save = false;
        if (fileConfiguration.getKeys(false).contains(NEW_PRESETS_PATH)) {
            path = NEW_PRESETS_PATH;
        } else if (fileConfiguration.getKeys(false).contains(OLD_PRESETS_PATH)) {
            path = OLD_PRESETS_PATH;
            save = true;
        }
        if (path == null) {
            return save;
        }
        ConfigurationSection section = fileConfiguration.getConfigurationSection(path);
        for (String name : section.getKeys(false)) {
            ConfigurationSection section1 = section.getConfigurationSection(name).getConfigurationSection("figure");
            if (section1 == null) continue;
            FigureType figureType = FigureType.valueOf(section1.getString("type"));
            int width = section1.getInt("width");
            int height = section1.getInt("height");
            int depth = section1.getInt("depth");
            short width_rotation = (short)section1.getInt("width_rotation");
            short height_rotation = (short)section1.getInt("height_rotation");
            short depth_rotation = (short)section1.getInt("depth_rotation");
            int width_offset = section1.getInt("width_offset");
            int height_offset = section1.getInt("height_offset");
            int depth_offset = section1.getInt("depth_offset");
            Figure figure = figureType.build(width, height, depth);
            figure.setRotations(width_rotation, height_rotation, depth_rotation);
            figure.setOffsets(width_offset, height_offset, depth_offset);
            this.getConfigOptions().put(name, figure);
        }
        return save;
    }

    private boolean loadMaterialPresets(FileConfiguration fileConfiguration) {
        String path = null;
        boolean save = false;
        if (fileConfiguration.getKeys(false).contains(NEW_MATERIAL_PRESETS_PATH)) {
            path = NEW_MATERIAL_PRESETS_PATH;
        } else if (fileConfiguration.getKeys(false).contains(OLD_MATERIAL_PRESETS_PATH)) {
            path = OLD_MATERIAL_PRESETS_PATH;
            save = true;
        }
        if (path == null) {
            return save;
        }
        ConfigurationSection section = fileConfiguration.getConfigurationSection(path);
        if (section == null) {
            return save;
        }
        for (String itemtype : section.getKeys(false)) {
            String configOption = section.getString(itemtype);
            Material material = Material.valueOf((String)itemtype);
            this.getMaterialOptions().put(material, configOption);
        }
        return save;
    }

    private boolean loadIncludedMaterials(FileConfiguration fileConfiguration) {
        ArrayList defaultIgnoredNames = new ArrayList();
        boolean save = this.setIfMissing((ConfigurationSection)fileConfiguration, "included_materials", defaultIgnoredNames);
        this.includedMaterials.clear();
        List materialNames = fileConfiguration.getStringList("included_materials");
        for (String matName : materialNames) {
            Material mat = Material.getMaterial((String)matName);
            if (mat == null) continue;
            this.includedMaterials.add(mat);
        }
        return save;
    }

    private boolean loadIgnoredMaterials(FileConfiguration fileConfiguration) {
        List<String> defaultIgnoredNames = Stream.of(Material.BEDROCK).map(Enum::toString).toList();
        boolean save = this.setIfMissing((ConfigurationSection)fileConfiguration, "ignored_materials", defaultIgnoredNames);
        this.ignoredMaterials.clear();
        List materialNames = fileConfiguration.getStringList("ignored_materials");
        for (String matName : materialNames) {
            Material mat = Material.getMaterial((String)matName);
            if (mat == null) continue;
            this.ignoredMaterials.add(mat);
        }
        return save;
    }

    private boolean loadPlaySoundPingTreshold(FileConfiguration fileConfiguration) {
        int defaultTreshold = 50;
        boolean save = this.setIfMissing((ConfigurationSection)fileConfiguration, "play_sound_ping_treshold", defaultTreshold);
        this.playSoundPingTreshold = fileConfiguration.getInt("play_sound_ping_treshold", defaultTreshold);
        return save;
    }

    private boolean setIfMissing(ConfigurationSection config, String key, Object defaultValue) {
        if (!config.getKeys(false).contains(key)) {
            config.set(key, defaultValue);
            return true;
        }
        return false;
    }

    public void updateDeletePreset(FileConfiguration fileConfiguration, String name) {
        fileConfiguration.set("config_options." + name, null);
        fileConfiguration.set("presets." + name, null);
        String path = null;
        if (fileConfiguration.getKeys(false).contains(NEW_MATERIAL_PRESETS_PATH)) {
            path = NEW_MATERIAL_PRESETS_PATH;
        } else if (fileConfiguration.getKeys(false).contains(OLD_MATERIAL_PRESETS_PATH)) {
            path = OLD_MATERIAL_PRESETS_PATH;
        }
        if (path == null) {
            return;
        }
        ConfigurationSection section = fileConfiguration.getConfigurationSection(path);
        if (section == null) {
            return;
        }
        for (String materialName : section.getKeys(false)) {
            if (!name.equals(section.get(materialName))) continue;
            section.set(materialName, null);
            this.getMaterialOptions().remove(Material.valueOf((String)materialName));
        }
    }

    public Map<String, Figure> getConfigOptions() {
        return this.configOptions;
    }

    public Map<Material, String> getMaterialOptions() {
        return this.materialOptions;
    }

    public EnumSet<Material> getIncludedMaterials() {
        return this.includedMaterials;
    }

    public EnumSet<Material> getIgnoredMaterials() {
        return this.ignoredMaterials;
    }

    public boolean isFairModeEnabled() {
        return this.options[0];
    }

    public int getPlaySoundPingTreshold() {
        return this.playSoundPingTreshold;
    }
}

