/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.commands;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.Player;

public class CommandArgParser {
    private static final TextColor ERROR_COLOR = TextColor.color((int)255, (int)85, (int)85);
    private final Player p;

    public CommandArgParser(Player p) {
        this.p = p;
    }

    public int[] parseInts(String[] args, int start, int end, String[] failMessages) {
        int length = end - start + 1;
        int[] parsedInts = new int[length];
        for (int i = start; i <= end; ++i) {
            if (args.length <= i) {
                if (i > 3) break;
                this.p.sendMessage(Component.text((String)"Missing required arguments for dimensions: <width> <height> <depth>").color(ERROR_COLOR));
                return null;
            }
            String arg = args[i];
            try {
                parsedInts[i - start] = Integer.parseInt(arg);
                continue;
            }
            catch (NumberFormatException e) {
                this.p.sendMessage(Component.text((String)failMessages[i - start]).color(ERROR_COLOR));
                return null;
            }
        }
        return parsedInts;
    }

    public short[] parseShorts(String[] args, int start, int end, String[] failMessages) {
        int length = end - start + 1;
        short[] parsedShorts = new short[length];
        for (int i = start; i <= end && args.length > i; ++i) {
            String arg = args[i];
            try {
                parsedShorts[i - start] = Short.parseShort(arg);
                continue;
            }
            catch (NumberFormatException e) {
                this.p.sendMessage(Component.text((String)failMessages[i - start]).color(ERROR_COLOR));
                return null;
            }
        }
        return parsedShorts;
    }
}

