/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.api;

import java.util.UUID;
import me.vermulst.multibreak.figure.Figure;
import me.vermulst.multibreak.item.FigureItemDataType;
import me.vermulst.multibreak.multibreak.BreakManager;
import me.vermulst.multibreak.utils.BreakUtils;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MultiBreakAPI {
    private MultiBreakAPI() {
    }

    @NotNull
    public static ItemStack setFigure(@NotNull ItemStack itemStack, @NotNull Figure figure) {
        return new FigureItemDataType().set(itemStack, figure);
    }

    @Nullable
    public static Figure getFigure(@NotNull ItemStack itemStack) {
        return new FigureItemDataType().get(itemStack);
    }

    @NotNull
    public static ItemStack removeFigure(@NotNull ItemStack itemStack) {
        return new FigureItemDataType().remove(itemStack);
    }

    public static boolean hasFigure(@NotNull ItemStack itemStack) {
        return new FigureItemDataType().has(itemStack);
    }

    public static boolean isMultiBroken(@NotNull Block block) {
        return block.hasMetadata("multi-broken");
    }

    public static void updateInteractionRange(UUID uuid) {
        BreakUtils.interactionRangeCache.remove(uuid);
    }

    public static void updateTool(Player p) {
        BreakManager.getInstance().refreshTool(p);
    }
}

