/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.multibreak.runnables;

import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;
import me.vermulst.multibreak.multibreak.MultiBlock;
import me.vermulst.multibreak.multibreak.MultiBreak;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockDestructionPacket;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.scheduler.BukkitRunnable;

public class WriteStageRunnable
extends BukkitRunnable {
    private final int stage;
    private final ServerGamePacketListenerImpl[] connections;
    private final MultiBlock[] multiBlocksSnapshot;
    private final Block mainBlock;
    private final ReentrantLock lock;
    private final MultiBreak multiBreak;

    public WriteStageRunnable(MultiBlock[] multiBlocksSnapshot, Block mainBlock, int stage, ServerGamePacketListenerImpl[] connections, ReentrantLock lock, MultiBreak multiBreak) {
        this.stage = stage;
        this.connections = connections;
        this.multiBlocksSnapshot = multiBlocksSnapshot;
        this.mainBlock = mainBlock;
        this.lock = lock;
        this.multiBreak = multiBreak;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.stage != -1 && this.multiBreak.hasEnded()) {
            return;
        }
        int capacity = Math.max(this.multiBlocksSnapshot.length - 1, 0);
        ArrayList<ClientboundBlockDestructionPacket> packetsToSend = new ArrayList<ClientboundBlockDestructionPacket>(capacity);
        try {
            this.lock.lock();
            if (this.stage != -1 && this.multiBreak.hasEnded()) {
                return;
            }
            for (MultiBlock multiBlock : this.multiBlocksSnapshot) {
                if (!multiBlock.isVisible() || multiBlock.getBlock().equals((Object)this.mainBlock)) continue;
                int lastStage = multiBlock.getLastStage();
                if (this.stage != -1 && lastStage > this.stage || lastStage == -1) continue;
                multiBlock.setLastStage(this.stage);
                BlockPos blockPos = CraftLocation.toBlockPosition((Location)multiBlock.getLocation());
                ClientboundBlockDestructionPacket packet = new ClientboundBlockDestructionPacket(multiBlock.getSourceID(), blockPos, this.stage);
                packetsToSend.add(packet);
            }
        }
        finally {
            this.lock.unlock();
        }
        if (!packetsToSend.isEmpty()) {
            for (MultiBlock multiBlock : this.connections) {
                if (multiBlock == null) continue;
                for (ClientboundBlockDestructionPacket packet : packetsToSend) {
                    multiBlock.send((Packet)packet);
                }
            }
        }
    }
}

