/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.multibreak.event;

import java.util.UUID;
import me.vermulst.multibreak.Main;
import me.vermulst.multibreak.api.event.MultiBreakEndEvent;
import me.vermulst.multibreak.figure.Figure;
import me.vermulst.multibreak.multibreak.BreakManager;
import me.vermulst.multibreak.multibreak.MultiBreak;
import me.vermulst.multibreak.utils.BreakUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageAbortEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerAnimationType;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.RayTraceResult;

public class BreakEvents
implements Listener {
    private final BreakManager breakManager;

    public BreakEvents(BreakManager breakManager) {
        this.breakManager = breakManager;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void multiBreakStart(BlockDamageEvent e) {
        ItemStack item;
        Player p = e.getPlayer();
        Figure figure = this.breakManager.getFigure(p, item = e.getItemInHand());
        if (figure == null) {
            return;
        }
        if (p.hasMetadata("static-multibreak")) {
            this.breakManager.scheduleMultiBreak(p, figure, e.getBlock(), true);
            p.removeMetadata("static-multibreak", (Plugin)Main.getInstance());
        } else {
            this.breakManager.scheduleMultiBreak(p, figure, e.getBlock(), false);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void multiBreakStop(BlockDamageAbortEvent e) {
        Player p = e.getPlayer();
        if (!this.breakManager.isBreaking(p.getUniqueId())) {
            return;
        }
        MultiBreak multiBreak = this.breakManager.getMultiBreak(p);
        if (multiBreak != null) {
            MultiBreakEndEvent event = new MultiBreakEndEvent(p, multiBreak, false);
            event.callEvent();
        }
        this.breakManager.endMultiBreak(p, multiBreak, false);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void breakBlockType(BlockBreakEvent e) {
        Player p = e.getPlayer();
        Figure figure = this.breakManager.getFigure(p);
        if (figure == null) {
            return;
        }
        Block block = e.getBlock();
        Location location = block.getLocation();
        if (!this.breakManager.isMultiBreak(e)) {
            if (!this.breakManager.wasMultiBroken(block)) {
                this.breakManager.handleBlockRemoval(location);
            } else {
                this.breakManager.removeMultiBrokenMetadata(block);
            }
            return;
        }
        MultiBreak multiBreak = this.breakManager.getMultiBreak(p);
        if (multiBreak == null) {
            BlockFace blockFace = BreakUtils.getBlockFace(p);
            if (blockFace == null) {
                blockFace = BreakUtils.getThickRaytraceBlockFace(p, block);
            }
            if ((multiBreak = this.breakManager.initMultiBreak(p, block, figure, blockFace)) == null) {
                this.breakManager.handleBlockRemoval(location);
                return;
            }
        }
        if (!block.equals((Object)multiBreak.getBlock())) {
            multiBreak = this.breakManager.initMultiBreak(p, block, figure);
        }
        MultiBreakEndEvent event = new MultiBreakEndEvent(p, multiBreak, true);
        event.callEvent();
        this.breakManager.endMultiBreak(p, event.getMultiBreak(), true);
        this.breakManager.handleBlockRemoval(location);
    }

    @EventHandler
    public void combat(EntityDamageByEntityEvent e) {
        Entity entity = e.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        ItemStack item = p.getInventory().getItemInMainHand();
        Figure figure = this.breakManager.getFigure(p, item);
        if (figure == null) {
            return;
        }
        MultiBreak multiBreak = this.breakManager.getMultiBreakOffstate(p);
        if (multiBreak == null) {
            UUID uuid = p.getUniqueId();
            multiBreak = new MultiBreak(uuid);
            this.breakManager.getMultiBreakMap().put(uuid, multiBreak);
        }
        multiBreak.setEnded(Bukkit.getCurrentTick());
    }

    @EventHandler
    public void mining(PlayerAnimationEvent e) {
        ItemStack item;
        if (!e.getAnimationType().equals((Object)PlayerAnimationType.ARM_SWING)) {
            return;
        }
        Player p = e.getPlayer();
        Figure figure = this.breakManager.getFigure(p, item = p.getInventory().getItemInMainHand());
        if (figure == null) {
            return;
        }
        MultiBreak multiBreak = this.breakManager.getMultiBreak(p);
        if (multiBreak != null) {
            if (multiBreak.isNotStatic()) {
                return;
            }
            RayTraceResult rayTraceResult = BreakUtils.getRayTraceResultExact(p);
            if (rayTraceResult == null) {
                return;
            }
            multiBreak.setLastTick(Bukkit.getCurrentTick());
            return;
        }
        if (this.breakManager.isBreaking(p.getUniqueId())) {
            return;
        }
        MultiBreak multiBreakOffState = this.breakManager.getMultiBreakOffstate(p);
        if (multiBreakOffState == null) {
            return;
        }
        int ended = multiBreakOffState.getEnded();
        if (Bukkit.getCurrentTick() - ended <= 5) {
            return;
        }
        RayTraceResult rayTraceResult = BreakUtils.getRayTraceResultExact(p);
        if (rayTraceResult == null) {
            return;
        }
        Block targetBlock = rayTraceResult.getHitBlock();
        BlockFace face = rayTraceResult.getHitBlockFace();
        p.setMetadata("static-multibreak", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)true));
        BlockDamageEvent blockDamageEvent = new BlockDamageEvent(p, targetBlock, face, item, false);
        blockDamageEvent.callEvent();
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        this.breakManager.onPlayerQuit(p);
    }
}

