/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.multibreak.event;

import java.util.Set;
import java.util.stream.Collectors;
import me.vermulst.multibreak.multibreak.BreakManager;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;

public class BlockDestroyEvents
implements Listener {
    private final BreakManager breakManager;

    public BlockDestroyEvents(BreakManager breakManager) {
        this.breakManager = breakManager;
    }

    @EventHandler
    public void liquidFLowEvent(BlockFromToEvent e) {
        if (e.getToBlock().getType() == Material.AIR) {
            return;
        }
        this.breakManager.handleBlockRemoval(e.getBlock().getLocation());
    }

    @EventHandler
    public void entityChangeBlock(EntityChangeBlockEvent e) {
        if (e.getTo() != Material.AIR) {
            return;
        }
        this.breakManager.handleBlockRemoval(e.getBlock().getLocation());
    }

    @EventHandler
    public void pistonExtend(BlockPistonExtendEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Set<Location> blockLocations = e.getBlocks().stream().map(Block::getLocation).collect(Collectors.toSet());
        this.breakManager.handleBlockRemovals(blockLocations);
    }

    @EventHandler
    public void pistonRetract(BlockPistonRetractEvent e) {
        if (e.isCancelled() || !e.isSticky()) {
            return;
        }
        Set<Location> blockLocations = e.getBlocks().stream().map(Block::getLocation).collect(Collectors.toSet());
        this.breakManager.handleBlockRemovals(blockLocations);
    }
}

