/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.multibreak;

import com.destroystokyo.paper.ParticleBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import me.vermulst.multibreak.Main;
import me.vermulst.multibreak.config.Config;
import me.vermulst.multibreak.figure.Figure;
import me.vermulst.multibreak.multibreak.MultiBlock;
import me.vermulst.multibreak.multibreak.runnables.WriteParticleRunnable;
import me.vermulst.multibreak.multibreak.runnables.WriteStageRunnable;
import me.vermulst.multibreak.utils.BlockFilter;
import me.vermulst.multibreak.utils.IntVector;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class MultiBreak {
    private static final int CHECK_PLAYERS_INTERVAL = 32;
    private static final int PLAY_PARTICLES_INTERVAL = 2;
    private static final double CHECK_PLAYERS_RADIUS = 32.0;
    private final UUID playerUUID;
    private Set<UUID> nearbyPlayers;
    private ServerGamePacketListenerImpl[] nearbyPlayerConnections;
    private Block block;
    private IntVector playerDirection;
    private int progressTicks;
    private float progressBroken;
    private int lastStage = -1;
    private MultiBlock[] multiBlocks;
    private final ReentrantLock packetLock = new ReentrantLock();
    private volatile int ended = -1;
    private boolean paused = false;
    private int lastTick = -1;
    private final Map<Material, Float> destroySpeedCache = new EnumMap<Material, Float>(Material.class);
    private final Map<Material, Boolean> hasCorrectToolCache = new EnumMap<Material, Boolean>(Material.class);
    private final ParticleBuilder particleBuilder = new ParticleBuilder(Particle.BLOCK_CRUMBLE).extra(0.2);
    private final ParticleBuilder breakParticleBuilder = new ParticleBuilder(Particle.BLOCK).count(16).offset(0.5, 0.5, 0.5);
    private boolean isGrounded;
    private boolean isSubmerged;
    private ServerLevel serverLevel;
    private BlockPos blockPos;
    private BlockState blockState;
    private static final Predicate<Entity> isPlayer = nmsEntity -> nmsEntity.getType() == EntityType.PLAYER;

    public MultiBreak(UUID uuid) {
        this.playerUUID = uuid;
    }

    public MultiBreak(Player p, Block block, Vector playerDirection, @NotNull Figure figure, EnumSet<Material> includedMaterials, EnumSet<Material> ignoredMaterials) {
        this.serverLevel = ((CraftWorld)block.getWorld()).getHandle();
        ServerPlayer serverPlayer = ((CraftPlayer)p).getHandle();
        this.blockPos = CraftLocation.toBlockPosition((Location)block.getLocation());
        this.blockState = this.serverLevel.getBlockState(this.blockPos);
        this.isGrounded = p.isOnGround();
        this.isSubmerged = serverPlayer.isEyeInFluid(FluidTags.WATER);
        this.playerUUID = p.getUniqueId();
        this.nearbyPlayers = this.getNearbyPlayerUUIDs(block.getLocation());
        this.updateNearbyPlayerConnections();
        this.updateParticleBuilderReceivers(this.nearbyPlayers);
        this.block = block;
        this.playerDirection = IntVector.of(playerDirection);
        this.initBlocks(p, figure, playerDirection, includedMaterials, ignoredMaterials);
        this.progressBroken = this.getDestroySpeedMain(serverPlayer);
    }

    public void reset(Player p, Block block, Vector playerDirection, @NotNull Figure figure, EnumSet<Material> includedMaterials, EnumSet<Material> ignoredMaterials) {
        this.serverLevel = ((CraftWorld)block.getWorld()).getHandle();
        ServerPlayer serverPlayer = ((CraftPlayer)p).getHandle();
        this.blockPos = CraftLocation.toBlockPosition((Location)block.getLocation());
        this.blockState = this.serverLevel.getBlockState(this.blockPos);
        this.isGrounded = p.isOnGround();
        this.isSubmerged = serverPlayer.isEyeInFluid(FluidTags.WATER);
        this.nearbyPlayers = this.getNearbyPlayerUUIDs(block.getLocation());
        this.updateNearbyPlayerConnections();
        this.updateParticleBuilderReceivers(this.nearbyPlayers);
        this.progressTicks = 0;
        this.ended = -1;
        this.block = block;
        this.playerDirection = IntVector.of(playerDirection);
        this.initBlocks(p, figure, playerDirection, includedMaterials, ignoredMaterials);
        this.progressBroken = this.getDestroySpeedMain(serverPlayer);
        this.lastStage = -1;
        this.paused = false;
    }

    public float getDestroySpeedMain(Player p) {
        ServerPlayer serverPlayer = ((CraftPlayer)p).getHandle();
        return this.getDestroySpeedMain(serverPlayer);
    }

    public float getDestroySpeedMain(ServerPlayer serverPlayer) {
        return this.getDestroySpeed(serverPlayer, this.blockPos, this.blockState);
    }

    public float getDestroySpeed(ServerPlayer serverPlayer, BlockPos blockPos) {
        BlockState blockState = this.serverLevel.getBlockState(blockPos);
        return this.getDestroySpeed(serverPlayer, blockPos, blockState);
    }

    public float getDestroySpeed(ServerPlayer serverPlayer, BlockPos blockPos, BlockState blockState) {
        Material material = blockState.getBukkitMaterial();
        if (this.destroySpeedCache.containsKey(material)) {
            return this.destroySpeedCache.get(material).floatValue();
        }
        float destroySpeed = blockState.getDestroySpeed((BlockGetter)this.serverLevel, blockPos);
        if (destroySpeed == -1.0f) {
            return 0.0f;
        }
        float baseSpeed = serverPlayer.getDestroySpeed(blockState);
        boolean hasCorrectTool = this.hasCorrectToolCache.computeIfAbsent(material, mat -> serverPlayer.hasCorrectToolForDrops(blockState));
        int factor = hasCorrectTool ? 30 : 100;
        float finalSpeed = baseSpeed / destroySpeed / (float)factor;
        this.destroySpeedCache.put(material, Float.valueOf(finalSpeed));
        return finalSpeed;
    }

    public void initBlocks(Player p, @NotNull Figure figure, Vector blockFaceDirection, EnumSet<Material> includedMaterials, EnumSet<Material> ignoredMaterials) {
        boolean fairMode = Config.getInstance().isFairModeEnabled();
        ServerPlayer serverPlayer = ((CraftPlayer)p).getHandle();
        float mainBlockProgressPerTick = this.getDestroySpeed(serverPlayer, this.blockPos);
        Set<Block> blocks = figure.getBlocks(p, this.getBlock(), blockFaceDirection);
        HashSet<MultiBlock> multiBlocks = new HashSet<MultiBlock>(blocks.size());
        int uuidHash = this.playerUUID.hashCode();
        int worldHash = this.block.getWorld().getUID().hashCode();
        int baseHash = MultiBreak.getBaseHash(uuidHash, worldHash);
        for (Block block : blocks) {
            Material material = block.getType();
            if (BlockFilter.isExcluded(material, includedMaterials, ignoredMaterials)) continue;
            int sourceID = MultiBreak.getSourceID(baseHash, block.getX(), block.getY(), block.getZ());
            MultiBlock multiBlock = new MultiBlock(block, sourceID);
            BlockPos blockPos = CraftLocation.toBlockPosition((Location)block.getLocation());
            float blockProgressPerTick = this.getDestroySpeed(serverPlayer, blockPos);
            if (blockProgressPerTick == Float.POSITIVE_INFINITY) {
                multiBlock.setVisible(false);
            } else if (fairMode && mainBlockProgressPerTick == Float.POSITIVE_INFINITY) continue;
            multiBlocks.add(multiBlock);
        }
        this.multiBlocks = multiBlocks.toArray(new MultiBlock[0]);
    }

    public void tick() {
        Player p = this.getPlayer();
        if (p == null) {
            this.end(p, false);
            return;
        }
        this.checkPause();
        if (this.paused) {
            return;
        }
        ++this.progressTicks;
        if ((this.progressTicks & 0x1F) == 0) {
            this.checkPlayers();
        }
        this.checkDestroySpeedChange(p);
        MultiBlock[] multiBlockSnapshot = this.getMultiBlockSnapshot();
        if ((this.progressTicks & 1) == 0) {
            this.playParticles(multiBlockSnapshot);
        }
        this.updateBlockAnimationPacket(p, multiBlockSnapshot);
    }

    public void checkPause() {
        if (this.isNotStatic()) {
            return;
        }
        int currentTick = Bukkit.getServer().getCurrentTick();
        this.paused = currentTick - this.lastTick > 1;
    }

    public void checkDestroySpeedChange(Player p) {
        boolean isGrounded = p.isOnGround();
        boolean isSubmerged = ((CraftPlayer)p).getHandle().isEyeInFluid(FluidTags.WATER);
        if (isGrounded != this.isGrounded || isSubmerged != this.isSubmerged) {
            this.isGrounded = isGrounded;
            this.isSubmerged = isSubmerged;
            this.invalidateDestroySpeedCache();
        }
    }

    public void end(Player p, boolean finished) {
        this.ended = finished ? Bukkit.getCurrentTick() : 0;
        MultiBlock[] multiBlockSnapshot = this.getMultiBlockSnapshot();
        this.writeStage(-1, multiBlockSnapshot);
        if (!finished) {
            return;
        }
        boolean playSound = p.getPing() < Config.getInstance().getPlaySoundPingTreshold();
        int size = multiBlockSnapshot.length - 1;
        World world = playSound ? this.getBlock().getWorld() : null;
        float volume = playSound ? (float)(1.0 / Math.log((double)(size + 1) * Math.E)) : 0.0f;
        EnumMap<Material, BlockData> blockDataCache = new EnumMap<Material, BlockData>(Material.class);
        for (MultiBlock multiBlock : multiBlockSnapshot) {
            Block block = multiBlock.getBlock();
            Material blockType = block.getType();
            if (Config.getInstance().getIgnoredMaterials().contains(blockType)) continue;
            block.setMetadata("multi-broken", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)true));
            BlockData blockData = blockDataCache.computeIfAbsent(block.getType(), Material::createBlockData);
            Location location = block.getLocation();
            boolean broken = p.breakBlock(block);
            if (!broken) continue;
            if (playSound) {
                world.playSound(location, blockData.getSoundGroup().getBreakSound(), volume, 1.0f);
            }
            if (!multiBlock.isVisible()) continue;
            this.breakParticleBuilder.location(location.add(0.5, 0.5, 0.5)).data((Object)blockData).spawn();
        }
    }

    public void updateBlockAnimationPacket(Player p, MultiBlock[] multiBlockSnapshot) {
        float breakSpeed = this.getDestroySpeedMain(p);
        this.progressBroken += breakSpeed;
        this.progressBroken = Math.min(this.progressBroken, 1.0f);
        this.progressBroken = Math.max(this.progressBroken, 0.0f);
        float tickDelay = (float)p.getPing() / 50.0f;
        float adjustedProgress = this.progressBroken + tickDelay * breakSpeed;
        adjustedProgress = Math.min(adjustedProgress, 1.0f);
        int stage = (int)(9.0f * adjustedProgress);
        if (this.lastStage == -1 || stage > this.lastStage) {
            this.writeStage(stage, multiBlockSnapshot);
            this.lastStage = stage;
        }
    }

    public void writeStage(int stage, MultiBlock[] multiBlockSnapshot) {
        WriteStageRunnable writeStageRunnable = new WriteStageRunnable(multiBlockSnapshot, this.getBlock(), stage, this.nearbyPlayerConnections, this.packetLock, this);
        Main.getHighPriorityExecutor().submit((Runnable)((Object)writeStageRunnable));
    }

    public void checkPlayers() {
        Set<UUID> oldNearbyPlayers = this.nearbyPlayers;
        Location blockLoc = this.block.getLocation();
        Set<UUID> newNearbyPlayers = this.getNearbyPlayerUUIDs(blockLoc);
        this.nearbyPlayers.addAll(newNearbyPlayers);
        if (newNearbyPlayers.size() != oldNearbyPlayers.size()) {
            this.nearbyPlayers = newNearbyPlayers;
            this.updateNearbyPlayerConnections();
            this.updateParticleBuilderReceivers(this.nearbyPlayers);
        }
    }

    private void updateParticleBuilderReceivers(Set<UUID> playerUUIDs) {
        ArrayList<Player> onlinePlayers = new ArrayList<Player>(playerUUIDs.size());
        for (UUID uuid : playerUUIDs) {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null || player.getName().startsWith(".") || !player.isOnline()) continue;
            onlinePlayers.add(player);
        }
        this.particleBuilder.receivers(onlinePlayers);
    }

    public boolean isValid(EnumSet<Material> includedMaterials, EnumSet<Material> excludedMaterials) {
        Material mainBlockType = this.getBlock().getType();
        if (includedMaterials != null && !includedMaterials.isEmpty() && !includedMaterials.contains(mainBlockType)) {
            return false;
        }
        return excludedMaterials == null || excludedMaterials.isEmpty() || !excludedMaterials.contains(mainBlockType);
    }

    public void playParticles(MultiBlock[] multiBlocksSnapshot) {
        boolean playerDirectionX = this.playerDirection.x() == 1;
        boolean playerDirectionY = this.playerDirection.y() == 1;
        boolean playerDirectionZ = this.playerDirection.z() == 1;
        double offsetX = 0.45;
        double offsetY = 0.45;
        double offsetZ = 0.45;
        if (playerDirectionX) {
            offsetX = 0.0;
        }
        if (playerDirectionY) {
            offsetY = 0.0;
        }
        if (playerDirectionZ) {
            offsetZ = 0.0;
        }
        this.particleBuilder.offset(offsetX, offsetY, offsetZ);
        double sideOffsetX = playerDirectionX ? 0.5 : 0.0;
        double sideOffsetY = playerDirectionY ? 0.5 : 0.0;
        double sideOffsetZ = playerDirectionZ ? 0.5 : 0.0;
        Location loc = new Location(this.getBlock().getWorld(), 0.0, 0.0, 0.0);
        WriteParticleRunnable writeParticleRunnable = new WriteParticleRunnable(multiBlocksSnapshot, this.getBlock(), this.particleBuilder, sideOffsetX, sideOffsetY, sideOffsetZ, loc);
        Main.getHighPriorityExecutor().submit((Runnable)((Object)writeParticleRunnable));
    }

    public Set<UUID> getNearbyPlayerUUIDs(Location blockLoc) {
        HashSet<UUID> uuids = new HashSet<UUID>();
        double x = blockLoc.getX();
        double y = blockLoc.getY();
        double z = blockLoc.getZ();
        AABB aabb = new AABB(x - 32.0, y - 32.0, z - 32.0, x + 32.0, y + 32.0, z + 32.0);
        List entityList = this.serverLevel.getEntities((Entity)null, aabb, isPlayer);
        for (Entity entity : entityList) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            uuids.add(serverPlayer.getUUID());
        }
        return uuids;
    }

    public void updateNearbyPlayerConnections() {
        ServerGamePacketListenerImpl[] connections = new ServerGamePacketListenerImpl[this.nearbyPlayers.size()];
        int index = 0;
        for (UUID uuid : this.nearbyPlayers) {
            Player p = Bukkit.getPlayer((UUID)uuid);
            if (p == null) continue;
            connections[index++] = ((CraftPlayer)p).getHandle().connection;
        }
        this.nearbyPlayerConnections = connections;
    }

    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.playerUUID);
    }

    public Block[] getBlocks() {
        MultiBlock[] multiBlocks = this.getMultiBlocks();
        Block[] blocks = new Block[multiBlocks.length];
        for (int i = 0; i < multiBlocks.length; ++i) {
            blocks[i] = multiBlocks[i].getBlock();
        }
        return blocks;
    }

    public Block getBlock() {
        return this.block;
    }

    public int getProgressTicks() {
        return this.progressTicks;
    }

    public MultiBlock[] getMultiBlocks() {
        return this.multiBlocks;
    }

    public float getProgressBroken() {
        return this.progressBroken;
    }

    public Set<UUID> getNearbyPlayers() {
        return this.nearbyPlayers;
    }

    public IntVector getPlayerDirection() {
        return this.playerDirection;
    }

    public boolean hasEnded() {
        return this.ended != -1;
    }

    public int getEnded() {
        return this.ended;
    }

    public void setEnded(int ended) {
        this.ended = ended;
    }

    public boolean isNotStatic() {
        return this.lastTick == -1;
    }

    public void setProgressTicks(int progressTicks) {
        this.progressTicks = progressTicks;
    }

    public void setProgressBroken(float progressBroken) {
        this.progressBroken = progressBroken;
    }

    public void setLastTick(int lastTick) {
        this.lastTick = lastTick;
    }

    public String toString() {
        return "MultiBreak{p=" + String.valueOf(this.getPlayer()) + ", block=" + String.valueOf(this.block) + ", progressTicks=" + this.progressTicks + ", multiBlocks=" + String.valueOf(this.multiBlocks) + ", ended=" + this.ended + "}";
    }

    public MultiBlock[] getMultiBlockSnapshot() {
        return (MultiBlock[])Arrays.stream(this.multiBlocks).filter(Objects::nonNull).toArray(MultiBlock[]::new);
    }

    public void invalidateDestroySpeedCache() {
        this.destroySpeedCache.clear();
    }

    public void invalidateHasCorrectToolCache() {
        this.hasCorrectToolCache.clear();
    }

    private static int getBaseHash(int uuidHash, int worldHash) {
        int hash = 17;
        hash = 31 * hash + uuidHash;
        hash = 31 * hash + worldHash;
        return hash;
    }

    private static int getSourceID(int baseHash, int x, int y, int z) {
        int hash = baseHash;
        hash = 31 * hash + x;
        hash = 31 * hash + y;
        hash = 31 * hash + z;
        return hash;
    }
}

