/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.multibreak;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.vermulst.multibreak.Main;
import me.vermulst.multibreak.api.event.FetchFigureEvent;
import me.vermulst.multibreak.api.event.FilterBlocksEvent;
import me.vermulst.multibreak.api.event.MultiBreakStartEvent;
import me.vermulst.multibreak.config.Config;
import me.vermulst.multibreak.figure.Figure;
import me.vermulst.multibreak.item.FigureItemDataType;
import me.vermulst.multibreak.multibreak.MultiBlock;
import me.vermulst.multibreak.multibreak.MultiBreak;
import me.vermulst.multibreak.multibreak.runnables.MultiBreakRunnable;
import me.vermulst.multibreak.utils.BlockFilter;
import me.vermulst.multibreak.utils.BreakUtils;
import net.kyori.adventure.key.Key;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.RayTraceResult;
import org.jetbrains.annotations.NotNull;

public class BreakManager {
    private final Map<UUID, Integer> movedPlayers = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> multiBreakTask = new HashMap<UUID, Integer>();
    private final Map<UUID, Figure> figureCache = new HashMap<UUID, Figure>();
    private final Map<UUID, Block> lastTargetBlock = new HashMap<UUID, Block>();
    private final Map<UUID, MultiBreak> multiBreakMap = new HashMap<UUID, MultiBreak>();
    private final Map<Location, Set<MultiBreak>> multiBreakLocationMap = new HashMap<Location, Set<MultiBreak>>();
    private static final BreakManager breakManager = new BreakManager();

    public static BreakManager getInstance() {
        return breakManager;
    }

    public void refreshTool(final Player p) {
        boolean fairMode = Config.getInstance().isFairModeEnabled();
        if (!fairMode) {
            return;
        }
        final UUID uuid = p.getUniqueId();
        final Figure previousFigure = this.figureCache.remove(uuid);
        new BukkitRunnable(){

            public void run() {
                Figure newFigure = BreakManager.this.getFigure(p);
                if (newFigure != null && newFigure.equals(previousFigure)) {
                    return;
                }
                BreakManager.this.lastTargetBlock.remove(uuid);
                BreakManager.this.refreshBreakSpeed(p, newFigure);
                BreakUtils.interactionRangeCache.remove(uuid);
            }
        }.runTaskLater((Plugin)Main.getInstance(), 1L);
    }

    public void refreshBreakSpeed(Player p) {
        Figure figure = this.getFigure(p);
        this.refreshBreakSpeed(p, figure);
    }

    public void refreshBreakSpeed(Player p, Figure figure) {
        UUID uuid = p.getUniqueId();
        AttributeInstance attribute = p.getAttribute(Attribute.BLOCK_BREAK_SPEED);
        AttributeModifier modifierToRemove = attribute.getModifier((Key)new NamespacedKey((Plugin)Main.getInstance(), "MultiBreakSlowdown"));
        if (figure == null) {
            this.removeModifier(attribute, modifierToRemove);
            this.invalidateDestroySpeedCache(uuid);
            return;
        }
        RayTraceResult rayTraceResult = BreakUtils.getRayTraceResult(p);
        if (rayTraceResult == null) {
            this.removeModifier(attribute, modifierToRemove);
            this.invalidateDestroySpeedCache(uuid);
            return;
        }
        Block targetBlock = rayTraceResult.getHitBlock();
        if (targetBlock == null) {
            this.removeModifier(attribute, modifierToRemove);
            this.invalidateDestroySpeedCache(uuid);
            return;
        }
        if (this.lastTargetBlock.containsKey(uuid) && targetBlock.equals((Object)this.lastTargetBlock.get(uuid))) {
            return;
        }
        this.lastTargetBlock.put(uuid, targetBlock);
        this.removeModifier(attribute, modifierToRemove);
        this.invalidateDestroySpeedCache(uuid);
        Config config = Config.getInstance();
        EnumSet<Material> includedMaterials = config.getIncludedMaterials();
        EnumSet<Material> ignoredMaterials = config.getIgnoredMaterials();
        FilterBlocksEvent filterBlocksEvent = new FilterBlocksEvent(figure, p, p.getInventory().getItemInMainHand(), includedMaterials, ignoredMaterials);
        filterBlocksEvent.callEvent();
        Set<Block> blocks = figure.getBlocks(p, targetBlock, rayTraceResult.getHitBlockFace().getDirection());
        this.filter(blocks, filterBlocksEvent.getIncludedMaterials(), filterBlocksEvent.getExcludedMaterials());
        MultiBreak multiBreak = this.getMultiBreak(p);
        float baseProgressPerTick = BreakUtils.getDestroySpeed(p, multiBreak);
        if (baseProgressPerTick == -1.0f) {
            baseProgressPerTick = targetBlock.getBreakSpeed(p);
        }
        if (baseProgressPerTick == Float.POSITIVE_INFINITY) {
            return;
        }
        MultiBreak multiBreakOffState = this.getMultiBreakOffstate(p);
        float slowDownFactor = this.getSlowDownFactor(p, blocks, baseProgressPerTick, multiBreakOffState);
        this.invalidateDestroySpeedCache(uuid);
        if (slowDownFactor == 1.0f) {
            return;
        }
        double currentAttributeTotal = p.getAttribute(Attribute.BLOCK_BREAK_SPEED).getValue();
        double newAttributeTotal = currentAttributeTotal * (double)slowDownFactor;
        double modifier = -(currentAttributeTotal - newAttributeTotal);
        this.setModifier(attribute, modifier);
    }

    private void removeModifier(AttributeInstance attribute, AttributeModifier modifier) {
        if (modifier != null) {
            attribute.removeModifier(modifier);
        }
    }

    private void invalidateDestroySpeedCache(UUID uuid) {
        if (this.multiBreakMap.containsKey(uuid)) {
            MultiBreak multiBreak = this.multiBreakMap.get(uuid);
            multiBreak.invalidateDestroySpeedCache();
        }
    }

    private void setModifier(AttributeInstance attribute, double newValue) {
        AttributeModifier newModifier = new AttributeModifier(new NamespacedKey((Plugin)Main.getInstance(), "MultiBreakSlowdown"), newValue, AttributeModifier.Operation.ADD_NUMBER);
        attribute.addModifier(newModifier);
    }

    public void scheduleMultiBreak(Player p, @NotNull Figure figure, Block block, boolean isStaticBreak) {
        MultiBreak multiBreakOffState;
        if (this.multiBreakTask.containsKey(p.getUniqueId())) {
            this.endMultiBreak(p, this.getMultiBreak(p), false);
        }
        if ((multiBreakOffState = this.getMultiBreakOffstate(p)) != null && !isStaticBreak) {
            multiBreakOffState.setLastTick(-1);
        }
        MultiBreakRunnable multiBreakRunnable = new MultiBreakRunnable(p, block, figure, this, isStaticBreak);
        int taskID = multiBreakRunnable.runTaskTimer((Plugin)Main.getInstance(), 1L, 1L).getTaskId();
        this.multiBreakTask.put(p.getUniqueId(), taskID);
    }

    public void endMultiBreak(Player p, MultiBreak multiBreak, boolean finished) {
        UUID uuid = p.getUniqueId();
        if (multiBreak != null) {
            multiBreak.end(p, finished);
            if (!finished) {
                for (MultiBlock multiBlock : multiBreak.getMultiBlocks()) {
                    Location location;
                    if (multiBlock == null || !this.multiBreakLocationMap.containsKey(location = multiBlock.getLocation())) continue;
                    Set<MultiBreak> multiBreaks = this.multiBreakLocationMap.get(location);
                    multiBreaks.remove(multiBreak);
                    if (!multiBreaks.isEmpty()) continue;
                    this.multiBreakLocationMap.remove(location);
                }
            }
        }
        if (!this.multiBreakTask.containsKey(uuid)) {
            return;
        }
        Bukkit.getScheduler().cancelTask(this.multiBreakTask.get(uuid).intValue());
        this.multiBreakTask.remove(uuid);
        breakManager.getMovedPlayers().remove(uuid);
    }

    public MultiBreak initMultiBreak(Player p, Block block, @NotNull Figure figure) {
        if (block == null) {
            return null;
        }
        BlockFace blockFace = BreakUtils.getBlockFace(p);
        return this.initMultiBreak(p, block, figure, blockFace);
    }

    public MultiBreak initMultiBreak(Player p, Block block, @NotNull Figure figure, BlockFace blockFace) {
        MultiBlock[] multiBlocks;
        if (blockFace == null) {
            return null;
        }
        Config config = Config.getInstance();
        EnumSet<Material> includedMaterials = config.getIncludedMaterials();
        EnumSet<Material> ignoredMaterials = config.getIgnoredMaterials();
        FilterBlocksEvent filterBlocksEvent = new FilterBlocksEvent(figure, p, p.getInventory().getItemInMainHand(), includedMaterials, ignoredMaterials);
        filterBlocksEvent.callEvent();
        includedMaterials = filterBlocksEvent.getIncludedMaterials();
        ignoredMaterials = filterBlocksEvent.getExcludedMaterials();
        MultiBreak multiBreak = this.multiBreakMap.get(p.getUniqueId());
        if (multiBreak != null) {
            multiBreak.reset(p, block, blockFace.getDirection(), figure, includedMaterials, ignoredMaterials);
        } else {
            multiBreak = new MultiBreak(p, block, blockFace.getDirection(), figure, includedMaterials, ignoredMaterials);
            this.multiBreakMap.put(p.getUniqueId(), multiBreak);
        }
        MultiBreakStartEvent event = new MultiBreakStartEvent(p, multiBreak, block);
        if (!event.callEvent()) {
            return null;
        }
        multiBreak = event.getMultiBreak();
        if (!multiBreak.isValid(includedMaterials, ignoredMaterials)) {
            return null;
        }
        for (MultiBlock mb : multiBlocks = multiBreak.getMultiBlocks()) {
            if (mb == null) continue;
            Location location = mb.getLocation();
            this.multiBreakLocationMap.computeIfAbsent(location, k -> new HashSet(multiBlocks.length)).add(multiBreak);
        }
        return multiBreak;
    }

    public boolean wasMultiBroken(Block block) {
        return block.hasMetadata("multi-broken");
    }

    public void removeMultiBrokenMetadata(Block block) {
        block.removeMetadata("multi-broken", (Plugin)Main.getInstance());
    }

    public boolean isMultiBreak(BlockBreakEvent e) {
        Block block = e.getBlock();
        boolean wasMultiBroken = block.hasMetadata("multi-broken");
        boolean isIgnoredMaterial = Config.getInstance().getIgnoredMaterials().contains(block.getType());
        boolean isCancelled = e.isCancelled();
        return !wasMultiBroken && !isIgnoredMaterial && !isCancelled;
    }

    public void filter(Set<Block> blocks, EnumSet<Material> includedMaterials, EnumSet<Material> ignoredMaterials) {
        blocks.removeIf(block -> {
            Material mainBlockType = block.getType();
            return BlockFilter.isExcluded(mainBlockType, includedMaterials, ignoredMaterials);
        });
    }

    public float getSlowDownFactor(Player p, Set<Block> blocks, float baseProgressPerTick, MultiBreak multiBreak) {
        float lowestProgressPerTick = baseProgressPerTick;
        if (multiBreak != null) {
            ServerPlayer serverPlayer = ((CraftPlayer)p).getHandle();
            for (Block block : blocks) {
                BlockPos blockPos = CraftLocation.toBlockPosition((Location)block.getLocation());
                float progressPerTick = BreakUtils.getDestroySpeed(serverPlayer, blockPos, multiBreak);
                if (!(progressPerTick < lowestProgressPerTick)) continue;
                lowestProgressPerTick = progressPerTick;
            }
        } else {
            for (Block block : blocks) {
                float progressPerTick = block.getBreakSpeed(p);
                if (!(progressPerTick < lowestProgressPerTick)) continue;
                lowestProgressPerTick = progressPerTick;
            }
        }
        return lowestProgressPerTick / baseProgressPerTick;
    }

    public Figure getFigure(Player p) {
        ItemStack tool = p.getInventory().getItemInMainHand();
        return this.getFigure(p, tool);
    }

    public Figure getFigure(Player p, ItemStack tool) {
        if (this.figureCache.containsKey(p.getUniqueId())) {
            return this.figureCache.get(p.getUniqueId());
        }
        if (tool.getItemMeta() == null) {
            this.figureCache.put(p.getUniqueId(), null);
            return null;
        }
        FigureItemDataType figureItemDataType = new FigureItemDataType();
        Figure figure = figureItemDataType.get(tool);
        if (figure == null) {
            Material material = tool.getType();
            Config config = Config.getInstance();
            if (config.getMaterialOptions().containsKey(material)) {
                String configOptionName = config.getMaterialOptions().get(material);
                figure = config.getConfigOptions().get(configOptionName);
            }
        }
        FetchFigureEvent fetchFigureEvent = new FetchFigureEvent(figure, p, tool);
        fetchFigureEvent.callEvent();
        if (fetchFigureEvent.isCancelled()) {
            this.figureCache.put(p.getUniqueId(), null);
            return null;
        }
        figure = fetchFigureEvent.getFigure();
        this.figureCache.put(p.getUniqueId(), figure);
        return figure;
    }

    public MultiBreak getMultiBreak(Player p) {
        MultiBreak multiBreak;
        if (this.multiBreakMap.containsKey(p.getUniqueId()) && !(multiBreak = this.multiBreakMap.get(p.getUniqueId())).hasEnded()) {
            return multiBreak;
        }
        return null;
    }

    public MultiBreak getMultiBreakOffstate(Player p) {
        return this.multiBreakMap.get(p.getUniqueId());
    }

    public void onPlayerQuit(Player p) {
        this.endMultiBreak(p, this.getMultiBreak(p), false);
        UUID uuid = p.getUniqueId();
        this.figureCache.remove(uuid);
        this.lastTargetBlock.remove(uuid);
        this.multiBreakMap.remove(uuid);
        this.movedPlayers.remove(uuid);
        BreakUtils.interactionRangeCache.remove(uuid);
    }

    public void handleBlockRemoval(Location location) {
        if (!this.multiBreakLocationMap.containsKey(location)) {
            return;
        }
        Set<MultiBreak> multiBreaks = this.multiBreakLocationMap.get(location);
        block0: for (MultiBreak multiBreak : multiBreaks) {
            MultiBlock[] multiBlocks = multiBreak.getMultiBlocks();
            for (int i = 0; i < multiBlocks.length; ++i) {
                MultiBlock multiBlock = multiBreak.getMultiBlocks()[i];
                if (multiBlock == null || !multiBlock.getLocation().equals((Object)location)) continue;
                multiBreak.writeStage(-1, new MultiBlock[]{multiBlock});
                multiBlocks[i] = null;
                continue block0;
            }
        }
    }

    public void handleBlockRemovals(Set<Location> locations) {
        HashSet<MultiBreak> breaksToUpdate = new HashSet<MultiBreak>();
        for (Location location : locations) {
            Set<MultiBreak> linkedBreaks = this.multiBreakLocationMap.get(location);
            if (linkedBreaks == null) continue;
            breaksToUpdate.addAll(linkedBreaks);
        }
        for (MultiBreak multiBreak : breaksToUpdate) {
            MultiBlock[] multiBlocks = multiBreak.getMultiBlocks();
            int removeCount = 0;
            for (MultiBlock multiBlock : multiBlocks) {
                if (multiBlock == null || !locations.contains(multiBlock.getLocation())) continue;
                ++removeCount;
            }
            if (removeCount <= 0) continue;
            MultiBlock[] toRemove = new MultiBlock[removeCount];
            int idx = 0;
            for (int i = 0; i < multiBlocks.length; ++i) {
                if (multiBlocks[i] == null || !locations.contains(multiBlocks[i].getLocation())) continue;
                toRemove[idx++] = multiBlocks[i];
                multiBlocks[i] = null;
            }
            multiBreak.writeStage(-1, toRemove);
        }
    }

    public boolean isBreaking(UUID uuid) {
        return this.multiBreakTask.containsKey(uuid);
    }

    public Set<UUID> getBreakingPlayers() {
        return this.multiBreakTask.keySet();
    }

    public Map<UUID, Integer> getMovedPlayers() {
        return this.movedPlayers;
    }

    public Map<UUID, MultiBreak> getMultiBreakMap() {
        return this.multiBreakMap;
    }
}

