/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.item;

import io.papermc.paper.persistence.PersistentDataContainerView;
import me.vermulst.multibreak.Main;
import me.vermulst.multibreak.figure.Figure;
import me.vermulst.multibreak.figure.types.FigureType;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class FigureItemDataType
implements PersistentDataType<PersistentDataContainer, Figure> {
    private static final NamespacedKey KEY_WIDTH = new NamespacedKey((Plugin)Main.getInstance(), "width");
    private static final NamespacedKey KEY_HEIGHT = new NamespacedKey((Plugin)Main.getInstance(), "height");
    private static final NamespacedKey KEY_DEPTH = new NamespacedKey((Plugin)Main.getInstance(), "depth");
    private static final NamespacedKey KEY_WIDTH_ROTATION = new NamespacedKey((Plugin)Main.getInstance(), "widthR");
    private static final NamespacedKey KEY_HEIGHT_ROTATION = new NamespacedKey((Plugin)Main.getInstance(), "heightR");
    private static final NamespacedKey KEY_DEPTH_ROTATION = new NamespacedKey((Plugin)Main.getInstance(), "depthR");
    private static final NamespacedKey KEY_WIDTH_OFFSET = new NamespacedKey((Plugin)Main.getInstance(), "widthO");
    private static final NamespacedKey KEY_HEIGHT_OFFSET = new NamespacedKey((Plugin)Main.getInstance(), "heightO");
    private static final NamespacedKey KEY_DEPTH_OFFSET = new NamespacedKey((Plugin)Main.getInstance(), "depthO");
    private static final NamespacedKey KEY_TYPE_ID = new NamespacedKey((Plugin)Main.getInstance(), "type_id");
    private static final NamespacedKey KEY_FIGURE_INFO = new NamespacedKey((Plugin)Main.getInstance(), "figure_info");
    public Figure figure;

    public ItemStack set(ItemStack itemStack, Figure figure) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        PersistentDataContainer customItemTagContainer = itemMeta.getPersistentDataContainer();
        customItemTagContainer.set(KEY_FIGURE_INFO, (PersistentDataType)this, (Object)figure);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public Figure get(ItemStack itemStack) {
        PersistentDataContainerView customItemTagContainer = itemStack.getPersistentDataContainer();
        Figure figure = (Figure)customItemTagContainer.get(KEY_FIGURE_INFO, (PersistentDataType)this);
        if (figure != null) {
            return figure;
        }
        LegacyFigureItemDataType legacyType = new LegacyFigureItemDataType();
        FigureItemInfo oldInfo = (FigureItemInfo)customItemTagContainer.get(KEY_FIGURE_INFO, (PersistentDataType)legacyType);
        if (oldInfo != null) {
            ItemMeta meta = itemStack.getItemMeta();
            if (meta == null) {
                return null;
            }
            figure = oldInfo.figure();
            PersistentDataContainer customItemTagContainerMeta = meta.getPersistentDataContainer();
            customItemTagContainerMeta.remove(KEY_FIGURE_INFO);
            itemStack.setItemMeta(meta);
            this.set(itemStack, figure);
            return figure;
        }
        return null;
    }

    public ItemStack remove(ItemStack itemStack) {
        NamespacedKey key = new NamespacedKey((Plugin)Main.getInstance(), "figure_info");
        ItemMeta itemMeta = itemStack.getItemMeta();
        PersistentDataContainer customItemTagContainer = itemMeta.getPersistentDataContainer();
        customItemTagContainer.remove(key);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public boolean has(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer customItemTagContainer = meta.getPersistentDataContainer();
        return customItemTagContainer.has(KEY_FIGURE_INFO, PersistentDataType.TAG_CONTAINER);
    }

    @NotNull
    public Class<PersistentDataContainer> getPrimitiveType() {
        return PersistentDataContainer.class;
    }

    @NotNull
    public Class<Figure> getComplexType() {
        return Figure.class;
    }

    @NotNull
    public PersistentDataContainer toPrimitive(Figure figureInfo, PersistentDataAdapterContext persistentDataAdapterContext) {
        PersistentDataContainer persistentDataContainer = persistentDataAdapterContext.newPersistentDataContainer();
        persistentDataContainer.set(KEY_WIDTH, PersistentDataType.INTEGER, (Object)figureInfo.getWidth());
        persistentDataContainer.set(KEY_HEIGHT, PersistentDataType.INTEGER, (Object)figureInfo.getHeight());
        persistentDataContainer.set(KEY_DEPTH, PersistentDataType.INTEGER, (Object)figureInfo.getDepth());
        if (figureInfo.getRotationWidth() != 0) {
            persistentDataContainer.set(KEY_WIDTH_ROTATION, PersistentDataType.SHORT, (Object)figureInfo.getRotationWidth());
        }
        if (figureInfo.getRotationHeight() != 0) {
            persistentDataContainer.set(KEY_HEIGHT_ROTATION, PersistentDataType.SHORT, (Object)figureInfo.getRotationHeight());
        }
        if (figureInfo.getRotationDepth() != 0) {
            persistentDataContainer.set(KEY_DEPTH_ROTATION, PersistentDataType.SHORT, (Object)figureInfo.getRotationDepth());
        }
        if (figureInfo.getOffSetWidth() != 0) {
            persistentDataContainer.set(KEY_WIDTH_OFFSET, PersistentDataType.INTEGER, (Object)figureInfo.getOffSetWidth());
        }
        if (figureInfo.getOffSetHeight() != 0) {
            persistentDataContainer.set(KEY_HEIGHT_OFFSET, PersistentDataType.INTEGER, (Object)figureInfo.getOffSetHeight());
        }
        if (figureInfo.getOffSetDepth() != 0) {
            persistentDataContainer.set(KEY_DEPTH_OFFSET, PersistentDataType.INTEGER, (Object)figureInfo.getOffSetDepth());
        }
        persistentDataContainer.set(KEY_TYPE_ID, PersistentDataType.INTEGER, (Object)figureInfo.getFigureType().ordinal());
        return persistentDataContainer;
    }

    @NotNull
    public Figure fromPrimitive(PersistentDataContainer persistentDataContainer, @NotNull PersistentDataAdapterContext persistentDataAdapterContext) {
        int width = (Integer)persistentDataContainer.getOrDefault(KEY_WIDTH, PersistentDataType.INTEGER, (Object)3);
        int height = (Integer)persistentDataContainer.getOrDefault(KEY_HEIGHT, PersistentDataType.INTEGER, (Object)3);
        int depth = (Integer)persistentDataContainer.getOrDefault(KEY_DEPTH, PersistentDataType.INTEGER, (Object)1);
        int figureTypeOrdinal = (Integer)persistentDataContainer.getOrDefault(KEY_TYPE_ID, PersistentDataType.INTEGER, (Object)0);
        FigureType figureType = FigureType.values()[figureTypeOrdinal];
        Figure figure = figureType.build(width, height, depth);
        short widthR = (Short)persistentDataContainer.getOrDefault(KEY_WIDTH_ROTATION, PersistentDataType.SHORT, (Object)0);
        short heightR = (Short)persistentDataContainer.getOrDefault(KEY_HEIGHT_ROTATION, PersistentDataType.SHORT, (Object)0);
        short depthR = (Short)persistentDataContainer.getOrDefault(KEY_DEPTH_ROTATION, PersistentDataType.SHORT, (Object)0);
        int widthO = (Integer)persistentDataContainer.getOrDefault(KEY_WIDTH_OFFSET, PersistentDataType.INTEGER, (Object)0);
        int heightO = (Integer)persistentDataContainer.getOrDefault(KEY_HEIGHT_OFFSET, PersistentDataType.INTEGER, (Object)0);
        int depthO = (Integer)persistentDataContainer.getOrDefault(KEY_DEPTH_OFFSET, PersistentDataType.INTEGER, (Object)0);
        figure.setRotations(widthR, heightR, depthR);
        figure.setOffsets(widthO, heightO, depthO);
        figure.updateCachedKey();
        return figure;
    }

    private int getOrDefault(Integer integer, int defaultValue) {
        return integer != null ? integer : defaultValue;
    }

    private boolean fromByte(Byte byteValue, boolean defaultValue) {
        return byteValue != null ? byteValue == 1 : defaultValue;
    }

    private class LegacyFigureItemDataType
    implements PersistentDataType<PersistentDataContainer, FigureItemInfo> {
        private LegacyFigureItemDataType() {
        }

        @NotNull
        public Class<PersistentDataContainer> getPrimitiveType() {
            return PersistentDataContainer.class;
        }

        @NotNull
        public Class<FigureItemInfo> getComplexType() {
            return FigureItemInfo.class;
        }

        @NotNull
        public PersistentDataContainer toPrimitive(FigureItemInfo figureInfo, PersistentDataAdapterContext persistentDataAdapterContext) {
            return FigureItemDataType.this.toPrimitive(figureInfo.figure(), persistentDataAdapterContext);
        }

        @NotNull
        public FigureItemInfo fromPrimitive(PersistentDataContainer persistentDataContainer, @NotNull PersistentDataAdapterContext persistentDataAdapterContext) {
            Figure figure = FigureItemDataType.this.fromPrimitive(persistentDataContainer, persistentDataAdapterContext);
            return new FigureItemInfo(figure);
        }
    }

    public record FigureItemInfo(Figure figure) {
    }
}

