/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.api;

import java.util.UUID;
import me.vermulst.multibreak.figure.Figure;
import me.vermulst.multibreak.item.FigureItemDataType;
import me.vermulst.multibreak.multibreak.BreakManager;
import me.vermulst.multibreak.utils.BreakUtils;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MultiBreakAPI {
    private static FigureItemDataType DATA_TYPE_INSTANCE;

    private MultiBreakAPI() {
    }

    @ApiStatus.Internal
    public static void init() {
        if (DATA_TYPE_INSTANCE != null) {
            throw new IllegalStateException("MultiBreakAPI already initialized!");
        }
        DATA_TYPE_INSTANCE = new FigureItemDataType();
    }

    @NotNull
    public static ItemStack setFigure(@NotNull ItemStack itemStack, @NotNull Figure figure) {
        if (DATA_TYPE_INSTANCE == null) {
            throw new IllegalStateException("MultiBreakAPI not initialized. Load MultiBreak before.");
        }
        return DATA_TYPE_INSTANCE.set(itemStack, figure);
    }

    @Nullable
    public static Figure getFigure(@NotNull ItemStack itemStack) {
        if (DATA_TYPE_INSTANCE == null) {
            throw new IllegalStateException("MultiBreakAPI not initialized. Load MultiBreak before.");
        }
        return DATA_TYPE_INSTANCE.get(itemStack);
    }

    @NotNull
    public static ItemStack removeFigure(@NotNull ItemStack itemStack) {
        if (DATA_TYPE_INSTANCE == null) {
            throw new IllegalStateException("MultiBreakAPI not initialized. Load MultiBreak before.");
        }
        return DATA_TYPE_INSTANCE.remove(itemStack);
    }

    public static boolean hasFigure(@NotNull ItemStack itemStack) {
        if (DATA_TYPE_INSTANCE == null) {
            throw new IllegalStateException("MultiBreakAPI not initialized. Load MultiBreak before.");
        }
        return DATA_TYPE_INSTANCE.has(itemStack);
    }

    public static boolean isMultiBroken(@NotNull Block block) {
        return block.hasMetadata("multi-broken");
    }

    public static void updateInteractionRange(UUID uuid) {
        BreakUtils.interactionRangeCache.remove(uuid);
    }

    public static void updateTool(Player p) {
        BreakManager.getInstance().refreshTool(p);
    }
}

