/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import me.vermulst.multibreak.Commands;
import me.vermulst.multibreak.api.MultiBreakAPI;
import me.vermulst.multibreak.config.Config;
import me.vermulst.multibreak.dependencies.bstats.bukkit.Metrics;
import me.vermulst.multibreak.multibreak.BreakManager;
import me.vermulst.multibreak.multibreak.event.BlockDestroyEvents;
import me.vermulst.multibreak.multibreak.event.BreakEvents;
import me.vermulst.multibreak.multibreak.event.RefreshEvents;
import me.vermulst.multibreak.multibreak.event.SpeedChangeEvents;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Main
extends JavaPlugin {
    private static Main INSTANCE;
    private static ExecutorService highPriorityExecutor;

    public static Main getInstance() {
        return INSTANCE;
    }

    public void onEnable() {
        Listener[] events;
        INSTANCE = this;
        int pluginId = 20516;
        new Metrics((Plugin)this, pluginId);
        MultiBreakAPI.init();
        if (Config.getInstance().load(this.getConfig())) {
            this.saveConfig();
        }
        BreakManager breakManager = BreakManager.getInstance();
        for (Listener event : events = new Listener[]{new BreakEvents(breakManager), new RefreshEvents(breakManager), new BlockDestroyEvents(breakManager), new SpeedChangeEvents(breakManager)}) {
            this.getServer().getPluginManager().registerEvents(event, (Plugin)this);
        }
        Commands commands = new Commands();
        commands.init();
        commands.register((Plugin)this);
        int threads = Math.min(2, Runtime.getRuntime().availableProcessors() / 2);
        highPriorityExecutor = Executors.newFixedThreadPool(threads, r -> {
            Thread t = new Thread(r, "MultiBreak-High-Priority-Pool");
            t.setPriority(10);
            return t;
        });
    }

    public void onDisable() {
        highPriorityExecutor.shutdownNow();
        Config.getInstance().save(this.getConfig());
        this.saveConfig();
    }

    public static ExecutorService getHighPriorityExecutor() {
        return highPriorityExecutor;
    }
}

