/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.multibreak;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.vermulst.multibreak.Main;
import me.vermulst.multibreak.api.event.FetchFigureEvent;
import me.vermulst.multibreak.api.event.FilterBlocksEvent;
import me.vermulst.multibreak.api.event.MultiBreakStartEvent;
import me.vermulst.multibreak.config.Config;
import me.vermulst.multibreak.figure.Figure;
import me.vermulst.multibreak.item.FigureItemDataType;
import me.vermulst.multibreak.multibreak.MultiBreak;
import me.vermulst.multibreak.multibreak.MultiBreakRunnable;
import me.vermulst.multibreak.utils.BreakUtils;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BreakManager {
    private final Map<UUID, Integer> multiBreakTask = new HashMap<UUID, Integer>();
    private final Map<UUID, MultiBreak> multiBlockMap = new HashMap<UUID, MultiBreak>();
    private final Map<UUID, Figure> figureCache = new HashMap<UUID, Figure>();
    private final Map<UUID, Block> lastTargetBlock = new HashMap<UUID, Block>();
    private static final BreakManager breakManager = new BreakManager();

    public static BreakManager getInstance() {
        return breakManager;
    }

    public void refreshTool(final Player p) {
        boolean fairMode = Config.getInstance().isFairModeEnabled();
        if (!fairMode) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                UUID uuid = p.getUniqueId();
                Figure previousFigure = BreakManager.this.figureCache.remove(uuid);
                Figure newFigure = BreakManager.this.getFigure(p);
                if (newFigure != null && newFigure.equals(previousFigure)) {
                    return;
                }
                BreakManager.this.lastTargetBlock.remove(uuid);
                BreakManager.this.refreshBreakSpeed(p);
            }
        }.runTaskLater((Plugin)Main.getInstance(), 1L);
    }

    protected void refreshBreakSpeed(Player p) {
        Figure figure;
        UUID uuid = p.getUniqueId();
        Block targetBlock = BreakUtils.getTargetBlock(p);
        if (targetBlock == null) {
            this.lastTargetBlock.remove(uuid);
            return;
        }
        if (this.lastTargetBlock.containsKey(uuid) && targetBlock.equals((Object)this.lastTargetBlock.get(uuid))) {
            return;
        }
        this.lastTargetBlock.put(uuid, targetBlock);
        AttributeInstance attribute = p.getAttribute(Attribute.BLOCK_BREAK_SPEED);
        AttributeModifier modifierToRemove = attribute.getModifier((Key)new NamespacedKey((Plugin)Main.getInstance(), "MultiBreakSlowdown"));
        if (modifierToRemove != null) {
            attribute.removeModifier(modifierToRemove);
        }
        if ((figure = this.getFigure(p)) == null) {
            return;
        }
        Config config = Config.getInstance();
        EnumSet<Material> includedMaterials = config.getIncludedMaterials();
        EnumSet<Material> ignoredMaterials = config.getIgnoredMaterials();
        FilterBlocksEvent filterBlocksEvent = new FilterBlocksEvent(figure, p, p.getInventory().getItemInMainHand(), includedMaterials, ignoredMaterials);
        filterBlocksEvent.callEvent();
        Set<Block> blocks = figure.getBlocks(p, targetBlock);
        this.filter(blocks, filterBlocksEvent.getIncludedMaterials(), filterBlocksEvent.getExcludedMaterials());
        float baseProgressPerTick = targetBlock.getBreakSpeed(p);
        if (baseProgressPerTick == Float.POSITIVE_INFINITY) {
            return;
        }
        float slowDownFactor = this.getSlowDownFactor(p, blocks, baseProgressPerTick);
        if (slowDownFactor == 1.0f) {
            return;
        }
        double currentAttributeTotal = p.getAttribute(Attribute.BLOCK_BREAK_SPEED).getValue();
        double newAttributeTotal = currentAttributeTotal * (double)slowDownFactor;
        AttributeModifier slowDownModifier = new AttributeModifier(new NamespacedKey((Plugin)Main.getInstance(), "MultiBreakSlowdown"), -(currentAttributeTotal - newAttributeTotal), AttributeModifier.Operation.ADD_NUMBER);
        attribute.addModifier(slowDownModifier);
    }

    protected void scheduleMultiBreak(Player p, Figure figure, Block block) {
        if (this.multiBreakTask.containsKey(p.getUniqueId())) {
            this.endMultiBreak(p, this.getMultiBreak(p), false);
        }
        MultiBreakRunnable multiBreakRunnable = new MultiBreakRunnable(p, block, figure, this);
        int taskID = multiBreakRunnable.runTaskTimer((Plugin)Main.getInstance(), 1L, 1L).getTaskId();
        this.multiBreakTask.put(p.getUniqueId(), taskID);
    }

    protected void endMultiBreak(Player p, MultiBreak multiBreak, boolean finished) {
        UUID uuid = p.getUniqueId();
        if (multiBreak != null) {
            multiBreak.end(finished);
            this.multiBlockMap.remove(uuid);
        }
        if (!this.multiBreakTask.containsKey(uuid)) {
            return;
        }
        Bukkit.getScheduler().cancelTask(this.multiBreakTask.get(uuid).intValue());
        this.multiBreakTask.remove(uuid);
    }

    protected MultiBreak initMultiBreak(Player p, Block block, Figure figure) {
        if (block == null) {
            return null;
        }
        BlockFace blockFace = BreakUtils.getBlockFace(p);
        if (blockFace == null) {
            return null;
        }
        Config config = Config.getInstance();
        EnumSet<Material> includedMaterials = config.getIncludedMaterials();
        EnumSet<Material> ignoredMaterials = config.getIgnoredMaterials();
        MultiBreak multiBreak = new MultiBreak(p, block, blockFace.getDirection(), figure);
        MultiBreakStartEvent event = new MultiBreakStartEvent(p, multiBreak, block);
        if (!event.callEvent()) {
            return null;
        }
        FilterBlocksEvent filterBlocksEvent = new FilterBlocksEvent(figure, p, p.getInventory().getItemInMainHand(), includedMaterials, ignoredMaterials);
        filterBlocksEvent.callEvent();
        includedMaterials = filterBlocksEvent.getIncludedMaterials();
        ignoredMaterials = filterBlocksEvent.getExcludedMaterials();
        multiBreak = event.getMultiBreak();
        if (!multiBreak.isValid(includedMaterials, ignoredMaterials)) {
            return null;
        }
        float progressPerTick = multiBreak.getBlock().getBreakSpeed(p);
        multiBreak.checkValid(progressPerTick, includedMaterials, ignoredMaterials);
        this.multiBlockMap.put(p.getUniqueId(), multiBreak);
        return multiBreak;
    }

    protected boolean isMultiBreak(BlockBreakEvent e) {
        Block block = e.getBlock();
        boolean wasMultiBroken = block.hasMetadata("multi-broken");
        boolean isIgnoredMaterial = Config.getInstance().getIgnoredMaterials().contains(block.getType());
        boolean isCancelled = e.isCancelled();
        if (wasMultiBroken) {
            block.removeMetadata("multi-broken", (Plugin)Main.getInstance());
        }
        return !wasMultiBroken && !isIgnoredMaterial && !isCancelled;
    }

    protected void filter(Set<Block> blocks, EnumSet<Material> includedMaterials, EnumSet<Material> ignoredMaterials) {
        blocks.removeIf(block -> {
            Material mainBlockType = block.getType();
            if (includedMaterials != null && !includedMaterials.isEmpty() && !includedMaterials.contains(mainBlockType)) {
                return true;
            }
            return ignoredMaterials != null && !ignoredMaterials.isEmpty() && ignoredMaterials.contains(mainBlockType);
        });
    }

    protected float getSlowDownFactor(Player p, Set<Block> blocks, float baseProgressPerTick) {
        float lowestProgressPerTick = baseProgressPerTick;
        for (Block block : blocks) {
            float progressPerTick = block.getBreakSpeed(p);
            if (!(progressPerTick < lowestProgressPerTick)) continue;
            lowestProgressPerTick = progressPerTick;
        }
        return lowestProgressPerTick / baseProgressPerTick;
    }

    protected Figure getFigure(Player p) {
        ItemStack tool = p.getInventory().getItemInMainHand();
        return this.getFigure(p, tool);
    }

    protected Figure getFigure(Player p, ItemStack tool) {
        if (this.figureCache.containsKey(p.getUniqueId())) {
            return this.figureCache.get(p.getUniqueId());
        }
        if (tool.getItemMeta() == null) {
            this.figureCache.put(p.getUniqueId(), null);
            return null;
        }
        FigureItemDataType figureItemDataType = new FigureItemDataType();
        Figure figure = figureItemDataType.get(tool);
        if (figure == null) {
            Material material = tool.getType();
            Config config = Config.getInstance();
            if (config.getMaterialOptions().containsKey(material)) {
                String configOptionName = config.getMaterialOptions().get(material);
                figure = config.getConfigOptions().get(configOptionName);
            }
        }
        FetchFigureEvent fetchFigureEvent = new FetchFigureEvent(figure, p, tool);
        fetchFigureEvent.callEvent();
        if (fetchFigureEvent.isCancelled()) {
            this.figureCache.put(p.getUniqueId(), null);
            return null;
        }
        figure = fetchFigureEvent.getFigure();
        this.figureCache.put(p.getUniqueId(), figure);
        return figure;
    }

    protected MultiBreak getMultiBreak(Player p) {
        MultiBreak multiBreak;
        if (this.multiBlockMap.containsKey(p.getUniqueId()) && !(multiBreak = this.multiBlockMap.get(p.getUniqueId())).hasEnded()) {
            return multiBreak;
        }
        return null;
    }

    public Map<UUID, Integer> getMultiBreakTask() {
        return this.multiBreakTask;
    }
}

