/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.multibreak;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import me.vermulst.multibreak.api.event.MultiBreakEndEvent;
import me.vermulst.multibreak.config.Config;
import me.vermulst.multibreak.figure.Figure;
import me.vermulst.multibreak.multibreak.BreakManager;
import me.vermulst.multibreak.multibreak.MultiBreak;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageAbortEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.CrafterInventory;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class BreakEvents
implements Listener {
    private final BreakManager breakManager;

    public BreakEvents(BreakManager breakManager) {
        this.breakManager = breakManager;
    }

    @EventHandler
    public void pickupIntoHand(EntityPickupItemEvent e) {
        LivingEntity livingEntity = e.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player p = (Player)livingEntity;
        PlayerInventory inventory = p.getInventory();
        ItemStack[] items = inventory.getContents();
        int heldSlot = inventory.getHeldItemSlot();
        if (items[heldSlot] != null) {
            return;
        }
        int firstEmptySlot = -1;
        for (int i = 0; i < 9; ++i) {
            if (items[i] != null) continue;
            firstEmptySlot = i;
            break;
        }
        if (firstEmptySlot == heldSlot) {
            this.breakManager.refreshTool(p);
        }
    }

    @EventHandler
    public void emptyHeldSlot(PlayerDropItemEvent e) {
        Player p = e.getPlayer();
        if (p.getInventory().getItemInMainHand().getType() != Material.AIR) {
            return;
        }
        this.breakManager.refreshTool(p);
    }

    @EventHandler
    public void joinEvent(PlayerJoinEvent e) {
        this.breakManager.refreshTool(e.getPlayer());
    }

    @EventHandler
    public void hotbarSwap(PlayerItemHeldEvent e) {
        Player p = e.getPlayer();
        this.breakManager.refreshTool(p);
    }

    @EventHandler
    public void offhandSwap(PlayerSwapHandItemsEvent e) {
        this.breakManager.refreshTool(e.getPlayer());
    }

    @EventHandler
    public void heldItemClick(InventoryClickEvent e) {
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player p = (Player)humanEntity;
        if (e.isShiftClick()) {
            this.shiftClick(e, p);
        } else if (ClickType.NUMBER_KEY.equals((Object)e.getClick())) {
            int playerHeldSlotRelative = p.getInventory().getHeldItemSlot();
            Inventory topInv = e.getInventory();
            if (e.getHotbarButton() == playerHeldSlotRelative || e.getRawSlot() == this.getPlayerHeldSlotRaw(p, topInv)) {
                this.breakManager.refreshTool(p);
            }
        } else {
            Inventory topInv = e.getInventory();
            int playerHeldSlotRaw = this.getPlayerHeldSlotRaw(p, topInv);
            if (e.getRawSlot() == playerHeldSlotRaw) {
                this.breakManager.refreshTool(p);
            }
        }
    }

    public void shiftClick(InventoryClickEvent e, Player p) {
        Inventory topInv = e.getInventory();
        boolean refresh = false;
        int playerHeldSlot = p.getInventory().getHeldItemSlot();
        int playerHeldSlotRaw = this.getPlayerHeldSlotRaw(p, topInv);
        int baseHotbarSlotRaw = playerHeldSlotRaw - playerHeldSlot;
        int click = e.getRawSlot();
        if (click >= baseHotbarSlotRaw && click <= baseHotbarSlotRaw + 8) {
            refresh = click == playerHeldSlotRaw;
        } else if (topInv instanceof CraftingInventory) {
            if (click <= 8 || click == 45) {
                return;
            }
            ItemStack[] items = p.getInventory().getContents();
            int firstEmptySlot = -1;
            for (int i = 0; i < 9; ++i) {
                if (items[i] != null) continue;
                firstEmptySlot = i;
                break;
            }
            refresh = firstEmptySlot == playerHeldSlot;
        } else {
            int topInventorySize;
            int slot = e.getRawSlot();
            if (slot <= (topInventorySize = this.getTopInventorySize(topInv))) {
                ItemStack[] items = p.getInventory().getContents();
                int firstEmptySlot = -1;
                for (int i = 8; i >= 0; ++i) {
                    if (items[i] != null) continue;
                    firstEmptySlot = i;
                    break;
                }
                boolean bl = refresh = firstEmptySlot == playerHeldSlot;
            }
        }
        if (refresh) {
            this.breakManager.refreshTool(p);
        }
    }

    @EventHandler
    public void dragIntoHeldItemEvent(InventoryDragEvent e) {
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player p = (Player)humanEntity;
        Inventory topInv = e.getInventory();
        int playerHeldSlotRaw = this.getPlayerHeldSlotRaw(p, topInv);
        if (e.getRawSlots().contains(playerHeldSlotRaw)) {
            this.breakManager.refreshTool(p);
        }
    }

    private int getPlayerHeldSlotRaw(Player p, Inventory topInv) {
        return this.getTopInventorySize(topInv) + 27 + p.getInventory().getHeldItemSlot();
    }

    private int getTopInventorySize(Inventory topInv) {
        int inventorySize = topInv.getSize();
        if (topInv instanceof CraftingInventory) {
            inventorySize += 4;
        } else if (topInv instanceof CrafterInventory) {
            --inventorySize;
        }
        return inventorySize;
    }

    @EventHandler
    public void tickEvent(ServerTickEndEvent e) {
        boolean fairMode = Config.getInstance().isFairModeEnabled();
        if (!fairMode) {
            return;
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.breakManager.refreshBreakSpeed(p);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void multiBreakStart(BlockDamageEvent e) {
        ItemStack item;
        Player p = e.getPlayer();
        Figure figure = this.breakManager.getFigure(p, item = e.getItemInHand());
        if (figure == null) {
            return;
        }
        this.breakManager.scheduleMultiBreak(p, figure, e.getBlock());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void multiBreakStop(BlockDamageAbortEvent e) {
        Player p = e.getPlayer();
        MultiBreak multiBreak = this.breakManager.getMultiBreak(p);
        if (multiBreak != null) {
            MultiBreakEndEvent event = new MultiBreakEndEvent(p, multiBreak, false);
            event.callEvent();
        }
        this.breakManager.endMultiBreak(p, multiBreak, false);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void breakBlockType(BlockBreakEvent e) {
        Block block;
        if (!this.breakManager.isMultiBreak(e)) {
            return;
        }
        Player p = e.getPlayer();
        MultiBreak multiBreak = this.breakManager.getMultiBreak(p);
        if (multiBreak == null) {
            Figure figure = this.breakManager.getFigure(p);
            multiBreak = this.breakManager.initMultiBreak(p, e.getBlock(), figure);
            if (multiBreak == null) {
                return;
            }
        }
        if (!(block = e.getBlock()).equals((Object)multiBreak.getBlock())) {
            Figure figure = this.breakManager.getFigure(p);
            multiBreak = this.breakManager.initMultiBreak(p, block, figure);
        }
        MultiBreakEndEvent event = new MultiBreakEndEvent(p, multiBreak, true);
        event.callEvent();
        if (event.isCancelled()) {
            return;
        }
        if (event.getMultiBreak() == null) {
            return;
        }
        this.breakManager.endMultiBreak(p, event.getMultiBreak(), true);
    }
}

