/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.multibreak;

import me.vermulst.multibreak.Main;
import me.vermulst.multibreak.figure.Figure;
import me.vermulst.multibreak.multibreak.BreakManager;
import me.vermulst.multibreak.multibreak.MultiBreak;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class MultiBreakRunnable
extends BukkitRunnable {
    private final Player p;
    private final Block block;
    private boolean init = false;
    private final Figure figure;
    private final BreakManager breakManager;

    public MultiBreakRunnable(Player p, Block block, Figure figure, BreakManager breakManager) {
        this.p = p;
        this.block = block;
        this.figure = figure;
        this.breakManager = breakManager;
    }

    public void run() {
        Block blockMining;
        MultiBreak multiBreak;
        if (!this.init) {
            if (this.block.getType().isAir() && !this.breakManager.getTargetBlock(this.p).equals((Object)this.block)) {
                this.cancel();
                return;
            }
            this.init = true;
        }
        if ((multiBreak = this.breakManager.getMultiBreak(this.p)) == null && (multiBreak = this.breakManager.initMultiBreak(this.p, blockMining = this.breakManager.getTargetBlock(this.p), this.figure)) == null) {
            this.cancel();
            return;
        }
        BlockFace blockFace = this.getBlockFace(this.p);
        if (blockFace == null) {
            this.cancel();
            return;
        }
        Vector direction = blockFace.getDirection();
        if (!multiBreak.getPlayerDirection().equals((Object)direction)) {
            if ((multiBreak = this.replaceMultiBreak(this.p, multiBreak)) == null) {
                this.cancel();
                return;
            }
            this.breakManager.scheduleMultiBreak(this.p, this.figure);
        }
        multiBreak.tick();
    }

    public BlockFace getBlockFace(Player p) {
        return p.getTargetBlockFace(Main.getInstance().getConfigManager().getMaxRange());
    }

    public MultiBreak replaceMultiBreak(Player p, MultiBreak multiBreak) {
        this.breakManager.endMultiBreak(p, multiBreak, false);
        float progressBroken = multiBreak.getProgressBroken();
        int progressTicks = multiBreak.getProgressTicks();
        multiBreak = this.breakManager.initMultiBreak(p, this.block, this.figure);
        if (multiBreak == null) {
            return null;
        }
        multiBreak.setProgressBroken(progressBroken);
        multiBreak.setProgressTicks(progressTicks);
        return multiBreak;
    }
}

