/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.multibreak;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class MultiBlock {
    private final Block block;
    private boolean isVisible;
    private boolean breakThisBlock = true;
    private final Material type;
    private List<ItemStack> drops;
    private final int sourceID = ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE);

    public MultiBlock(Block block) {
        this.block = block;
        this.type = block.getType();
        this.isVisible = this.initVisibility(block);
    }

    public boolean initVisibility(Block b) {
        for (BlockFace face : BlockFace.values()) {
            if (!face.isCartesian()) continue;
            Block adjacent = b.getRelative(face);
            if (adjacent.isEmpty() || adjacent.isLiquid() && adjacent.getType() != Material.POWDER_SNOW) {
                return true;
            }
            if (adjacent.getType().isOccluding()) continue;
            return true;
        }
        return false;
    }

    public void writeStage(Player p, float stage) {
        p.sendBlockDamage(this.getBlock().getLocation(), stage, this.sourceID);
    }

    public boolean mismatchesType() {
        return this.block.getType() != this.type;
    }

    public Block getBlock() {
        return this.block;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiBlock that = (MultiBlock)o;
        return this.isVisible == that.isVisible && Objects.equals(this.block, that.block);
    }

    public int hashCode() {
        return Objects.hash(this.block, this.isVisible);
    }

    public boolean breakThisBlock() {
        return this.breakThisBlock;
    }

    public void setBreakThisBlock(boolean breakThisBlock) {
        this.breakThisBlock = breakThisBlock;
    }

    public void setDrops(ArrayList<ItemStack> drops) {
        this.drops = drops;
    }

    public List<ItemStack> getDrops() {
        return this.drops;
    }

    public Material getType() {
        return this.type;
    }
}

