/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.multibreak;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.vermulst.multibreak.Main;
import me.vermulst.multibreak.api.event.FetchFigureEvent;
import me.vermulst.multibreak.api.event.FilterBlocksEvent;
import me.vermulst.multibreak.api.event.MultiBreakEndEvent;
import me.vermulst.multibreak.api.event.MultiBreakStartEvent;
import me.vermulst.multibreak.config.ConfigManager;
import me.vermulst.multibreak.figure.Figure;
import me.vermulst.multibreak.item.FigureItemDataType;
import me.vermulst.multibreak.multibreak.MultiBreak;
import me.vermulst.multibreak.multibreak.MultiBreakRunnable;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageAbortEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BreakManager
implements Listener {
    private final Main plugin;
    private final Map<UUID, Integer> multiBreakTask = new HashMap<UUID, Integer>();
    private final Map<UUID, MultiBreak> multiBlockMap = new HashMap<UUID, MultiBreak>();
    private final Map<UUID, Figure> figureCache = new HashMap<UUID, Figure>();
    private final Map<UUID, Block> lastTargetBlock = new HashMap<UUID, Block>();

    public BreakManager(Main plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void joinEvent(PlayerJoinEvent e) {
        this.refresh(e.getPlayer());
    }

    @EventHandler
    public void itemHeld(PlayerItemHeldEvent e) {
        this.refresh(e.getPlayer());
    }

    @EventHandler
    public void inventoryClick(InventoryClickEvent e) {
        this.refresh((Player)e.getWhoClicked());
    }

    @EventHandler
    public void dragEvent(InventoryDragEvent e) {
        this.refresh((Player)e.getWhoClicked());
    }

    @EventHandler
    public void swapOffhand(PlayerSwapHandItemsEvent e) {
        this.refresh(e.getPlayer());
    }

    private void refresh(final Player p) {
        boolean fairMode = Main.getInstance().getConfigManager().getOptions()[0];
        if (!fairMode) {
            return;
        }
        UUID uuid = p.getUniqueId();
        this.figureCache.remove(uuid);
        this.lastTargetBlock.remove(uuid);
        new BukkitRunnable(){

            public void run() {
                BreakManager.this.setBreakSpeed(p);
            }
        }.runTaskLater((Plugin)Main.getInstance(), 1L);
    }

    @EventHandler
    public void tickEvent(ServerTickEndEvent e) {
        boolean fairMode = Main.getInstance().getConfigManager().getOptions()[0];
        if (!fairMode) {
            return;
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.setBreakSpeed(p);
        }
    }

    public void setBreakSpeed(Player p) {
        UUID uuid = p.getUniqueId();
        Block targetBlock = this.getTargetBlock(p);
        if (targetBlock == null) {
            this.lastTargetBlock.remove(uuid);
            return;
        }
        if (!this.lastTargetBlock.containsKey(uuid)) {
            this.lastTargetBlock.put(uuid, targetBlock);
        } else {
            Figure figure;
            AttributeInstance attribute;
            AttributeModifier modifierToRemove;
            Block lastBlock = this.lastTargetBlock.get(uuid);
            if (!lastBlock.equals((Object)targetBlock)) {
                this.lastTargetBlock.put(uuid, targetBlock);
            }
            if ((modifierToRemove = (attribute = p.getAttribute(Attribute.BLOCK_BREAK_SPEED)).getModifier((Key)new NamespacedKey((Plugin)Main.getInstance(), "MultiBreakSlowdown"))) != null) {
                attribute.removeModifier(modifierToRemove);
            }
            if ((figure = this.getFigure(p)) == null) {
                return;
            }
            ConfigManager config = this.plugin.getConfigManager();
            EnumSet<Material> includedMaterials = config.getIncludedMaterials();
            EnumSet<Material> ignoredMaterials = config.getIgnoredMaterials();
            FilterBlocksEvent filterBlocksEvent = new FilterBlocksEvent(figure, p, p.getInventory().getItemInMainHand(), includedMaterials, ignoredMaterials);
            filterBlocksEvent.callEvent();
            Set<Block> blocks = figure.getBlocks(p, targetBlock);
            this.filter(blocks, filterBlocksEvent.getIncludedMaterials(), filterBlocksEvent.getExcludedMaterials());
            float baseProgressPerTick = targetBlock.getBreakSpeed(p);
            if (baseProgressPerTick == Float.POSITIVE_INFINITY) {
                return;
            }
            float slowDownFactor = this.getSlowDownFactor(p, blocks, baseProgressPerTick);
            if (slowDownFactor == 1.0f) {
                return;
            }
            double currentAttributeTotal = p.getAttribute(Attribute.BLOCK_BREAK_SPEED).getValue();
            double newAttributeTotal = currentAttributeTotal * (double)slowDownFactor;
            AttributeModifier slowDownModifier = new AttributeModifier(new NamespacedKey((Plugin)Main.getInstance(), "MultiBreakSlowdown"), -(currentAttributeTotal - newAttributeTotal), AttributeModifier.Operation.ADD_NUMBER);
            attribute.addModifier(slowDownModifier);
        }
    }

    public void filter(Set<Block> blocks, EnumSet<Material> includedMaterials, EnumSet<Material> ignoredMaterials) {
        blocks.removeIf(block -> {
            Material mainBlockType = block.getType();
            if (includedMaterials != null && !includedMaterials.isEmpty() && !includedMaterials.contains(mainBlockType)) {
                return true;
            }
            return ignoredMaterials != null && !ignoredMaterials.isEmpty() && ignoredMaterials.contains(mainBlockType);
        });
    }

    public float getSlowDownFactor(Player p, Set<Block> blocks, float baseProgressPerTick) {
        float lowestProgressPerTick = baseProgressPerTick;
        for (Block block : blocks) {
            float progressPerTick = block.getBreakSpeed(p);
            if (!(progressPerTick < lowestProgressPerTick)) continue;
            lowestProgressPerTick = progressPerTick;
        }
        return lowestProgressPerTick / baseProgressPerTick;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void multiBreakStart(BlockDamageEvent e) {
        ItemStack item;
        Player p = e.getPlayer();
        Figure figure = this.getFigure(p, item = e.getItemInHand());
        if (figure == null) {
            return;
        }
        this.scheduleMultiBreak(e.getPlayer(), figure);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void multiBreakStop(BlockDamageAbortEvent e) {
        Player p = e.getPlayer();
        MultiBreak multiBreak = this.getMultiBreak(p);
        if (multiBreak == null) {
            return;
        }
        MultiBreakEndEvent event = new MultiBreakEndEvent(p, multiBreak, false);
        event.callEvent();
        this.endMultiBreak(p, multiBreak, false);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void breakBlockType(BlockBreakEvent e) {
        Block block;
        if (this.ignoreMultiBreak(e)) {
            return;
        }
        Player p = e.getPlayer();
        MultiBreak multiBreak = this.getMultiBreak(p);
        if (multiBreak == null) {
            Figure figure = this.getFigure(p);
            multiBreak = this.initMultiBreak(p, e.getBlock(), figure);
            if (multiBreak == null) {
                return;
            }
        }
        if (!(block = e.getBlock()).equals((Object)multiBreak.getBlock())) {
            Figure figure = this.getFigure(p);
            multiBreak = this.initMultiBreak(p, block, figure);
        }
        MultiBreakEndEvent event = new MultiBreakEndEvent(p, multiBreak, true);
        event.callEvent();
        if (event.isCancelled()) {
            return;
        }
        if (event.getMultiBreak() == null) {
            return;
        }
        this.endMultiBreak(p, event.getMultiBreak(), true);
    }

    private boolean ignoreMultiBreak(BlockBreakEvent e) {
        Block block = e.getBlock();
        boolean b1 = block.hasMetadata("multi-broken");
        boolean b2 = this.plugin.getConfigManager().getIgnoredMaterials().contains(block.getType());
        boolean b3 = e.isCancelled();
        if (block.hasMetadata("multi-broken")) {
            block.removeMetadata("multi-broken", (Plugin)this.getPlugin());
        }
        return b1 || b2 || b3;
    }

    public void scheduleMultiBreak(Player p, Figure figure) {
        Block block = this.getTargetBlock(p);
        MultiBreakRunnable multiBreakRunnable = new MultiBreakRunnable(p, block, figure, this);
        int taskID = multiBreakRunnable.runTaskTimer((Plugin)this.getPlugin(), 1L, 1L).getTaskId();
        this.getMultiBreakTask().put(p.getUniqueId(), taskID);
    }

    public void endMultiBreak(Player p, MultiBreak multiBreak, boolean finished) {
        UUID uuid = p.getUniqueId();
        multiBreak.end(finished, this.getPlugin());
        this.getMultiBlockMap().remove(uuid);
        if (!this.getMultiBreakTask().containsKey(uuid)) {
            return;
        }
        Bukkit.getScheduler().cancelTask(this.getMultiBreakTask().get(uuid).intValue());
        this.getMultiBreakTask().remove(uuid);
    }

    public MultiBreak getMultiBreak(Player p) {
        MultiBreak multiBreak;
        if (p.getGameMode().equals((Object)GameMode.CREATIVE)) {
            return null;
        }
        if (this.multiBlockMap.containsKey(p.getUniqueId()) && !(multiBreak = this.multiBlockMap.get(p.getUniqueId())).hasEnded()) {
            return multiBreak;
        }
        return null;
    }

    public MultiBreak initMultiBreak(Player p, Block block, Figure figure) {
        if (block == null) {
            return null;
        }
        BlockFace blockFace = this.getBlockFace(p);
        if (blockFace == null) {
            return null;
        }
        ConfigManager config = this.plugin.getConfigManager();
        EnumSet<Material> includedMaterials = config.getIncludedMaterials();
        EnumSet<Material> ignoredMaterials = config.getIgnoredMaterials();
        MultiBreak multiBreak = new MultiBreak(p, block, blockFace.getDirection(), figure);
        MultiBreakStartEvent event = new MultiBreakStartEvent(p, multiBreak, block);
        if (!event.callEvent()) {
            return null;
        }
        FilterBlocksEvent filterBlocksEvent = new FilterBlocksEvent(figure, p, p.getInventory().getItemInMainHand(), includedMaterials, ignoredMaterials);
        filterBlocksEvent.callEvent();
        includedMaterials = filterBlocksEvent.getIncludedMaterials();
        ignoredMaterials = filterBlocksEvent.getExcludedMaterials();
        multiBreak = event.getMultiBreak();
        if (!multiBreak.isValid(includedMaterials, ignoredMaterials)) {
            return null;
        }
        float progressPerTick = multiBreak.getBlock().getBreakSpeed(p);
        multiBreak.checkValid(progressPerTick, includedMaterials, ignoredMaterials);
        this.multiBlockMap.put(p.getUniqueId(), multiBreak);
        return multiBreak;
    }

    public Figure getFigure(Player p) {
        ItemStack tool = p.getInventory().getItemInMainHand();
        return this.getFigure(p, tool);
    }

    public Figure getFigure(Player p, ItemStack tool) {
        if (this.figureCache.containsKey(p.getUniqueId())) {
            return this.figureCache.get(p.getUniqueId());
        }
        if (tool.getItemMeta() == null) {
            this.figureCache.put(p.getUniqueId(), null);
            return null;
        }
        FigureItemDataType figureItemDataType = new FigureItemDataType((Plugin)this.getPlugin());
        Figure figure = figureItemDataType.get(tool);
        if (figure == null) {
            Material material = tool.getType();
            ConfigManager configManager = this.getPlugin().getConfigManager();
            if (configManager.getMaterialOptions().containsKey(material)) {
                String configOptionName = configManager.getMaterialOptions().get(material);
                figure = configManager.getConfigOptions().get(configOptionName);
            }
        }
        FetchFigureEvent fetchFigureEvent = new FetchFigureEvent(figure, p, tool);
        fetchFigureEvent.callEvent();
        if (fetchFigureEvent.isCancelled()) {
            this.figureCache.put(p.getUniqueId(), null);
            return null;
        }
        figure = fetchFigureEvent.getFigure();
        this.figureCache.put(p.getUniqueId(), figure);
        return figure;
    }

    public Block getTargetBlock(Player p) {
        return p.getTargetBlockExact(this.plugin.getConfigManager().getMaxRange());
    }

    public BlockFace getBlockFace(Player p) {
        return p.getTargetBlockFace(this.plugin.getConfigManager().getMaxRange());
    }

    public Main getPlugin() {
        return this.plugin;
    }

    public Map<UUID, Integer> getMultiBreakTask() {
        return this.multiBreakTask;
    }

    public Map<UUID, MultiBreak> getMultiBlockMap() {
        return this.multiBlockMap;
    }
}

