/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.figure;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.vermulst.multibreak.Main;
import me.vermulst.multibreak.figure.Matrix4x4;
import me.vermulst.multibreak.figure.VectorTransformer;
import me.vermulst.multibreak.figure.types.FigureType;
import me.vermulst.multibreak.utils.CompassDirection;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public abstract class Figure {
    private final int width;
    private final int height;
    private final int depth;
    private int offSetWidth = 0;
    private int offSetHeight = 0;
    private int offSetDepth = 0;
    private short rotationWidth = 0;
    private short rotationHeight = 0;
    private short rotationDepth = 0;

    public Figure(int width, int height, int depth) {
        this.width = width;
        this.height = height;
        this.depth = depth;
    }

    public abstract Set<Vector> getVectors(boolean var1);

    public abstract FigureType getFigureType();

    public BlockFace getBlockFace(Player p) {
        return p.getTargetBlockFace(Main.getInstance().getConfigManager().getMaxRange());
    }

    public Set<Block> getBlocks(Player p, Block targetBlock) {
        HashSet<Block> blocks = new HashSet<Block>();
        BlockFace blockFace = this.getBlockFace(p);
        if (blockFace == null) {
            return blocks;
        }
        CompassDirection compassDirection = CompassDirection.getCompassDir(p.getLocation());
        boolean rotated = (double)this.getRotationWidth() != 0.0 || (double)this.getRotationHeight() != 0.0 || (double)this.getRotationDepth() != 0.0;
        Set<Vector> blockVectors = this.getVectors(rotated);
        if (rotated) {
            blockVectors = this.applyRotation(blockVectors);
        }
        VectorTransformer vectorTransformer = new VectorTransformer(blockFace.getDirection(), compassDirection);
        for (Vector vector : blockVectors) {
            vectorTransformer.rotateVector(vector);
        }
        blockVectors.remove(new Vector(0, 0, 0));
        Location loc = targetBlock.getLocation();
        for (Vector vector : blockVectors) {
            Block block = loc.clone().add(vector).getBlock();
            Material type = block.getType();
            if (block.isLiquid() && type != Material.POWDER_SNOW || !type.isItem()) continue;
            blocks.add(block);
        }
        return blocks;
    }

    private Set<Vector> applyRotation(Set<Vector> vectors) {
        HashSet<Vector> rotatedVectors = new HashSet<Vector>();
        Matrix4x4 rotationMatrix = new Matrix4x4();
        rotationMatrix.setRotationX((double)this.getRotationWidth() * (Math.PI / 180));
        rotationMatrix.setRotationY((double)this.getRotationHeight() * (Math.PI / 180));
        rotationMatrix.setRotationZ((double)this.getRotationDepth() * (Math.PI / 180));
        for (Vector vector : vectors) {
            rotationMatrix.transform(vector);
            vector.setX((float)Math.round(vector.getX()));
            vector.setY((float)Math.round(vector.getY()));
            vector.setZ((float)Math.round(vector.getZ()));
            rotatedVectors.add(new Vector((float)Math.round(vector.getX()), (float)Math.round(vector.getY()), (float)Math.round(vector.getZ())));
        }
        return rotatedVectors;
    }

    public void setOffsets(int offSetWidth, int offSetHeight, int offSetDepth) {
        this.offSetWidth = offSetWidth;
        this.offSetHeight = offSetHeight;
        this.offSetDepth = offSetDepth;
    }

    public void setRotations(short rotationWidth, short rotationHeight, short rotationDepth) {
        this.rotationWidth = rotationWidth;
        this.rotationHeight = rotationHeight;
        this.rotationDepth = rotationDepth;
    }

    public List<TextComponent> getLore() {
        ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
        TextComponent widthC = Component.text((String)"Width: ", (TextColor)NamedTextColor.GRAY);
        TextComponent heightC = Component.text((String)"Height: ", (TextColor)NamedTextColor.GRAY);
        TextComponent depthC = Component.text((String)"Depth: ", (TextColor)NamedTextColor.GRAY);
        lore.add(Component.empty());
        lore.add((TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("Size").color((TextColor)NamedTextColor.WHITE)).decoration(TextDecoration.UNDERLINED, true)).decoration(TextDecoration.BOLD, true)).build());
        lore.add((TextComponent)widthC.append((Component)Component.text((int)this.getWidth(), (TextColor)NamedTextColor.YELLOW)));
        lore.add((TextComponent)heightC.append((Component)Component.text((int)this.getHeight(), (TextColor)NamedTextColor.YELLOW)));
        lore.add((TextComponent)depthC.append((Component)Component.text((int)this.getDepth(), (TextColor)NamedTextColor.YELLOW)));
        lore.add(Component.empty());
        lore.add((TextComponent)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("Rotations").color((TextColor)NamedTextColor.WHITE)).decoration(TextDecoration.UNDERLINED, true)).build());
        lore.add((TextComponent)widthC.append((Component)Component.text((int)this.getRotationWidth(), (TextColor)NamedTextColor.YELLOW)));
        lore.add((TextComponent)heightC.append((Component)Component.text((int)this.getRotationHeight(), (TextColor)NamedTextColor.YELLOW)));
        lore.add((TextComponent)depthC.append((Component)Component.text((int)this.getRotationDepth(), (TextColor)NamedTextColor.YELLOW)));
        lore.add(Component.empty());
        lore.add((TextComponent)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("Offsets").color(TextColor.color((int)255, (int)255, (int)255))).decoration(TextDecoration.UNDERLINED, true)).build());
        lore.add((TextComponent)widthC.append((Component)Component.text((int)this.getOffSetWidth(), (TextColor)NamedTextColor.YELLOW)));
        lore.add((TextComponent)heightC.append((Component)Component.text((int)this.getOffSetHeight(), (TextColor)NamedTextColor.YELLOW)));
        lore.add((TextComponent)depthC.append((Component)Component.text((int)this.getOffSetDepth(), (TextColor)NamedTextColor.YELLOW)));
        return lore;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getOffSetWidth() {
        return this.offSetWidth;
    }

    public int getOffSetHeight() {
        return this.offSetHeight;
    }

    public int getOffSetDepth() {
        return this.offSetDepth;
    }

    public short getRotationWidth() {
        return this.rotationWidth;
    }

    public short getRotationHeight() {
        return this.rotationHeight;
    }

    public short getRotationDepth() {
        return this.rotationDepth;
    }
}

