/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.config;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import me.vermulst.multibreak.figure.Figure;
import me.vermulst.multibreak.figure.types.FigureType;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ConfigManager {
    private Map<String, Figure> configOptions;
    private Map<Material, String> materialOptions;
    private final EnumSet<Material> includedMaterials = EnumSet.noneOf(Material.class);
    private final EnumSet<Material> ignoredMaterials = EnumSet.noneOf(Material.class);
    private int maxRange = 10;
    private int fairModeTicksLeeway = 1;
    private final boolean[] options = new boolean[]{true};
    private static final String[] optionNames = new String[]{"fair_mode"};
    private static final String OLD_MATERIAL_PRESETS_PATH = "material_configs";
    private static final String NEW_MATERIAL_PRESETS_PATH = "material_presets";
    private static final String OLD_PRESETS_PATH = "config_options";
    private static final String NEW_PRESETS_PATH = "presets";

    public Inventory getMenu() {
        Inventory inventory = Bukkit.createInventory(null, (int)54, (Component)Component.text((String)"Configurations"));
        int index = 0;
        for (Map.Entry<String, Figure> entry : this.configOptions.entrySet()) {
            String name = entry.getKey();
            Figure figure = entry.getValue();
            ItemStack item = new ItemStack(Material.WRITABLE_BOOK);
            ItemMeta meta = item.getItemMeta();
            meta.displayName((Component)Component.text((String)name));
            meta.lore(figure.getLore());
            item.setItemMeta(meta);
            inventory.setItem(index, item);
            ++index;
        }
        return inventory;
    }

    public void save(FileConfiguration fileConfiguration) {
        List[] optionComments = new List[]{List.of("If enabled, blocks that take longer to break than the source, will not be multibroken.")};
        for (int i = 0; i < this.options.length; ++i) {
            String string = optionNames[i];
            boolean option = this.options[i];
            fileConfiguration.set(string, (Object)option);
            fileConfiguration.setComments(string, optionComments[i]);
        }
        fileConfiguration.set("fair_mode_leeway", (Object)this.fairModeTicksLeeway);
        fileConfiguration.setComments("fair_mode_leeway", List.of("", "The amount of ticks which will count as being in range within fair mode.", "For example, when set to 1, blocks that would take 5 ticks to break while the source block takes 6 ticks, will still be broken.", "1 is the recommended value."));
        fileConfiguration.set(OLD_PRESETS_PATH, null);
        for (Map.Entry<String, Figure> entry : this.getConfigOptions().entrySet()) {
            String name = entry.getKey();
            String path = "presets." + name;
            String figurePath = path + ".figure.";
            Figure figure = entry.getValue();
            fileConfiguration.set(figurePath + "type", (Object)figure.getFigureType().name());
            fileConfiguration.set(figurePath + "width", (Object)figure.getWidth());
            fileConfiguration.set(figurePath + "height", (Object)figure.getHeight());
            fileConfiguration.set(figurePath + "depth", (Object)figure.getDepth());
            fileConfiguration.set(figurePath + "width_rotation", (Object)figure.getRotationWidth());
            fileConfiguration.set(figurePath + "height_rotation", (Object)figure.getRotationHeight());
            fileConfiguration.set(figurePath + "depth_rotation", (Object)figure.getRotationDepth());
            fileConfiguration.set(figurePath + "width_offset", (Object)figure.getOffSetWidth());
            fileConfiguration.set(figurePath + "height_offset", (Object)figure.getOffSetHeight());
            fileConfiguration.set(figurePath + "depth_offset", (Object)figure.getOffSetDepth());
        }
        fileConfiguration.set(OLD_MATERIAL_PRESETS_PATH, null);
        for (Map.Entry<String, Object> entry : this.materialOptions.entrySet()) {
            fileConfiguration.set("material_presets." + ((Material)entry.getKey()).name(), entry.getValue());
        }
        ArrayList includedMaterialNames = new ArrayList(this.includedMaterials.size());
        this.includedMaterials.forEach(material -> includedMaterialNames.add(material.toString()));
        fileConfiguration.set("included_materials", includedMaterialNames);
        fileConfiguration.setComments("included_materials", List.of("", "List of block types strictly included by multibreaks.", "if empty, all block types count"));
        ArrayList arrayList = new ArrayList(this.ignoredMaterials.size());
        this.ignoredMaterials.forEach(material -> ignoredMaterialNames.add(material.toString()));
        fileConfiguration.set("ignored_materials", arrayList);
        fileConfiguration.setComments("ignored_materials", List.of("", "List of block types ignored by multibreaks."));
        fileConfiguration.set("max_break_range", (Object)this.maxRange);
        fileConfiguration.setComments("max_break_range", List.of("", "The maximum range in blocks from which a player can break blocks with multibreak.", "Needed when for example increasing the block range attribute of a player."));
    }

    public boolean load(FileConfiguration fileConfiguration) {
        this.configOptions = new HashMap<String, Figure>();
        this.materialOptions = new HashMap<Material, String>();
        boolean save = this.loadOptions(fileConfiguration);
        save = save || this.loadPresets(fileConfiguration);
        save = save || this.loadMaterialPresets(fileConfiguration);
        save = save || this.loadIncludedMaterials(fileConfiguration);
        save = save || this.loadIgnoredMaterials(fileConfiguration);
        save = save || this.loadMaxRange(fileConfiguration);
        boolean bl = save = save || this.loadFairModeLeeway(fileConfiguration);
        if (save) {
            this.save(fileConfiguration);
        }
        return save;
    }

    public boolean loadOptions(FileConfiguration fileConfiguration) {
        boolean save = false;
        int index = 0;
        for (String option : optionNames) {
            if (fileConfiguration.getKeys(false).contains(option)) {
                this.options[index] = fileConfiguration.getBoolean(option);
            } else {
                save = true;
            }
            ++index;
        }
        return save;
    }

    private boolean loadPresets(FileConfiguration fileConfiguration) {
        String path = null;
        boolean save = false;
        if (fileConfiguration.getKeys(false).contains(NEW_PRESETS_PATH)) {
            path = NEW_PRESETS_PATH;
        } else if (fileConfiguration.getKeys(false).contains(OLD_PRESETS_PATH)) {
            path = OLD_PRESETS_PATH;
            save = true;
        }
        if (path == null) {
            return save;
        }
        ConfigurationSection section = fileConfiguration.getConfigurationSection(path);
        for (String name : section.getKeys(false)) {
            ConfigurationSection section1 = section.getConfigurationSection(name).getConfigurationSection("figure");
            if (section1 == null) continue;
            FigureType figureType = FigureType.valueOf(section1.getString("type"));
            int width = section1.getInt("width");
            int height = section1.getInt("height");
            int depth = section1.getInt("depth");
            short width_rotation = (short)section1.getInt("width_rotation");
            short height_rotation = (short)section1.getInt("height_rotation");
            short depth_rotation = (short)section1.getInt("depth_rotation");
            int width_offset = section1.getInt("width_offset");
            int height_offset = section1.getInt("height_offset");
            int depth_offset = section1.getInt("depth_offset");
            Figure figure = figureType.build(width, height, depth);
            figure.setRotations(width_rotation, height_rotation, depth_rotation);
            figure.setOffsets(width_offset, height_offset, depth_offset);
            this.getConfigOptions().put(name, figure);
        }
        return save;
    }

    private boolean loadMaterialPresets(FileConfiguration fileConfiguration) {
        String path = null;
        boolean save = false;
        if (fileConfiguration.getKeys(false).contains(NEW_MATERIAL_PRESETS_PATH)) {
            path = NEW_MATERIAL_PRESETS_PATH;
        } else if (fileConfiguration.getKeys(false).contains(OLD_MATERIAL_PRESETS_PATH)) {
            path = OLD_MATERIAL_PRESETS_PATH;
            save = true;
        }
        if (path == null) {
            return save;
        }
        ConfigurationSection section = fileConfiguration.getConfigurationSection(path);
        if (section == null) {
            return save;
        }
        for (String itemtype : section.getKeys(false)) {
            String configOption = section.getString(itemtype);
            Material material = Material.valueOf((String)itemtype);
            this.getMaterialOptions().put(material, configOption);
        }
        return save;
    }

    private boolean loadIncludedMaterials(FileConfiguration fileConfiguration) {
        ArrayList defaultIgnoredNames = new ArrayList();
        boolean save = this.setIfMissing((ConfigurationSection)fileConfiguration, "included_materials", defaultIgnoredNames);
        this.includedMaterials.clear();
        List materialNames = fileConfiguration.getStringList("included_materials");
        for (String matName : materialNames) {
            Material mat = Material.getMaterial((String)matName);
            if (mat == null) continue;
            this.includedMaterials.add(mat);
        }
        return save;
    }

    private boolean loadIgnoredMaterials(FileConfiguration fileConfiguration) {
        List<String> defaultIgnoredNames = Stream.of(Material.BEDROCK).map(Enum::toString).toList();
        boolean save = this.setIfMissing((ConfigurationSection)fileConfiguration, "ignored_materials", defaultIgnoredNames);
        this.ignoredMaterials.clear();
        List materialNames = fileConfiguration.getStringList("ignored_materials");
        for (String matName : materialNames) {
            Material mat = Material.getMaterial((String)matName);
            if (mat == null) continue;
            this.ignoredMaterials.add(mat);
        }
        return save;
    }

    private boolean loadMaxRange(FileConfiguration fileConfiguration) {
        boolean save = this.setIfMissing((ConfigurationSection)fileConfiguration, "max_break_range", this.maxRange);
        if (!save) {
            this.maxRange = fileConfiguration.getInt("max_break_range");
        }
        return save;
    }

    private boolean loadFairModeLeeway(FileConfiguration fileConfiguration) {
        boolean save = this.setIfMissing((ConfigurationSection)fileConfiguration, "fair_mode_leeway", this.maxRange);
        if (!save) {
            this.fairModeTicksLeeway = fileConfiguration.getInt("fair_mode_leeway");
        }
        return save;
    }

    private boolean setIfMissing(ConfigurationSection config, String key, Object defaultValue) {
        if (!config.getKeys(false).contains(key)) {
            config.set(key, defaultValue);
            return true;
        }
        return false;
    }

    public void updateDeletePreset(FileConfiguration fileConfiguration, String name) {
        fileConfiguration.set("config_options." + name, null);
        fileConfiguration.set("presets." + name, null);
        String path = null;
        if (fileConfiguration.getKeys(false).contains(NEW_MATERIAL_PRESETS_PATH)) {
            path = NEW_MATERIAL_PRESETS_PATH;
        } else if (fileConfiguration.getKeys(false).contains(OLD_MATERIAL_PRESETS_PATH)) {
            path = OLD_MATERIAL_PRESETS_PATH;
        }
        if (path == null) {
            return;
        }
        ConfigurationSection section = fileConfiguration.getConfigurationSection(path);
        if (section == null) {
            return;
        }
        for (String materialName : section.getKeys(false)) {
            if (!name.equals(section.get(materialName))) continue;
            section.set(materialName, null);
            this.getMaterialOptions().remove(Material.valueOf((String)materialName));
        }
    }

    public Map<String, Figure> getConfigOptions() {
        return this.configOptions;
    }

    public boolean[] getOptions() {
        return this.options;
    }

    public Map<Material, String> getMaterialOptions() {
        return this.materialOptions;
    }

    public EnumSet<Material> getIncludedMaterials() {
        return this.includedMaterials;
    }

    public EnumSet<Material> getIgnoredMaterials() {
        return this.ignoredMaterials;
    }

    public int getMaxRange() {
        return this.maxRange;
    }

    public int getFairModeTicksLeeway() {
        return this.fairModeTicksLeeway;
    }
}

