/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.multibreak;

import me.vermulst.multibreak.Main;
import me.vermulst.multibreak.multibreak.BreakManager;
import me.vermulst.multibreak.multibreak.MultiBreak;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class MultiBreakRunnable
extends BukkitRunnable {
    private Block block;
    private final Player p;
    private final BreakManager breakManager;

    public MultiBreakRunnable(Block block, Player p, BreakManager breakManager) {
        this.block = block;
        this.p = p;
        this.breakManager = breakManager;
    }

    public void run() {
        MultiBreak multiBreak;
        if (this.block != null) {
            if (this.block.getType().isAir() && !this.breakManager.getTargetBlock(this.p).equals(this.block)) {
                this.cancel();
                return;
            }
            this.block = null;
        }
        if ((multiBreak = this.breakManager.getOrCreateMultiBreak(this.p)) == null) {
            this.cancel();
            return;
        }
        BlockFace blockFace = this.getBlockFace(this.p);
        if (blockFace == null) {
            this.cancel();
            return;
        }
        Vector direction = blockFace.getDirection();
        if (!multiBreak.getPlayerDirection().equals((Object)direction)) {
            if ((multiBreak = this.replaceMultiBreak(this.p, multiBreak)) == null) {
                this.cancel();
                return;
            }
            this.breakManager.scheduleMultiBreak(this.p);
        }
        multiBreak.tick();
    }

    public BlockFace getBlockFace(Player p) {
        return p.getTargetBlockFace(Main.getInstance().getConfigManager().getMaxRange());
    }

    public MultiBreak replaceMultiBreak(Player p, MultiBreak multiBreak) {
        this.breakManager.endMultiBreak(p, multiBreak, false);
        float progressBroken = multiBreak.getProgressBroken();
        int progressTicks = multiBreak.getProgressTicks();
        multiBreak = this.breakManager.getOrCreateMultiBreak(p);
        if (multiBreak == null) {
            return null;
        }
        multiBreak.setProgressBroken(progressBroken);
        multiBreak.setProgressTicks(progressTicks);
        return multiBreak;
    }
}

