/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.api;

import me.vermulst.multibreak.figure.Figure;
import me.vermulst.multibreak.item.FigureItemDataType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MultiBreakAPI {
    private static FigureItemDataType DATA_TYPE_INSTANCE;

    private MultiBreakAPI() {
    }

    @ApiStatus.Internal
    public static void init(@NotNull Plugin plugin) {
        if (DATA_TYPE_INSTANCE != null) {
            throw new IllegalStateException("MultiBreakAPI already initialized!");
        }
        DATA_TYPE_INSTANCE = new FigureItemDataType(plugin);
    }

    @NotNull
    public static ItemStack setFigure(@NotNull ItemStack itemStack, @NotNull Figure figure) {
        if (DATA_TYPE_INSTANCE == null) {
            throw new IllegalStateException("MultiBreakAPI not initialized. Load MultiBreak before.");
        }
        return DATA_TYPE_INSTANCE.set(itemStack, figure);
    }

    @Nullable
    public static Figure getFigure(@NotNull ItemStack itemStack) {
        if (DATA_TYPE_INSTANCE == null) {
            throw new IllegalStateException("MultiBreakAPI not initialized. Load MultiBreak before.");
        }
        return DATA_TYPE_INSTANCE.get(itemStack);
    }

    @NotNull
    public static ItemStack removeFigure(@NotNull ItemStack itemStack) {
        if (DATA_TYPE_INSTANCE == null) {
            throw new IllegalStateException("MultiBreakAPI not initialized. Load MultiBreak before.");
        }
        return DATA_TYPE_INSTANCE.remove(itemStack);
    }

    public static boolean hasFigure(@NotNull ItemStack itemStack) {
        if (DATA_TYPE_INSTANCE == null) {
            throw new IllegalStateException("MultiBreakAPI not initialized. Load MultiBreak before.");
        }
        return DATA_TYPE_INSTANCE.has(itemStack);
    }
}

