/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.multibreak;

import com.destroystokyo.paper.ParticleBuilder;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import me.vermulst.multibreak.CompassDirection;
import me.vermulst.multibreak.Main;
import me.vermulst.multibreak.figure.Figure;
import me.vermulst.multibreak.figure.Matrix4x4;
import me.vermulst.multibreak.figure.VectorTransformer;
import me.vermulst.multibreak.multibreak.MultiBlock;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class MultiBreak {
    private final Player p;
    private final Block block;
    private final Vector playerDirection;
    private int progressTicks;
    private List<MultiBlock> multiBlocks = new ArrayList<MultiBlock>();
    private final float destroySpeed;
    private boolean ended = false;
    private final boolean fair_mode;
    private final EnumSet<Material> ignoredMaterials;

    public MultiBreak(Player p, Block block, Figure figure, Vector playerDirection, boolean fair_mode, EnumSet<Material> ignoredMaterials) {
        this.p = p;
        this.block = block;
        this.playerDirection = playerDirection;
        this.fair_mode = fair_mode;
        this.ignoredMaterials = ignoredMaterials;
        this.initBlocks(figure, playerDirection);
        float breakSpeed = this.getBlock().getBreakSpeed(this.getPlayer());
        this.checkValid(breakSpeed);
        this.destroySpeed = 1.0E-6f + 1.0f / breakSpeed;
    }

    public void setFigure(Figure figure) {
        this.initBlocks(figure, this.playerDirection);
        float breakSpeed = this.getBlock().getBreakSpeed(this.getPlayer());
        this.checkValid(breakSpeed);
    }

    public void checkValid(float breakSpeed) {
        this.getMultiBlocks().removeIf(multiBlock -> multiBlock.getBlock().getType().equals((Object)Material.AIR));
        if (!this.fair_mode) {
            return;
        }
        this.getMultiBlocks().removeIf(multiBlock -> multiBlock.getBlock().getBreakSpeed(this.getPlayer()) < breakSpeed);
    }

    public void initBlocks(Figure figure, Vector playerDirection) {
        Object rotatedVectors;
        this.multiBlocks = new ArrayList<MultiBlock>();
        if (figure == null) {
            return;
        }
        CompassDirection compassDirection = CompassDirection.getCompassDir(this.getPlayer().getLocation());
        VectorTransformer vectorTransformer = new VectorTransformer(playerDirection, compassDirection);
        boolean rotated = (double)figure.getRotationWidth() != 0.0 || (double)figure.getRotationHeight() != 0.0 || (double)figure.getRotationDepth() != 0.0;
        Object blockVectors = figure.getVectors(rotated);
        if (rotated) {
            rotatedVectors = new HashSet();
            Matrix4x4 rotationMatrix = new Matrix4x4();
            rotationMatrix.setRotationX((double)figure.getRotationWidth() * (Math.PI / 180));
            rotationMatrix.setRotationY((double)figure.getRotationHeight() * (Math.PI / 180));
            rotationMatrix.setRotationZ((double)figure.getRotationDepth() * (Math.PI / 180));
            Iterator<Vector> iterator = blockVectors.iterator();
            while (iterator.hasNext()) {
                Vector vector = iterator.next();
                rotationMatrix.transform(vector);
                vector.setX((float)Math.round(vector.getX()));
                vector.setY((float)Math.round(vector.getY()));
                vector.setZ((float)Math.round(vector.getZ()));
                ((HashSet)rotatedVectors).add(new Vector((float)Math.round(vector.getX()), (float)Math.round(vector.getY()), (float)Math.round(vector.getZ())));
            }
            blockVectors = rotatedVectors;
        }
        rotatedVectors = blockVectors.iterator();
        while (rotatedVectors.hasNext()) {
            Vector vector = (Vector)rotatedVectors.next();
            vectorTransformer.rotateVector(vector);
        }
        blockVectors.remove(new Vector(0, 0, 0));
        Location loc = this.getBlock().getLocation();
        Iterator<Vector> iterator = blockVectors.iterator();
        while (iterator.hasNext()) {
            Vector vector = iterator.next();
            Block block1 = loc.clone().add(vector).getBlock();
            Material type = block1.getType();
            if (this.ignoredMaterials.contains(type) || block1.isLiquid() || !type.isItem()) continue;
            MultiBlock multiBlock1 = new MultiBlock(block1);
            this.getMultiBlocks().add(multiBlock1);
        }
    }

    public void tick(Main plugin, Block blockMining) {
        if (!blockMining.equals(this.getBlock())) {
            this.end(false, plugin);
        }
        ++this.progressTicks;
        if (this.progressTicks % 2 == 0) {
            this.playParticles();
        }
        this.updateBlockAnimationPacket();
        this.scheduleCancel(plugin, blockMining);
    }

    public void tick() {
        ++this.progressTicks;
        if (this.progressTicks % 2 == 0) {
            this.playParticles();
        }
        this.updateBlockAnimationPacket();
    }

    public void end(boolean finished, Main plugin) {
        this.ended = true;
        for (MultiBlock multiBlock : this.getMultiBlocks()) {
            multiBlock.writeStage(this.getPlayer(), 0.0f);
        }
        if (!finished) {
            return;
        }
        ParticleBuilder particleBuilder = new ParticleBuilder(Particle.ITEM_CRACK).count(4).offset(1.0, 0.1, 0.1).extra(0.1);
        World world = this.getBlock().getWorld();
        int size = this.getMultiBlocks().size() - 1;
        float volume = (float)(1.0 / Math.log((double)(size + 1) * Math.E));
        for (MultiBlock multiBlock : this.getMultiBlocks()) {
            if (!multiBlock.breakThisBlock()) continue;
            Block block = multiBlock.getBlock();
            Material blockType = block.getType();
            BlockData blockData = block.getBlockData().clone();
            Location location = block.getLocation();
            if (plugin.getConfigManager().getIgnoredMaterials().contains(blockType)) continue;
            block.setMetadata("multi-broken", (MetadataValue)new FixedMetadataValue((Plugin)plugin, (Object)true));
            boolean broken = this.getPlayer().breakBlock(block);
            if (!broken) continue;
            if (multiBlock.getDrops() != null) {
                for (ItemStack drop : multiBlock.getDrops()) {
                    world.dropItemNaturally(location, drop);
                }
            }
            world.playSound(location, blockData.getSoundGroup().getBreakSound(), volume, 1.0f);
            if (!multiBlock.isVisible()) continue;
            particleBuilder.data((Object)new ItemStack(blockType));
            particleBuilder.location(location.add(0.5, 0.0, 0.5)).spawn();
        }
    }

    public void playParticles() {
        ParticleBuilder particleBuilder = new ParticleBuilder(Particle.BLOCK_CRACK).offset(0.375, 0.0, 0.375);
        HashMap<Material, BlockData> blockDataHashMap = new HashMap<Material, BlockData>();
        for (MultiBlock multiBlock : this.getMultiBlocks()) {
            if (multiBlock.getBlock().equals(this.getBlock()) || !multiBlock.isVisible()) continue;
            Block block1 = multiBlock.getBlock();
            BlockData blockData = blockDataHashMap.computeIfAbsent(block1.getType(), data -> block1.getType().createBlockData());
            particleBuilder.location(block1.getLocation().add(0.5, 1.0, 0.5)).data((Object)blockData).spawn();
        }
    }

    public void updateBlockAnimationPacket() {
        float stage = (float)this.getProgressTicks() / this.getDestroySpeed();
        stage = Math.min(stage, 1.0f);
        stage = Math.max(stage, 0.0f);
        for (MultiBlock multiBlock : this.getMultiBlocks()) {
            if (multiBlock.getBlock().equals(this.getBlock()) || !multiBlock.isVisible()) continue;
            multiBlock.writeStage(this.getPlayer(), stage);
        }
    }

    public void scheduleCancel(final Main plugin, final Block targetBlock) {
        final int currentProgress = this.progressTicks;
        new BukkitRunnable(){

            public void run() {
                boolean target;
                boolean progress = currentProgress != MultiBreak.this.getProgressTicks();
                boolean bl = target = targetBlock == null || targetBlock.equals(MultiBreak.this.p.getLastTwoTargetBlocks(null, 10).get(1));
                if (target && progress) {
                    return;
                }
                for (MultiBlock multiBlock : MultiBreak.this.getMultiBlocks()) {
                    if (!multiBlock.isVisible()) continue;
                    multiBlock.writeStage(MultiBreak.this.getPlayer(), 0.0f);
                }
                MultiBreak.this.end(false, plugin);
            }
        }.runTaskLater((Plugin)plugin, 2L);
    }

    public Player getPlayer() {
        return this.p;
    }

    public Block getBlock() {
        return this.block;
    }

    public int getProgressTicks() {
        return this.progressTicks;
    }

    public List<MultiBlock> getMultiBlocks() {
        return this.multiBlocks;
    }

    public List<Block> getBlocks() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (MultiBlock multiBlock : this.getMultiBlocks()) {
            blocks.add(multiBlock.getBlock());
        }
        return blocks;
    }

    public float getDestroySpeed() {
        return this.destroySpeed;
    }

    public boolean hasEnded() {
        return this.ended;
    }

    public String toString() {
        return "MultiBreak{p=" + this.p + ", block=" + this.block + ", playerDirection=" + this.playerDirection + ", progressTicks=" + this.progressTicks + ", multiBlocks=" + this.multiBlocks + ", destroySpeed=" + this.destroySpeed + ", ended=" + this.ended + "}";
    }
}

