/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.multibreak;

import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class MultiBlock {
    private final Block block;
    private final boolean isVisible;
    private boolean breakThisBlock = true;
    private ArrayList<ItemStack> drops;
    private final int sourceID = ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE);

    public MultiBlock(Block block) {
        this.block = block;
        this.isVisible = this.initVisibility(block);
    }

    public boolean initVisibility(Block b) {
        for (BlockFace face : BlockFace.values()) {
            if (!face.isCartesian()) continue;
            Block adjacent = b.getRelative(face);
            if (adjacent.isEmpty() || adjacent.isLiquid()) {
                return true;
            }
            if (adjacent.getType().isOccluding()) continue;
            return true;
        }
        return false;
    }

    public void writeStage(Player p, float stage) {
        p.sendBlockDamage(this.getBlock().getLocation(), stage, this.sourceID);
    }

    public Block getBlock() {
        return this.block;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiBlock that = (MultiBlock)o;
        return this.isVisible == that.isVisible && Objects.equals(this.block, that.block);
    }

    public int hashCode() {
        return Objects.hash(this.block, this.isVisible);
    }

    public boolean breakThisBlock() {
        return this.breakThisBlock;
    }

    public void setBreakThisBlock(boolean breakThisBlock) {
        this.breakThisBlock = breakThisBlock;
    }

    public void setDrops(ArrayList<ItemStack> drops) {
        this.drops = drops;
    }

    public ArrayList<ItemStack> getDrops() {
        return this.drops;
    }
}

